/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTPointer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTPointer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReferenceOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.AccessorDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterNameGenerator;

public abstract class AccessorFactory {
    protected final IASTName fieldName;
    protected final IASTSimpleDeclaration fieldDeclaration;
    protected final String accessorName;
    protected boolean passByReference;

    public static AccessorFactory createFactory(AccessorDescriptor.AccessorKind kind, IASTName fieldName, IASTSimpleDeclaration fieldDeclaration, String accessorName) {
        if (kind == AccessorDescriptor.AccessorKind.GETTER) {
            return new GetterFactory(fieldName, fieldDeclaration, accessorName);
        }
        return new SetterFactory(fieldName, fieldDeclaration, accessorName);
    }

    protected AccessorFactory(IASTName fieldName, IASTSimpleDeclaration fieldDeclaration, String accessorName) {
        this.fieldName = fieldName;
        this.fieldDeclaration = fieldDeclaration;
        this.accessorName = accessorName;
    }

    public abstract IASTSimpleDeclaration createDeclaration();

    public abstract IASTFunctionDefinition createDefinition(ICPPASTQualifiedName var1);

    protected IASTDeclSpecifier getParamOrReturnDeclSpecifier() {
        IASTDeclSpecifier declSpec = this.fieldDeclaration.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations);
        if (this.passByReference || this.fieldDeclaration.getDeclarators()[0] instanceof IASTArrayDeclarator) {
            declSpec.setConst(true);
        }
        return declSpec;
    }

    private static class GetterFactory
    extends AccessorFactory {
        GetterFactory(IASTName fieldName, IASTSimpleDeclaration fieldDeclaration, String getterName) {
            super(fieldName, fieldDeclaration, getterName);
        }

        public IASTSimpleDeclaration createDeclaration() {
            CPPASTSimpleDeclaration getter = new CPPASTSimpleDeclaration();
            getter.setDeclSpecifier(this.getParamOrReturnDeclSpecifier());
            getter.addDeclarator(this.getGetterDeclarator(null));
            return getter;
        }

        public IASTFunctionDefinition createDefinition(ICPPASTQualifiedName className) {
            CPPASTFunctionDefinition getter = new CPPASTFunctionDefinition();
            getter.setDeclSpecifier(this.getParamOrReturnDeclSpecifier());
            IASTDeclarator getterDeclarator = this.getGetterDeclarator(className);
            while (!(getterDeclarator instanceof IASTFunctionDeclarator)) {
                getterDeclarator = getterDeclarator.getNestedDeclarator();
            }
            getter.setDeclarator((IASTFunctionDeclarator)getterDeclarator);
            getter.setBody((IASTStatement)this.getGetterBody());
            return getter;
        }

        private CPPASTCompoundStatement getGetterBody() {
            CPPASTCompoundStatement compound = new CPPASTCompoundStatement();
            CPPASTReturnStatement returnStatement = new CPPASTReturnStatement();
            CPPASTIdExpression idExpr = new CPPASTIdExpression();
            CPPASTName returnVal = new CPPASTName();
            returnVal.setName(this.fieldName.toCharArray());
            idExpr.setName((IASTName)returnVal);
            returnStatement.setReturnValue((IASTExpression)idExpr);
            compound.addStatement((IASTStatement)returnStatement);
            return compound;
        }

        private IASTDeclarator getGetterDeclarator(ICPPASTQualifiedName qualifiedName) {
            IASTPointerOperator pointer;
            int n;
            int n2;
            IASTPointerOperator[] iASTPointerOperatorArray;
            CPPASTName getterName = new CPPASTName();
            getterName.setName(this.accessorName.toCharArray());
            IASTDeclarator topDeclarator = this.fieldDeclaration.getDeclarators()[0].copy(IASTNode.CopyStyle.withLocations);
            if (topDeclarator instanceof IASTArrayDeclarator) {
                boolean isCpp = topDeclarator instanceof ICPPASTArrayDeclarator;
                CPPASTDeclarator decl = isCpp ? new CPPASTDeclarator() : new CASTDeclarator();
                decl.setName(topDeclarator.getName());
                decl.setNestedDeclarator(topDeclarator.getNestedDeclarator());
                decl.addPointerOperator((IASTPointerOperator)(isCpp ? new CPPASTPointer() : new CASTPointer()));
                iASTPointerOperatorArray = topDeclarator.getPointerOperators();
                n2 = iASTPointerOperatorArray.length;
                n = 0;
                while (n < n2) {
                    pointer = iASTPointerOperatorArray[n];
                    decl.addPointerOperator(pointer);
                    ++n;
                }
                topDeclarator = decl;
            }
            IASTDeclarator innermost = topDeclarator;
            while (innermost.getNestedDeclarator() != null) {
                innermost = innermost.getNestedDeclarator();
            }
            CPPASTFunctionDeclarator functionDeclarator = new CPPASTFunctionDeclarator();
            functionDeclarator.setConst(true);
            if (qualifiedName != null) {
                qualifiedName.addName((IASTName)getterName);
                functionDeclarator.setName((IASTName)qualifiedName);
            } else {
                functionDeclarator.setName((IASTName)getterName);
            }
            iASTPointerOperatorArray = innermost.getPointerOperators();
            n2 = iASTPointerOperatorArray.length;
            n = 0;
            while (n < n2) {
                pointer = iASTPointerOperatorArray[n];
                functionDeclarator.addPointerOperator(pointer.copy(IASTNode.CopyStyle.withLocations));
                ++n;
            }
            if (this.passByReference) {
                functionDeclarator.addPointerOperator((IASTPointerOperator)new CPPASTReferenceOperator(false));
            }
            if (innermost == topDeclarator) {
                return functionDeclarator;
            }
            IASTDeclarator parent = (IASTDeclarator)innermost.getParent();
            parent.setNestedDeclarator((IASTDeclarator)functionDeclarator);
            return topDeclarator;
        }
    }

    private static class SetterFactory
    extends AccessorFactory {
        SetterFactory(IASTName fieldName, IASTSimpleDeclaration fieldDeclaration, String setterName) {
            super(fieldName, fieldDeclaration, setterName);
        }

        public IASTSimpleDeclaration createDeclaration() {
            CPPASTSimpleDeclaration setter = new CPPASTSimpleDeclaration();
            setter.setDeclSpecifier((IASTDeclSpecifier)SetterFactory.getVoidDeclSpec());
            setter.addDeclarator((IASTDeclarator)this.getSetterDeclarator(null));
            return setter;
        }

        public IASTFunctionDefinition createDefinition(ICPPASTQualifiedName className) {
            CPPASTFunctionDefinition setter = new CPPASTFunctionDefinition();
            setter.setDeclSpecifier((IASTDeclSpecifier)SetterFactory.getVoidDeclSpec());
            setter.setDeclarator((IASTFunctionDeclarator)this.getSetterDeclarator(className));
            setter.setBody((IASTStatement)this.getSetterBody());
            return setter;
        }

        private CPPASTCompoundStatement getSetterBody() {
            CPPASTIdExpression idExpr;
            CPPASTCompoundStatement compound = new CPPASTCompoundStatement();
            CPPASTExpressionStatement exprStmt = new CPPASTExpressionStatement();
            CPPASTBinaryExpression binExpr = new CPPASTBinaryExpression();
            IASTDeclarator innerDeclarator = this.fieldDeclaration.getDeclarators()[0];
            while (innerDeclarator.getNestedDeclarator() != null) {
                innerDeclarator = innerDeclarator.getNestedDeclarator();
            }
            IASTName fieldName = innerDeclarator.getName();
            CPPASTName parameterName = this.getSetterParameterName();
            if (Arrays.equals(fieldName.getSimpleID(), parameterName.getSimpleID())) {
                CPPASTFieldReference fieldRef = new CPPASTFieldReference();
                CPPASTLiteralExpression litExpr = new CPPASTLiteralExpression();
                litExpr.setValue(Keywords.cTHIS);
                fieldRef.setFieldOwner((IASTExpression)litExpr);
                fieldRef.setIsPointerDereference(true);
                fieldRef.setFieldName(fieldName.copy(IASTNode.CopyStyle.withLocations));
                binExpr.setOperand1((IASTExpression)fieldRef);
            } else {
                idExpr = new CPPASTIdExpression(fieldName.copy(IASTNode.CopyStyle.withLocations));
                binExpr.setOperand1((IASTExpression)idExpr);
            }
            binExpr.setOperator(17);
            idExpr = new CPPASTIdExpression((IASTName)parameterName);
            binExpr.setOperand2((IASTExpression)idExpr);
            exprStmt.setExpression((IASTExpression)binExpr);
            compound.addStatement((IASTStatement)exprStmt);
            return compound;
        }

        private CPPASTFunctionDeclarator getSetterDeclarator(ICPPASTQualifiedName qualifiedName) {
            CPPASTName setterName = new CPPASTName();
            setterName.setName(this.accessorName.toCharArray());
            CPPASTFunctionDeclarator declarator = new CPPASTFunctionDeclarator();
            if (qualifiedName != null) {
                qualifiedName.addName((IASTName)setterName);
                declarator.setName((IASTName)qualifiedName);
            } else {
                declarator.setName((IASTName)setterName);
            }
            CPPASTParameterDeclaration parameterDeclaration = new CPPASTParameterDeclaration();
            IASTDeclarator parameterDeclarator = this.fieldDeclaration.getDeclarators()[0].copy(IASTNode.CopyStyle.withLocations);
            parameterDeclarator.setName((IASTName)this.getSetterParameterName());
            if (this.passByReference) {
                parameterDeclarator.addPointerOperator((IASTPointerOperator)new CPPASTReferenceOperator(false));
            }
            parameterDeclaration.setDeclarator(parameterDeclarator);
            parameterDeclaration.setDeclSpecifier(this.getParamOrReturnDeclSpecifier());
            declarator.addParameterDeclaration((IASTParameterDeclaration)parameterDeclaration.copy(IASTNode.CopyStyle.withLocations));
            return declarator;
        }

        private CPPASTName getSetterParameterName() {
            String parameterName = GetterSetterNameGenerator.generateSetterParameterName(this.fieldName);
            return new CPPASTName(parameterName.toCharArray());
        }

        private static CPPASTSimpleDeclSpecifier getVoidDeclSpec() {
            CPPASTSimpleDeclSpecifier declSpecifier = new CPPASTSimpleDeclSpecifier();
            declSpecifier.setType(1);
            return declSpecifier;
        }
    }
}

