/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.EmptyRefactoringDescription;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.IToggleRefactoringStrategy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.NotSupportedException;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleStrategyFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.ide.IDE;

public class ToggleRefactoring
extends CRefactoring {
    private ITextSelection selection;
    private IToggleRefactoringStrategy strategy;
    protected ToggleRefactoringContext context;
    private IIndex fIndex;

    public ToggleRefactoring(IFile file, ITextSelection selection, ICProject proj) {
        super(file, (ISelection)selection, null, proj);
        if (selection == null || file == null || this.project == null) {
            this.initStatus.addFatalError(Messages.ToggleRefactoring_InvalidSelection);
        }
        if (!IDE.saveAllEditors((IResource[])new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, (boolean)false)) {
            this.initStatus.addFatalError(Messages.ToggleRefactoring_CanNotSaveFiles);
        }
        this.selection = selection;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            try {
                pm.subTask(Messages.ToggleRefactoring_WaitingForIndexer);
                this.prepareIndexer(pm);
                pm.subTask(Messages.ToggleRefactoring_AnalyseSelection);
                this.context = new ToggleRefactoringContext(this.fIndex, this.file, this.selection);
                this.strategy = new ToggleStrategyFactory(this.context).getAppropriateStategy();
            }
            catch (InterruptedException interruptedException) {
                this.fIndex.releaseReadLock();
            }
            catch (NotSupportedException e) {
                this.initStatus.addFatalError(e.getMessage());
                this.fIndex.releaseReadLock();
            }
        }
        finally {
            this.fIndex.releaseReadLock();
        }
        return this.initStatus;
    }

    private void prepareIndexer(IProgressMonitor pm) throws CoreException, InterruptedException {
        IIndexManager im = CCorePlugin.getIndexManager();
        while (!im.isProjectIndexed(this.project)) {
            im.joinIndexer(500, pm);
            if (!pm.isCanceled()) continue;
            throw new NotSupportedException(Messages.ToggleRefactoring_NoIndex);
        }
        if (!im.isProjectIndexed(this.project)) {
            throw new NotSupportedException(Messages.ToggleRefactoring_NoIndex);
        }
        IndexerPreferences.set((IProject)this.project.getProject(), (String)"indexUnusedHeadersWithDefaultLang", (String)Boolean.TRUE.toString());
        this.fIndex = CCorePlugin.getIndexManager().getIndex(this.project);
        this.fIndex.acquireReadLock();
    }

    protected void collectModifications(IProgressMonitor pm, ModificationCollector modifications) throws CoreException {
        pm.subTask(Messages.ToggleRefactoring_CalculateModifications);
        this.strategy.run(modifications);
    }

    protected RefactoringDescriptor getRefactoringDescriptor() {
        return new EmptyRefactoringDescription();
    }
}

