/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui;

import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.cdt.debug.core.model.ITargetProperties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TCFSteppingModeTarget
implements ISteppingModeTarget,
ITargetProperties {
    private final Preferences fPreferences = new Preferences();
    private final TCFModel fModel;

    public TCFSteppingModeTarget(TCFModel model) {
        this.fPreferences.setDefault("instruction_stepping_mode", model.isInstructionSteppingEnabled());
        this.fModel = model;
    }

    public void addPropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        this.fPreferences.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        this.fPreferences.removePropertyChangeListener(listener);
    }

    public boolean supportsInstructionStepping() {
        return true;
    }

    public void enableInstructionStepping(boolean enabled) {
        this.fPreferences.setValue("instruction_stepping_mode", enabled);
        this.fModel.setInstructionSteppingEnabled(enabled);
        this.forceSourceDisplay(DebugUITools.getDebugContext());
    }

    private void forceSourceDisplay(IAdaptable debugContext) {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        ISourceDisplay sourceDisplay = (ISourceDisplay)debugContext.getAdapter(ISourceDisplay.class);
        if (sourceDisplay != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            sourceDisplay.displaySource((Object)debugContext, page, true);
        }
    }

    public boolean isInstructionSteppingEnabled() {
        return this.fPreferences.getBoolean("instruction_stepping_mode");
    }
}

