/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui.breakpoints;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.internal.tcf.cdt.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.model.TCFBreakpointsStatus;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelManager;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.dialogs.PropertyPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFBreakpointStatusPage
extends PropertyPage {
    private TreeViewer viewer;
    private List<StatusItem> status;
    private final ITreeContentProvider content_provider = new ITreeContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object input) {
            return TCFBreakpointStatusPage.this.status.toArray(new StatusItem[TCFBreakpointStatusPage.this.status.size()]);
        }

        public Object[] getChildren(Object parent) {
            StatusItem x = (StatusItem)parent;
            if (x.children == null) {
                return null;
            }
            Object[] arr = x.children.toArray(new StatusItem[x.children.size()]);
            Arrays.sort(arr);
            return arr;
        }

        public Object getParent(Object element) {
            StatusItem x = (StatusItem)element;
            return x.parent;
        }

        public boolean hasChildren(Object element) {
            StatusItem x = (StatusItem)element;
            return x.children != null && x.children.size() > 0;
        }
    };
    private final LabelProvider label_provider = new LabelProvider(){

        public Image getImage(Object element) {
            ImageDescriptor desc;
            StatusItem x = (StatusItem)element;
            if (x.object instanceof ILaunch && (desc = DebugUITools.getDefaultImageDescriptor((Object)x.object)) != null) {
                return ImageCache.getImage(desc);
            }
            if (x.has_state) {
                return DebugUITools.getImage((String)"IMG_OBJS_THREAD_RUNNING");
            }
            if (x.object != null) {
                return DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET");
            }
            if (x.planted_ok) {
                return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT");
            }
            return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT_DISABLED");
        }

        public String getText(Object element) {
            ILaunchConfiguration cfg;
            StatusItem x = (StatusItem)element;
            if (x.object instanceof ILaunch && (cfg = ((ILaunch)x.object).getLaunchConfiguration()) != null) {
                return cfg.getName();
            }
            return x.text;
        }
    };

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.status = this.getCurrentStatus();
        this.createStatusViewer(composite);
        this.setValid(true);
        return composite;
    }

    private void createStatusViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Breakpoint planting status:");
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.viewer = new TreeViewer(parent, 2048);
        this.viewer.getTree().setLayoutData((Object)data);
        this.viewer.getTree().setFont(parent.getFont());
        this.viewer.setContentProvider((IContentProvider)this.content_provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.label_provider);
        this.viewer.setInput((Object)this);
        this.viewer.expandAll();
    }

    private ICBreakpoint getBreakpoint() {
        return (ICBreakpoint)this.getElement().getAdapter(ICBreakpoint.class);
    }

    private List<StatusItem> getCurrentStatus() {
        ILaunch[] launches;
        final ArrayList<StatusCache> caches = new ArrayList<StatusCache>();
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            TCFLaunch tcf_launch;
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof TCFLaunch && !(tcf_launch = (TCFLaunch)launch).isConnecting() && !tcf_launch.isDisconnected()) {
                caches.add(new StatusCache(tcf_launch));
            }
            ++n2;
        }
        List status = (List)new TCFTask<List<StatusItem>>(10000L){

            public void run() {
                StatusCache pending = null;
                for (StatusCache cache : caches) {
                    if (cache.validate()) continue;
                    pending = cache;
                }
                if (pending != null) {
                    pending.wait((Runnable)((Object)this));
                    return;
                }
                ArrayList<StatusItem> roots = new ArrayList<StatusItem>();
                for (StatusCache cache : caches) {
                    StatusItem x = (StatusItem)cache.getData();
                    if (x == null) continue;
                    roots.add(x);
                }
                for (StatusCache cache : caches) {
                    cache.dispose();
                }
                if (roots.size() == 0) {
                    StatusItem x = new StatusItem();
                    x.text = "Not planted";
                    roots.add(x);
                }
                this.done(roots);
            }
        }.getE();
        return status;
    }

    private Object[] toObjectArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new Object[c.size()]);
    }

    private Map<String, Object> toObjectMap(Object o) {
        return (Map)o;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatusCache
    extends TCFDataCache<StatusItem> {
        final TCFLaunch launch;
        TCFDataCache<?> pending;

        public StatusCache(TCFLaunch launch) {
            super(launch.getChannel());
            this.launch = launch;
        }

        protected boolean startDataRetrieval() {
            this.pending = null;
            TCFBreakpointsStatus status = this.launch.getBreakpointsStatus();
            if (status == null) {
                this.set(null, null, null);
                return true;
            }
            Map map = status.getStatus((IBreakpoint)TCFBreakpointStatusPage.this.getBreakpoint());
            if (map == null || map.size() == 0) {
                this.set(null, null, null);
                return true;
            }
            StatusItem x = new StatusItem();
            x.object = this.launch;
            Object planted = map.get("Instances");
            if (planted != null) {
                TCFModel model = TCFModelManager.getModelManager().getModel(this.launch);
                Object[] objectArray = TCFBreakpointStatusPage.this.toObjectArray(planted);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    Map m = TCFBreakpointStatusPage.this.toObjectMap(o);
                    String ctx_id = (String)m.get("LocationContext");
                    if (!model.createNode(ctx_id, (TCFDataCache)this)) {
                        return false;
                    }
                    if (this.isValid()) {
                        this.reset();
                    } else {
                        StatusItem y = this.getNodeItem(x, model.getNode(ctx_id));
                        if (y != null) {
                            Number addr;
                            StatusItem z = new StatusItem();
                            z.text = (String)m.get("Error");
                            if (z.text == null && (addr = (Number)m.get("Address")) != null) {
                                BigInteger i = null;
                                if (addr instanceof BigInteger) {
                                    i = (BigInteger)addr;
                                }
                                if (i == null) {
                                    i = new BigInteger(addr.toString());
                                }
                                z.text = "Planted at 0x" + i.toString(16);
                                z.planted_ok = true;
                            }
                            z.parent = y;
                            if (y.children == null) {
                                y.children = new ArrayList<StatusItem>();
                            }
                            y.children.add(z);
                        }
                    }
                    ++n2;
                }
            }
            if (this.pending != null) {
                this.pending.wait((Runnable)((Object)this));
                return false;
            }
            String error = (String)map.get("Error");
            if (error != null) {
                StatusItem y = new StatusItem();
                y.text = error;
                y.parent = x;
                x.children = new ArrayList<StatusItem>();
                x.children.add(y);
            }
            this.set(null, null, x);
            return true;
        }

        private StatusItem getNodeItem(StatusItem root, TCFNode node) {
            StatusItem y2;
            Set filter;
            TCFNode parent = node.getParent();
            if (parent == null) {
                return root;
            }
            if (parent instanceof TCFNodeLaunch && (filter = this.launch.getContextFilter()) != null && !filter.contains(node.getID())) {
                return null;
            }
            StatusItem x = this.getNodeItem(root, parent);
            if (x == null) {
                return null;
            }
            if (x.children == null) {
                x.children = new ArrayList<StatusItem>();
            }
            for (StatusItem y2 : x.children) {
                if (y2.object != node) continue;
                return y2;
            }
            y2 = new StatusItem();
            y2.object = node;
            TCFDataCache cache = ((TCFNodeExecContext)node).getRunContext();
            if (!cache.validate()) {
                this.pending = cache;
            } else {
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)cache.getData();
                if (ctx != null) {
                    y2.text = ctx.getName();
                    y2.has_state = ctx.hasState();
                }
                if (y2.text == null) {
                    y2.text = node.getID();
                }
            }
            y2.parent = x;
            x.children.add(y2);
            return y2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatusItem
    implements Comparable<StatusItem> {
        Object object;
        String text;
        boolean has_state;
        boolean planted_ok;
        List<StatusItem> children;
        StatusItem parent;

        private StatusItem() {
        }

        @Override
        public int compareTo(StatusItem n) {
            if (this.object instanceof TCFNode) {
                if (n.object instanceof TCFNode) {
                    return ((Comparable)this.object).compareTo(n.object);
                }
                return 1;
            }
            if (n.object instanceof TCFNode) {
                return -1;
            }
            return 0;
        }
    }
}

