/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui.breakpoints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tm.internal.tcf.cdt.ui.breakpoints.TCFBreakpointScopeExtension;
import org.eclipse.tm.internal.tcf.cdt.ui.breakpoints.TCFBreakpointThreadFilterPage;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelManager;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;

public class TCFThreadFilterEditor {
    private TCFBreakpointThreadFilterPage fPage;
    private CheckboxTreeViewer fThreadViewer;
    private final ThreadFilterContentProvider fContentProvider;
    private final CheckHandler fCheckHandler;
    private final List<Context> fContexts = new ArrayList<Context>();
    private final Map<TCFLaunch, Context[]> fContainersPerLaunch = new HashMap<TCFLaunch, Context[]>();
    private final Map<Context, Context[]> fContextsPerContainer = new HashMap<Context, Context[]>();

    public TCFThreadFilterEditor(Composite parent, TCFBreakpointThreadFilterPage page) {
        this.fPage = page;
        this.fContentProvider = new ThreadFilterContentProvider();
        this.fCheckHandler = new CheckHandler();
        this.createThreadViewer(parent);
    }

    protected TCFBreakpointThreadFilterPage getPage() {
        return this.fPage;
    }

    private void createThreadViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Restrict to Selected Contexts:");
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fThreadViewer = new CheckboxTreeViewer(parent, 2048);
        this.fThreadViewer.addCheckStateListener((ICheckStateListener)this.fCheckHandler);
        this.fThreadViewer.getTree().setLayoutData((Object)data);
        this.fThreadViewer.getTree().setFont(parent.getFont());
        this.fThreadViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fThreadViewer.setLabelProvider((IBaseLabelProvider)new ThreadFilterLabelProvider());
        this.fThreadViewer.setInput((Object)DebugPlugin.getDefault().getLaunchManager());
        this.setInitialCheckedState();
    }

    protected Context[] getRootContexts() {
        Object input = this.fThreadViewer.getInput();
        if (!(input instanceof ILaunchManager)) {
            return new Context[0];
        }
        ArrayList<Context> targets = new ArrayList<Context>();
        ILaunch[] launches = ((ILaunchManager)input).getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch instanceof TCFLaunch && !launch.isTerminated()) {
                Context[] targetArray = this.syncGetContainers((TCFLaunch)launch);
                targets.addAll(Arrays.asList(targetArray));
            }
            ++i;
        }
        return targets.toArray(new Context[targets.size()]);
    }

    protected final CheckboxTreeViewer getThreadViewer() {
        return this.fThreadViewer;
    }

    protected void setInitialCheckedState() {
        TCFBreakpointScopeExtension filterExtension = this.fPage.getFilterExtension();
        if (filterExtension == null) {
            return;
        }
        String[] ctxIds = filterExtension.getThreadFilters();
        if (ctxIds == null) {
            Context[] contexts;
            Context[] contextArray = contexts = this.getRootContexts();
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                Context context = contextArray[n2];
                this.fCheckHandler.checkContext(context, true);
                ++n2;
            }
        } else if (ctxIds.length != 0) {
            this.getThreadViewer().expandAll();
            int i = 0;
            while (i < ctxIds.length) {
                String id = ctxIds[i];
                Context ctx = this.getContext(id);
                if (ctx != null) {
                    this.fCheckHandler.checkContext(ctx, true);
                    this.fCheckHandler.updateParentCheckState(ctx);
                } else if (id.indexOf(47) < 0) {
                    for (Context context : this.fContexts) {
                        if (!id.equals(context.fId)) continue;
                        this.fCheckHandler.checkContext(context, true);
                        this.fCheckHandler.updateParentCheckState(context);
                    }
                }
                ++i;
            }
            this.getThreadViewer().setExpandedElements(this.getThreadViewer().getCheckedElements());
        }
    }

    private Context getContainer(Context child) {
        String parentId = child.fSessionId != null ? String.valueOf(child.fSessionId) + '/' + child.fParentId : child.fParentId;
        return this.getContext(parentId);
    }

    private Context getContext(String id) {
        for (Context ctx : this.fContexts) {
            if (!ctx.fScopeId.equals(id)) continue;
            return ctx;
        }
        return null;
    }

    protected void doStore() {
        String[] threadIds;
        CheckboxTreeViewer viewer = this.getThreadViewer();
        Object[] elements = viewer.getCheckedElements();
        if (elements.length == this.fContexts.size()) {
            threadIds = null;
        } else {
            ArrayList<String> checkedIds = new ArrayList<String>();
            int i = 0;
            while (i < elements.length) {
                Context ctx = (Context)elements[i];
                if (!viewer.getGrayed((Object)ctx)) {
                    checkedIds.add(ctx.fScopeId);
                }
                ++i;
            }
            threadIds = checkedIds.toArray(new String[checkedIds.size()]);
        }
        TCFBreakpointScopeExtension filterExtension = this.fPage.getFilterExtension();
        if (filterExtension == null) {
            return;
        }
        filterExtension.setThreadFilter(threadIds);
        DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)this.fPage.getBreakpoint());
    }

    private Context[] syncGetContainers(final TCFLaunch launch) {
        Context[] result = this.fContainersPerLaunch.get(launch);
        if (result != null) {
            return result;
        }
        final String launchCfgName = launch.getLaunchConfiguration().getName();
        result = (Context[])new TCFTask<Context[]>(launch.getChannel()){

            public void run() {
                ArrayList<Context> containers = new ArrayList<Context>();
                TCFModel model = TCFModelManager.getModelManager().getModel(launch);
                TCFChildrenExecContext children = model.getRootNode().getChildren();
                if (!children.validate((Runnable)((Object)this))) {
                    return;
                }
                Map childMap = (Map)children.getData();
                for (TCFNode node : childMap.values()) {
                    if (!(node instanceof TCFNodeExecContext)) continue;
                    TCFNodeExecContext exeCtx = (TCFNodeExecContext)node;
                    TCFDataCache runCtxCache = exeCtx.getRunContext();
                    if (!runCtxCache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    IRunControl.RunControlContext runCtx = (IRunControl.RunControlContext)runCtxCache.getData();
                    containers.add(new Context(runCtx, launchCfgName));
                }
                this.done(containers.toArray(new Context[containers.size()]));
            }
        }.getE();
        this.fContexts.addAll(Arrays.asList(result));
        this.fContainersPerLaunch.put(launch, result);
        return result;
    }

    private Context[] syncGetThreads(final Context container) {
        Context[] result = this.fContextsPerContainer.get(container);
        if (result != null) {
            return result;
        }
        final TCFLaunch launch = this.getLaunch(container);
        result = (Context[])new TCFTask<Context[]>(launch.getChannel()){

            public void run() {
                ArrayList<Context> contexts = new ArrayList<Context>();
                TCFModel model = TCFModelManager.getModelManager().getModel(launch);
                TCFChildren children = ((TCFNodeExecContext)model.getNode(container.fId)).getChildren();
                if (!children.validate((Runnable)((Object)this))) {
                    return;
                }
                Collection childNodes = ((Map)children.getData()).values();
                Object[] nodes = childNodes.toArray(new TCFNode[childNodes.size()]);
                Arrays.sort(nodes);
                Object[] objectArray = nodes;
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    Object node = objectArray[n2];
                    if (node instanceof TCFNodeExecContext) {
                        TCFNodeExecContext exeCtx = (TCFNodeExecContext)node;
                        TCFDataCache runCtxCache = exeCtx.getRunContext();
                        if (!runCtxCache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        IRunControl.RunControlContext runCtx = (IRunControl.RunControlContext)runCtxCache.getData();
                        contexts.add(new Context(runCtx, container));
                    }
                    ++n2;
                }
                this.done(contexts.toArray(new Context[contexts.size()]));
            }
        }.getE();
        this.fContextsPerContainer.put(container, result);
        this.fContexts.addAll(Arrays.asList(result));
        return result;
    }

    private TCFLaunch getLaunch(Context container) {
        Context parent = this.getContainer(container);
        while (parent != null) {
            container = parent;
            parent = this.getContainer(container);
        }
        for (TCFLaunch launch : this.fContainersPerLaunch.keySet()) {
            Context[] containers;
            Context[] contextArray = containers = this.fContainersPerLaunch.get(launch);
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                Context context = contextArray[n2];
                if (context.fScopeId.equals(container.fScopeId)) {
                    return launch;
                }
                ++n2;
            }
        }
        return null;
    }

    public class CheckHandler
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof Context) {
                Context ctx = (Context)element;
                TCFThreadFilterEditor.this.getThreadViewer().expandToLevel((Object)ctx, 1);
                this.checkContext(ctx, event.getChecked());
                this.updateParentCheckState(ctx);
            }
        }

        protected void checkContext(Context ctx, boolean checked) {
            if (ctx.fIsContainer) {
                Context[] threads = TCFThreadFilterEditor.this.syncGetThreads(ctx);
                int i = 0;
                while (i < threads.length) {
                    this.checkContext(threads[i], checked);
                    ++i;
                }
            }
            this.checkThread(ctx, checked);
        }

        protected void checkThread(Context thread, boolean checked) {
            TCFThreadFilterEditor.this.getThreadViewer().setChecked((Object)thread, checked);
            TCFThreadFilterEditor.this.getThreadViewer().setGrayed((Object)thread, false);
        }

        protected void updateParentCheckState(Context thread) {
            Context parent = TCFThreadFilterEditor.this.getContainer(thread);
            if (parent == null) {
                return;
            }
            Context[] threads = TCFThreadFilterEditor.this.syncGetThreads(parent);
            int checkedNumber = 0;
            int grayedNumber = 0;
            int i = 0;
            while (i < threads.length) {
                if (TCFThreadFilterEditor.this.getThreadViewer().getGrayed((Object)threads[i])) {
                    ++grayedNumber;
                } else if (TCFThreadFilterEditor.this.getThreadViewer().getChecked((Object)threads[i])) {
                    ++checkedNumber;
                }
                ++i;
            }
            if (checkedNumber + grayedNumber == 0) {
                TCFThreadFilterEditor.this.getThreadViewer().setChecked((Object)parent, false);
                TCFThreadFilterEditor.this.getThreadViewer().setGrayed((Object)parent, false);
            } else if (checkedNumber == threads.length) {
                TCFThreadFilterEditor.this.getThreadViewer().setChecked((Object)parent, true);
                TCFThreadFilterEditor.this.getThreadViewer().setGrayed((Object)parent, false);
            } else {
                TCFThreadFilterEditor.this.getThreadViewer().setGrayChecked((Object)parent, true);
            }
            this.updateParentCheckState(parent);
        }
    }

    private static class Context {
        private final String fName;
        private final String fId;
        private final String fParentId;
        private final boolean fIsContainer;
        private final String fScopeId;
        private final String fSessionId;

        Context(IRunControl.RunControlContext ctx, Context parent) {
            this(ctx, parent.fSessionId);
        }

        Context(IRunControl.RunControlContext ctx, String sessionId) {
            String name;
            String string = name = ctx.getName() != null ? ctx.getName() : ctx.getID();
            if (sessionId != null) {
                name = String.valueOf(name) + " - " + sessionId;
            }
            this.fName = name;
            this.fSessionId = sessionId;
            this.fScopeId = sessionId != null ? String.valueOf(sessionId) + '/' + ctx.getID() : ctx.getID();
            this.fId = ctx.getID();
            this.fParentId = ctx.getParentID();
            this.fIsContainer = ctx.isContainer();
        }
    }

    public class ThreadFilterContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parent) {
            if (parent instanceof Context) {
                return TCFThreadFilterEditor.this.syncGetThreads((Context)parent);
            }
            if (parent instanceof ILaunchManager) {
                ArrayList<Context> children = new ArrayList<Context>();
                ILaunch[] launches = ((ILaunchManager)parent).getLaunches();
                int i = 0;
                while (i < launches.length) {
                    if (launches[i] instanceof TCFLaunch) {
                        Context[] targetArray = TCFThreadFilterEditor.this.syncGetContainers((TCFLaunch)launches[i]);
                        children.addAll(Arrays.asList(targetArray));
                    }
                    ++i;
                }
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Context) {
                Context ctx = (Context)element;
                if (ctx.fParentId == null) {
                    return DebugPlugin.getDefault().getLaunchManager();
                }
                return TCFThreadFilterEditor.this.getContainer(ctx);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ThreadFilterLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof Context) {
                Context ctx = (Context)element;
                if (ctx.fIsContainer) {
                    return DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET");
                }
                return DebugUITools.getImage((String)"IMG_OBJS_THREAD_RUNNING");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Context) {
                Context ctx = (Context)element;
                return ctx.fName;
            }
            return "?";
        }
    }
}

