/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tm.internal.tcf.cdt.ui.Activator;
import org.eclipse.tm.internal.tcf.cdt.ui.ImageCache;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ILocator;

public class PeerListControl
implements ISelectionProvider {
    private Tree peer_tree;
    private final PeerInfo peer_info = new PeerInfo();
    private Display display;
    private final ListenerList fSelectionListeners = new ListenerList(1);
    private String fInitialPeerId = "*";

    public PeerListControl(Composite parent) {
        this.display = parent.getDisplay();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PeerListControl.this.handleDispose();
            }
        });
        this.loadChildren(this.peer_info);
        this.createPeerListArea(parent);
    }

    public void setInitialSelectedPeerId(String peerId) {
        this.fInitialPeerId = peerId;
    }

    public Tree getTree() {
        return this.peer_tree;
    }

    private void createPeerListArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setFont(font);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.peer_tree = new Tree(composite, 268437508);
        GridData gd = new GridData(1808);
        gd.heightHint = 80;
        gd.minimumWidth = 400;
        this.peer_tree.setLayoutData((Object)gd);
        int i = 0;
        while (i < 5) {
            TreeColumn column = new TreeColumn(this.peer_tree, 16384, i);
            column.setMoveable(true);
            switch (i) {
                case 0: {
                    column.setText("Name");
                    column.setWidth(160);
                    break;
                }
                case 1: {
                    column.setText("OS");
                    column.setWidth(100);
                    break;
                }
                case 2: {
                    column.setText("Transport");
                    column.setWidth(60);
                    break;
                }
                case 3: {
                    column.setText("Host");
                    column.setWidth(100);
                    break;
                }
                case 4: {
                    column.setText("Port");
                    column.setWidth(40);
                }
            }
            ++i;
        }
        this.peer_tree.setHeaderVisible(true);
        this.peer_tree.setFont(font);
        this.peer_tree.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                PeerInfo info = PeerListControl.this.findPeerInfo(item);
                if (info == null) {
                    PeerListControl.this.updateItems(item.getParentItem(), false);
                } else {
                    PeerListControl.this.fillItem(item, info);
                }
            }
        });
        this.peer_tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                PeerListControl.this.updateItems((TreeItem)e.item, false);
            }

            public void treeExpanded(TreeEvent e) {
                PeerListControl.this.updateItems((TreeItem)e.item, true);
            }
        });
        this.peer_tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeerListControl.this.fireSelectionChangedEvent();
            }
        });
    }

    private void handleDispose() {
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                PeerListControl.this.disconnectPeer(PeerListControl.this.peer_info);
                PeerListControl.this.display = null;
            }
        });
    }

    private void disconnectPeer(PeerInfo info) {
        assert (Protocol.isDispatchThread());
        if (info.children != null) {
            PeerInfo[] peerInfoArray = info.children;
            int n = info.children.length;
            int n2 = 0;
            while (n2 < n) {
                PeerInfo p = peerInfoArray[n2];
                this.disconnectPeer(p);
                ++n2;
            }
        }
        if (info.listener != null) {
            info.locator.removeListener((ILocator.LocatorListener)info.listener);
            info.listener = null;
            info.locator = null;
        }
        if (info.channel != null) {
            info.channel.close();
        }
    }

    private boolean canHaveChildren(PeerInfo parent) {
        return parent == this.peer_info || parent.attrs.get("Proxy") != null;
    }

    private void loadChildren(final PeerInfo parent) {
        assert (Thread.currentThread() == this.display.getThread());
        if (parent.children_pending) {
            return;
        }
        assert (parent.children == null);
        parent.children_pending = true;
        parent.children_error = null;
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                if (!$assertionsDisabled && parent.listener != null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && parent.channel != null) {
                    throw new AssertionError();
                }
                if (!PeerListControl.this.canHaveChildren(parent)) {
                    PeerListControl.this.doneLoadChildren(parent, null, new PeerInfo[0]);
                } else if (parent == PeerListControl.this.peer_info) {
                    ((PeerListControl)PeerListControl.this).peer_info.locator = Protocol.getLocator();
                    PeerListControl.this.doneLoadChildren(parent, null, PeerListControl.this.createLocatorListener(PeerListControl.this.peer_info));
                } else {
                    IChannel channel;
                    parent.channel = channel = parent.peer.openChannel();
                    parent.channel.addChannelListener(new IChannel.IChannelListener(){
                        boolean opened = false;
                        boolean closed = false;

                        public void congestionLevel(int level) {
                        }

                        public void onChannelClosed(final Throwable error) {
                            if (!$assertionsDisabled && this.closed) {
                                throw new AssertionError();
                            }
                            if (parent.channel != channel) {
                                return;
                            }
                            if (!this.opened) {
                                PeerListControl.this.doneLoadChildren(parent, error, null);
                            } else if (PeerListControl.this.display != null) {
                                PeerListControl.this.display.asyncExec(new Runnable(){

                                    public void run() {
                                        if (parent.children_pending) {
                                            return;
                                        }
                                        parent.children = null;
                                        parent.children_error = error;
                                        PeerListControl.this.updateItems(parent);
                                    }
                                });
                            }
                            this.closed = true;
                            parent.channel = null;
                            parent.locator = null;
                            parent.listener = null;
                        }

                        public void onChannelOpened() {
                            if (!$assertionsDisabled && this.opened) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && this.closed) {
                                throw new AssertionError();
                            }
                            if (parent.channel != channel) {
                                return;
                            }
                            this.opened = true;
                            parent.locator = (ILocator)parent.channel.getRemoteService(ILocator.class);
                            if (parent.locator == null) {
                                PeerListControl.this.doneLoadChildren(parent, new Exception("Service not supported: Locator"), null);
                                parent.channel.close();
                            } else {
                                PeerListControl.this.doneLoadChildren(parent, null, PeerListControl.this.createLocatorListener(parent));
                            }
                        }
                    });
                }
            }
        });
    }

    private PeerInfo[] createLocatorListener(PeerInfo peer) {
        assert (Protocol.isDispatchThread());
        Map map = peer.locator.getPeers();
        ArrayList<PeerInfo> filteredPeers = new ArrayList<PeerInfo>();
        HashSet<String> agentIds = new HashSet<String>();
        for (IPeer p : map.values()) {
            String agentID = p.getAgentID();
            if (agentID == null || !agentIds.add(agentID)) continue;
            PeerInfo info = new PeerInfo();
            info.parent = peer;
            info.index = filteredPeers.size();
            info.id = p.getID();
            info.attrs = new HashMap<String, String>(p.getAttributes());
            info.peer = p;
            filteredPeers.add(info);
        }
        PeerInfo[] buf = filteredPeers.toArray(new PeerInfo[filteredPeers.size()]);
        peer.listener = new LocatorListener(peer);
        peer.locator.addListener((ILocator.LocatorListener)peer.listener);
        return buf;
    }

    private void doneLoadChildren(final PeerInfo parent, final Throwable error, final PeerInfo[] children) {
        assert (Protocol.isDispatchThread());
        assert (error == null || children == null);
        if (this.display == null) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (!$assertionsDisabled && !parent.children_pending) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && parent.children != null) {
                    throw new AssertionError();
                }
                parent.children_pending = false;
                parent.children = children;
                parent.children_error = error;
                PeerListControl.this.updateItems(parent);
            }
        });
    }

    private void updateItems(TreeItem parent_item, boolean reload) {
        final PeerInfo parent_info = this.findPeerInfo(parent_item);
        if (parent_info == null) {
            parent_item.setText("Invalid");
        } else {
            if (reload && parent_info.children_error != null) {
                this.loadChildren(parent_info);
            }
            this.display.asyncExec(new Runnable(){

                public void run() {
                    PeerListControl.this.updateItems(parent_info);
                }
            });
        }
    }

    private void updateItems(final PeerInfo parent) {
        block23: {
            TreeItem[] items;
            block25: {
                boolean expanded;
                block24: {
                    if (this.display == null) {
                        return;
                    }
                    assert (Thread.currentThread() == this.display.getThread());
                    items = null;
                    expanded = true;
                    if (parent.children != null && parent.children_error == null) break block24;
                    if (parent == this.peer_info) {
                        this.peer_tree.setItemCount(1);
                        items = this.peer_tree.getItems();
                    } else {
                        TreeItem item = this.findItem(parent);
                        if (item == null) {
                            return;
                        }
                        expanded = item.getExpanded();
                        item.setItemCount(1);
                        items = item.getItems();
                    }
                    assert (items.length == 1);
                    items[0].removeAll();
                    if (parent.children_pending) {
                        items[0].setForeground(this.display.getSystemColor(24));
                        items[0].setText("Connecting...");
                    } else if (parent.children_error != null) {
                        String msg = parent.children_error.getMessage();
                        msg = msg == null ? parent.children_error.getClass().getName() : msg.replace('\n', ' ');
                        items[0].setForeground(this.display.getSystemColor(3));
                        items[0].setText(msg);
                    } else if (expanded) {
                        this.loadChildren(parent);
                        items[0].setForeground(this.display.getSystemColor(24));
                        items[0].setText("Connecting...");
                    } else {
                        Protocol.invokeAndWait((Runnable)new Runnable(){

                            public void run() {
                                PeerListControl.this.disconnectPeer(parent);
                            }
                        });
                        items[0].setText("");
                    }
                    int n = this.peer_tree.getColumnCount();
                    int i = 1;
                    while (i < n) {
                        items[0].setText(i, "");
                        ++i;
                    }
                    items[0].setImage(null);
                    break block23;
                }
                PeerInfo[] arr = parent.children;
                if (parent == this.peer_info) {
                    this.peer_tree.setItemCount(arr.length);
                    items = this.peer_tree.getItems();
                } else {
                    TreeItem item = this.findItem(parent);
                    if (item == null) {
                        return;
                    }
                    expanded = item.getExpanded();
                    item.setItemCount(expanded ? arr.length : 1);
                    items = item.getItems();
                }
                if (!expanded) break block25;
                assert (items.length == arr.length);
                int i = 0;
                while (i < items.length) {
                    this.fillItem(items[i], arr[i]);
                    ++i;
                }
                if (this.fInitialPeerId == null) break block23;
                if ("*".equals(this.fInitialPeerId)) {
                    this.fInitialPeerId = null;
                    this.peer_tree.setSelection(items[0]);
                    this.fireSelectionChangedEvent();
                } else {
                    i = 0;
                    PeerInfo[] peerInfoArray = arr;
                    int n = arr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PeerInfo peerInfo = peerInfoArray[n2];
                        if (this.fInitialPeerId.equals(peerInfo.id)) {
                            this.fInitialPeerId = null;
                            this.peer_tree.setSelection(items[i]);
                            this.fireSelectionChangedEvent();
                            break block23;
                        }
                        ++i;
                        ++n2;
                    }
                }
                break block23;
            }
            Protocol.invokeAndWait((Runnable)new Runnable(){

                public void run() {
                    PeerListControl.this.disconnectPeer(parent);
                }
            });
            items[0].setText("");
            int n = this.peer_tree.getColumnCount();
            int i = 1;
            while (i < n) {
                items[0].setText(i, "");
                ++i;
            }
        }
    }

    public PeerInfo findPeerInfo(String peerId) {
        return this.findPeerInfo(this.peer_info, peerId);
    }

    private PeerInfo findPeerInfo(PeerInfo parent, String peerId) {
        if (peerId.equals(parent.id)) {
            return parent;
        }
        PeerInfo[] children = parent.children;
        if (children == null) {
            return null;
        }
        PeerInfo[] peerInfoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            PeerInfo child = peerInfoArray[n2];
            PeerInfo info = this.findPeerInfo(child, peerId);
            if (info != null) {
                return info;
            }
            ++n2;
        }
        return null;
    }

    public PeerInfo findPeerInfo(TreeItem item) {
        int i;
        assert (Thread.currentThread() == this.display.getThread());
        if (item == null) {
            return this.peer_info;
        }
        TreeItem parent = item.getParentItem();
        PeerInfo info = this.findPeerInfo(parent);
        if (info == null) {
            return null;
        }
        if (info.children == null) {
            return null;
        }
        if (info.children_error != null) {
            return null;
        }
        int n = i = parent == null ? this.peer_tree.indexOf(item) : parent.indexOf(item);
        if (i < 0 || i >= info.children.length) {
            return null;
        }
        assert (info.children[i].index == i);
        return info.children[i];
    }

    private TreeItem findItem(PeerInfo info) {
        if (info == null) {
            return null;
        }
        assert (info.parent != null);
        if (info.parent == this.peer_info) {
            int n = this.peer_tree.getItemCount();
            if (info.index >= n) {
                return null;
            }
            return this.peer_tree.getItem(info.index);
        }
        TreeItem i = this.findItem(info.parent);
        if (i == null) {
            return null;
        }
        int n = i.getItemCount();
        if (info.index >= n) {
            return null;
        }
        return i.getItem(info.index);
    }

    private void fillItem(TreeItem item, PeerInfo info) {
        assert (Thread.currentThread() == this.display.getThread());
        Object data = item.getData("TCFPeerInfo");
        if (data != null && data != info) {
            item.removeAll();
        }
        item.setData("TCFPeerInfo", (Object)info);
        String[] text = new String[]{info.attrs.get("Name"), info.attrs.get("OSName"), info.attrs.get("TransportName"), info.attrs.get("Host"), info.attrs.get("Port")};
        int i = 0;
        while (i < text.length) {
            if (text[i] == null) {
                text[i] = "";
            }
            ++i;
        }
        item.setText(text);
        item.setForeground(this.display.getSystemColor(24));
        item.setImage(ImageCache.getImage(this.getImageName(info)));
        if (!this.canHaveChildren(info)) {
            item.setItemCount(0);
        } else if (info.children == null || info.children_error != null) {
            item.setItemCount(1);
        } else {
            item.setItemCount(info.children.length);
        }
    }

    private String getImageName(PeerInfo info) {
        return "icons/target_tab.gif";
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        TreeItem[] items = this.peer_tree.getSelection();
        Object[] peers = new PeerInfo[items.length];
        int i = 0;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            peers[i++] = this.findPeerInfo(item);
            ++n2;
        }
        return new StructuredSelection(peers);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        this.peer_tree.deselectAll();
        if (selection instanceof IStructuredSelection) {
            Object[] elements;
            Object[] objectArray = elements = ((IStructuredSelection)selection).toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item;
                Object object = objectArray[n2];
                if (object instanceof PeerInfo && (item = this.findItem((PeerInfo)object)) != null) {
                    this.peer_tree.select(item);
                }
                ++n2;
            }
        }
    }

    private void fireSelectionChangedEvent() {
        Object[] listeners;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = listeners = this.fSelectionListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((ISelectionChangedListener)listener).selectionChanged(event);
            }
            catch (Exception e) {
                Activator.log(e);
            }
            ++n2;
        }
    }

    private class LocatorListener
    implements ILocator.LocatorListener {
        private final PeerInfo parent;

        LocatorListener(PeerInfo parent) {
            this.parent = parent;
        }

        public void peerAdded(final IPeer peer) {
            if (PeerListControl.this.display == null) {
                return;
            }
            final String id = peer.getID();
            final HashMap attrs = new HashMap(peer.getAttributes());
            PeerListControl.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] arr = ((LocatorListener)LocatorListener.this).parent.children;
                    String agentId = (String)attrs.get("AgentID");
                    PeerInfo[] peerInfoArray = arr;
                    int n = arr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PeerInfo p = peerInfoArray[n2];
                        if (!$assertionsDisabled && p.id.equals(id)) {
                            throw new AssertionError();
                        }
                        if (agentId != null && agentId.equals(p.attrs.get("AgentID"))) {
                            return;
                        }
                        ++n2;
                    }
                    PeerInfo[] buf = new PeerInfo[arr.length + 1];
                    System.arraycopy(arr, 0, buf, 0, arr.length);
                    PeerInfo info = new PeerInfo();
                    info.parent = LocatorListener.this.parent;
                    info.index = arr.length;
                    info.id = id;
                    info.attrs = attrs;
                    info.peer = peer;
                    buf[arr.length] = info;
                    ((LocatorListener)LocatorListener.this).parent.children = buf;
                    PeerListControl.this.updateItems(LocatorListener.this.parent);
                }
            });
        }

        public void peerChanged(final IPeer peer) {
            if (PeerListControl.this.display == null) {
                return;
            }
            final String id = peer.getID();
            final HashMap attrs = new HashMap(peer.getAttributes());
            PeerListControl.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] arr = ((LocatorListener)LocatorListener.this).parent.children;
                    int i = 0;
                    while (i < arr.length) {
                        if (arr[i].id.equals(id)) {
                            arr[i].attrs = attrs;
                            arr[i].peer = peer;
                            PeerListControl.this.updateItems(LocatorListener.this.parent);
                        }
                        ++i;
                    }
                }
            });
        }

        public void peerRemoved(final String id) {
            if (PeerListControl.this.display == null) {
                return;
            }
            PeerListControl.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] arr = ((LocatorListener)LocatorListener.this).parent.children;
                    PeerInfo[] buf = new PeerInfo[arr.length - 1];
                    int j = 0;
                    int i = 0;
                    while (i < arr.length) {
                        if (arr[i].id.equals(id)) {
                            final PeerInfo info = arr[i];
                            Protocol.invokeLater((Runnable)new Runnable(){

                                public void run() {
                                    PeerListControl.this.disconnectPeer(info);
                                }
                            });
                        } else {
                            arr[i].index = j;
                            buf[j++] = arr[i];
                        }
                        ++i;
                    }
                    ((LocatorListener)LocatorListener.this).parent.children = buf;
                    PeerListControl.this.updateItems(LocatorListener.this.parent);
                }
            });
        }

        public void peerHeartBeat(final String id) {
            if (PeerListControl.this.display == null) {
                return;
            }
            PeerListControl.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] arr = ((LocatorListener)LocatorListener.this).parent.children;
                    int i = 0;
                    while (i < arr.length) {
                        if (arr[i].id.equals(id)) {
                            if (arr[i].children_error == null) break;
                            TreeItem item = PeerListControl.this.findItem(arr[i]);
                            boolean visible = item != null;
                            while (visible && item != null) {
                                if (!item.getExpanded()) {
                                    visible = false;
                                }
                                item = item.getParentItem();
                            }
                            if (!visible) break;
                            PeerListControl.this.loadChildren(arr[i]);
                            break;
                        }
                        ++i;
                    }
                }
            });
        }
    }

    static class PeerInfo {
        PeerInfo parent;
        int index;
        String id;
        Map<String, String> attrs;
        PeerInfo[] children;
        boolean children_pending;
        Throwable children_error;
        IPeer peer;
        IChannel channel;
        ILocator locator;
        LocatorListener listener;

        PeerInfo() {
        }
    }
}

