/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.services.IMemoryMap;

public class MemoryMapProxy
implements IMemoryMap {
    private final IChannel channel;
    private final Map<IMemoryMap.MemoryMapListener, IChannel.IEventListener> listeners = new HashMap<IMemoryMap.MemoryMapListener, IChannel.IEventListener>();

    static {
        JSON.addObjectWriter(IMemoryMap.MemoryRegion.class, new JSON.ObjectWriter<IMemoryMap.MemoryRegion>(){

            @Override
            public void write(IMemoryMap.MemoryRegion r) throws IOException {
                JSON.writeObject(r.getProperties());
            }
        });
    }

    public MemoryMapProxy(IChannel channel) {
        this.channel = channel;
    }

    public String getName() {
        return "MemoryMap";
    }

    public IToken get(String id, final IMemoryMap.DoneGet done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"get", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                IMemoryMap.MemoryRegion[] map = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    map = MemoryMapProxy.this.toMemoryMap(args[1]);
                }
                done.doneGet(this.token, error, map);
            }
        }.token;
    }

    public IToken set(String id, IMemoryMap.MemoryRegion[] map, final IMemoryMap.DoneSet done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"set", (Object[])new Object[]{id, map}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneSet(this.token, error);
            }
        }.token;
    }

    private IMemoryMap.MemoryRegion[] toMemoryMap(Object o) {
        if (o == null) {
            return null;
        }
        int i = 0;
        Collection c = (Collection)o;
        IMemoryMap.MemoryRegion[] map = new IMemoryMap.MemoryRegion[c.size()];
        for (Object x : c) {
            map[i++] = this.toMemoryRegion(x);
        }
        return map;
    }

    private IMemoryMap.MemoryRegion toMemoryRegion(Object o) {
        if (o == null) {
            return null;
        }
        return new Region((Map)o);
    }

    public void addListener(final IMemoryMap.MemoryMapListener listener) {
        IChannel.IEventListener l = new IChannel.IEventListener(){

            public void event(String name, byte[] data) {
                try {
                    Object[] args = JSON.parseSequence(data);
                    if (name.equals("changed")) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                    } else {
                        throw new IOException("Memory Map service: unknown event: " + name);
                    }
                    listener.changed((String)args[0]);
                }
                catch (Throwable x) {
                    MemoryMapProxy.this.channel.terminate(x);
                }
            }
        };
        this.channel.addEventListener(this, l);
        this.listeners.put(listener, l);
    }

    public void removeListener(IMemoryMap.MemoryMapListener listener) {
        IChannel.IEventListener l = this.listeners.remove(listener);
        if (l != null) {
            this.channel.removeEventListener(this, l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Region
    implements IMemoryMap.MemoryRegion {
        final Map<String, Object> props;

        Region(Map<String, Object> props) {
            this.props = props;
        }

        @Override
        public Number getAddress() {
            return (Number)this.props.get("Addr");
        }

        @Override
        public Number getOffset() {
            return (Number)this.props.get("Offs");
        }

        @Override
        public Number getSize() {
            return (Number)this.props.get("Size");
        }

        @Override
        public String getFileName() {
            return (String)this.props.get("FileName");
        }

        @Override
        public String getSectionName() {
            return (String)this.props.get("SectionName");
        }

        @Override
        public int getFlags() {
            Number n = (Number)this.props.get("Flags");
            if (n != null) {
                return n.intValue();
            }
            return 0;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }
    }
}

