/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.services.IPathMap;

public class PathMapProxy
implements IPathMap {
    private final IChannel channel;

    static {
        JSON.addObjectWriter(IPathMap.PathMapRule.class, new JSON.ObjectWriter<IPathMap.PathMapRule>(){

            @Override
            public void write(IPathMap.PathMapRule r) throws IOException {
                JSON.writeObject(r.getProperties());
            }
        });
    }

    public PathMapProxy(IChannel channel) {
        this.channel = channel;
    }

    public String getName() {
        return "PathMap";
    }

    public IToken get(final IPathMap.DoneGet done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"get", null){

            public void done(Exception error, Object[] args) {
                IPathMap.PathMapRule[] map = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    map = PathMapProxy.this.toPathMap(args[1]);
                }
                done.doneGet(this.token, error, map);
            }
        }.token;
    }

    public IToken set(IPathMap.PathMapRule[] map, final IPathMap.DoneSet done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"set", (Object[])new Object[]{map}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneSet(this.token, error);
            }
        }.token;
    }

    private IPathMap.PathMapRule[] toPathMap(Object o) {
        if (o == null) {
            return null;
        }
        int i = 0;
        Collection c = (Collection)o;
        IPathMap.PathMapRule[] map = new IPathMap.PathMapRule[c.size()];
        for (Object x : c) {
            map[i++] = this.toPathMapRule(x);
        }
        return map;
    }

    private IPathMap.PathMapRule toPathMapRule(Object o) {
        if (o == null) {
            return null;
        }
        return new MapRule((Map)o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapRule
    implements IPathMap.PathMapRule {
        final Map<String, Object> props;

        MapRule(Map<String, Object> props) {
            this.props = props;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getSource() {
            return (String)this.props.get("Source");
        }

        @Override
        public String getDestination() {
            return (String)this.props.get("Destination");
        }

        @Override
        public String getHost() {
            return (String)this.props.get("Host");
        }

        @Override
        public String getProtocol() {
            return (String)this.props.get("Protocol");
        }

        public String toString() {
            return this.props.toString();
        }
    }
}

