/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.ISysMonitor;

public class SysMonitorProxy
implements ISysMonitor {
    private final IChannel channel;

    public SysMonitorProxy(IChannel channel) {
        this.channel = channel;
    }

    public String getName() {
        return "SysMonitor";
    }

    public IToken getChildren(String parent_context_id, final ISysMonitor.DoneGetChildren done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getChildren", (Object[])new Object[]{parent_context_id}){

            public void done(Exception error, Object[] args) {
                String[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = SysMonitorProxy.toStringArray(args[1]);
                }
                done.doneGetChildren(this.token, error, arr);
            }
        }.token;
    }

    public IToken getContext(String id, final ISysMonitor.DoneGetContext done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getContext", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                SysMonitorContext ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new SysMonitorContext((Map)args[1]);
                    }
                }
                done.doneGetContext(this.token, error, ctx);
            }
        }.token;
    }

    public IToken getCommandLine(String id, final ISysMonitor.DoneGetCommandLine done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getCommandLine", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                String[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = SysMonitorProxy.toStringArray(args[1]);
                }
                done.doneGetCommandLine(this.token, error, arr);
            }
        }.token;
    }

    public IToken getEnvironment(String id, final ISysMonitor.DoneGetEnvironment done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getEnvironment", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                String[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = SysMonitorProxy.toStringArray(args[1]);
                }
                done.doneGetEnvironment(this.token, error, arr);
            }
        }.token;
    }

    private static String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SysMonitorContext
    implements ISysMonitor.SysMonitorContext {
        private final Map<String, Object> props;

        SysMonitorContext(Map<String, Object> props) {
            this.props = props;
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getCurrentWorkingDirectory() {
            return (String)this.props.get("CWD");
        }

        @Override
        public String getFile() {
            return (String)this.props.get("File");
        }

        @Override
        public String getParentID() {
            return (String)this.props.get("ParentID");
        }

        @Override
        public String getRoot() {
            return (String)this.props.get("Root");
        }

        @Override
        public String getGroupName() {
            return (String)this.props.get("GroupName");
        }

        @Override
        public long getPGRP() {
            if (!this.props.containsKey("PGRP")) {
                return -1L;
            }
            return ((Number)this.props.get("PGRP")).longValue();
        }

        @Override
        public long getPID() {
            if (!this.props.containsKey("PID")) {
                return -1L;
            }
            return ((Number)this.props.get("PID")).longValue();
        }

        @Override
        public long getPPID() {
            if (!this.props.containsKey("PPID")) {
                return -1L;
            }
            return ((Number)this.props.get("PPID")).longValue();
        }

        @Override
        public long getRSS() {
            if (!this.props.containsKey("RSS")) {
                return -1L;
            }
            return ((Number)this.props.get("RSS")).longValue();
        }

        @Override
        public String getState() {
            return (String)this.props.get("State");
        }

        @Override
        public long getTGID() {
            if (!this.props.containsKey("TGID")) {
                return -1L;
            }
            return ((Number)this.props.get("TGID")).longValue();
        }

        @Override
        public long getTracerPID() {
            if (!this.props.containsKey("TracerPID")) {
                return -1L;
            }
            return ((Number)this.props.get("TracerPID")).longValue();
        }

        @Override
        public long getUGID() {
            if (!this.props.containsKey("UGID")) {
                return -1L;
            }
            return ((Number)this.props.get("UGID")).longValue();
        }

        @Override
        public long getUID() {
            if (!this.props.containsKey("UID")) {
                return -1L;
            }
            return ((Number)this.props.get("UID")).longValue();
        }

        @Override
        public String getUserName() {
            return (String)this.props.get("UserName");
        }

        @Override
        public long getVSize() {
            if (!this.props.containsKey("VSize")) {
                return -1L;
            }
            return ((Number)this.props.get("VSize")).longValue();
        }

        @Override
        public long getPSize() {
            if (!this.props.containsKey("PSize")) {
                return -1L;
            }
            return ((Number)this.props.get("PSize")).longValue();
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }

        public String toString() {
            return "[Sys Monitor Context " + this.props.toString() + "]";
        }
    }
}

