/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.services;

import java.util.Map;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;

public interface IRunControl
extends IService {
    public static final String NAME = "RunControl";
    public static final String PROP_ID = "ID";
    public static final String PROP_PARENT_ID = "ParentID";
    public static final String PROP_PROCESS_ID = "ProcessID";
    public static final String PROP_CREATOR_ID = "CreatorID";
    public static final String PROP_NAME = "Name";
    public static final String PROP_IS_CONTAINER = "IsContainer";
    public static final String PROP_HAS_STATE = "HasState";
    public static final String PROP_CAN_RESUME = "CanResume";
    public static final String PROP_CAN_COUNT = "CanCount";
    public static final String PROP_CAN_SUSPEND = "CanSuspend";
    public static final String PROP_CAN_TERMINATE = "CanTerminate";
    public static final String PROP_RC_GROUP = "RCGroup";
    public static final int RM_RESUME = 0;
    public static final int RM_STEP_OVER = 1;
    public static final int RM_STEP_INTO = 2;
    public static final int RM_STEP_OVER_LINE = 3;
    public static final int RM_STEP_INTO_LINE = 4;
    public static final int RM_STEP_OUT = 5;
    public static final int RM_REVERSE_RESUME = 6;
    public static final int RM_REVERSE_STEP_OVER = 7;
    public static final int RM_REVERSE_STEP_INTO = 8;
    public static final int RM_REVERSE_STEP_OVER_LINE = 9;
    public static final int RM_REVERSE_STEP_INTO_LINE = 10;
    public static final int RM_REVERSE_STEP_OUT = 11;
    public static final int RM_STEP_OVER_RANGE = 12;
    public static final int RM_STEP_INTO_RANGE = 13;
    public static final int RM_REVERSE_STEP_OVER_RANGE = 14;
    public static final int RM_REVERSE_STEP_INTO_RANGE = 15;
    public static final int RM_UNTIL_ACTIVE = 16;
    public static final int RM_REVERSE_UNTIL_ACTIVE = 17;
    public static final String REASON_USER_REQUEST = "Suspended";
    public static final String REASON_STEP = "Step";
    public static final String REASON_BREAKPOINT = "Breakpoint";
    public static final String REASON_EXCEPTION = "Exception";
    public static final String REASON_CONTAINER = "Container";
    public static final String REASON_WATCHPOINT = "Watchpoint";
    public static final String REASON_SIGNAL = "Signal";
    public static final String REASON_SHAREDLIB = "Shared Library";
    public static final String REASON_ERROR = "Error";
    public static final String STATE_SIGNAL = "Signal";
    public static final String STATE_SIGNAL_NAME = "SignalName";
    public static final String STATE_SIGNAL_DESCRIPTION = "SignalDescription";
    public static final String STATE_BREAKPOINT_IDS = "BPs";
    public static final String STATE_PC_ERROR = "PCError";
    public static final String RP_RANGE_START = "RangeStart";
    public static final String RP_RANGE_END = "RangeEnd";

    public IToken getContext(String var1, DoneGetContext var2);

    public IToken getChildren(String var1, DoneGetChildren var2);

    public void addListener(RunControlListener var1);

    public void removeListener(RunControlListener var1);

    public static interface DoneCommand {
        public void doneCommand(IToken var1, Exception var2);
    }

    public static interface DoneGetChildren {
        public void doneGetChildren(IToken var1, Exception var2, String[] var3);
    }

    public static interface DoneGetContext {
        public void doneGetContext(IToken var1, Exception var2, RunControlContext var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoneGetState {
        public void doneGetState(IToken var1, Exception var2, boolean var3, String var4, String var5, Map<String, Object> var6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RunControlContext {
        public Map<String, Object> getProperties();

        public String getID();

        public String getParentID();

        public String getProcessID();

        public String getCreatorID();

        public String getName();

        public boolean isContainer();

        public boolean hasState();

        public boolean canSuspend();

        public boolean canResume(int var1);

        public boolean canCount(int var1);

        public boolean canTerminate();

        public String getRCGroup();

        public IToken getState(DoneGetState var1);

        public IToken suspend(DoneCommand var1);

        public IToken resume(int var1, int var2, DoneCommand var3);

        public IToken resume(int var1, int var2, Map<String, Object> var3, DoneCommand var4);

        public IToken terminate(DoneCommand var1);
    }

    public static class RunControlError
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RunControlListener {
        public void contextAdded(RunControlContext[] var1);

        public void contextChanged(RunControlContext[] var1);

        public void contextRemoved(String[] var1);

        public void contextSuspended(String var1, String var2, String var3, Map<String, Object> var4);

        public void contextResumed(String var1);

        public void containerSuspended(String var1, String var2, String var3, Map<String, Object> var4, String[] var5);

        public void containerResumed(String[] var1);

        public void contextException(String var1, String var2);
    }
}

