/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.tcf.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tm.internal.tcf.debug.ui.commands.MemoryMapDialog;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeArrayPartition;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExpression;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeModule;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;

public class MemoryMapCommand
extends AbstractActionDelegate {
    private static boolean isValidNode(final TCFNode n) {
        if (n instanceof TCFNodeLaunch) {
            return true;
        }
        if (n instanceof TCFNodeExecContext) {
            return (Boolean)new TCFTask<Boolean>(n.getChannel()){

                public void run() {
                    TCFDataCache<TCFNodeExecContext> mem_cache = n.getModel().searchMemoryContext(n);
                    if (mem_cache == null) {
                        this.done(false);
                        return;
                    }
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (mem_cache.getError() != null) {
                        this.done(false);
                        return;
                    }
                    TCFNodeExecContext node = (TCFNodeExecContext)mem_cache.getData();
                    this.done(node != null && node.getMemoryContext().getData() != null);
                }
            }.getE();
        }
        if (n instanceof TCFNodeStackFrame) {
            return true;
        }
        if (n instanceof TCFNodeExpression) {
            return true;
        }
        if (n instanceof TCFNodeArrayPartition) {
            return true;
        }
        return n instanceof TCFNodeModule;
    }

    protected void selectionChanged() {
        TCFNode n = this.getSelectedNode();
        this.getAction().setEnabled(MemoryMapCommand.isValidNode(n));
    }

    protected void run() {
        TCFNode n = this.getSelectedNode();
        if (MemoryMapCommand.isValidNode(n)) {
            Shell shell = this.getWindow().getShell();
            try {
                new MemoryMapDialog(shell, n).open();
            }
            catch (Throwable x) {
                MessageBox mb = new MessageBox(shell, 33);
                mb.setText("Cannot open Symbol Files dialog");
                mb.setMessage(TCFModel.getErrorMessage(x, true));
                mb.open();
            }
        }
    }
}

