/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.tcf.debug.model.ITCFBreakpointListener;
import org.eclipse.tm.internal.tcf.debug.model.TCFBreakpoint;
import org.eclipse.tm.internal.tcf.debug.model.TCFBreakpointsStatus;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFAnnotationManager {
    private TCFLaunch active_launch;
    private final HashMap<IWorkbenchWindow, WorkbenchWindowInfo> windows = new HashMap();
    private final TCFLaunch.LaunchListener launch_listener = new TCFLaunch.LaunchListener(){

        public void onCreated(TCFLaunch launch) {
        }

        public void onConnected(final TCFLaunch launch) {
            TCFAnnotationManager.this.updateActiveLaunch();
            TCFBreakpointsStatus bps = launch.getBreakpointsStatus();
            if (bps == null) {
                return;
            }
            bps.addListener(new ITCFBreakpointListener(){

                public void breakpointStatusChanged(String id) {
                    TCFAnnotationManager.this.displayExec(new Runnable(){

                        public void run() {
                            if (TCFAnnotationManager.this.active_launch != launch) {
                                return;
                            }
                            TCFAnnotationManager.this.refreshBreakpointView();
                        }
                    });
                }

                public void breakpointRemoved(String id) {
                    TCFAnnotationManager.this.displayExec(new Runnable(){

                        public void run() {
                            if (TCFAnnotationManager.this.active_launch != launch) {
                                return;
                            }
                            TCFAnnotationManager.this.refreshBreakpointView();
                        }
                    });
                }

                public void breakpointChanged(String id) {
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDisconnected(final TCFLaunch launch) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            Class<Device> clazz = Device.class;
            synchronized (Device.class) {
                TCFAnnotationManager.this.displayExec(new Runnable(){

                    public void run() {
                        for (WorkbenchWindowInfo info : TCFAnnotationManager.this.windows.values()) {
                            Iterator<TCFAnnotation> i = info.annotations.iterator();
                            while (i.hasNext()) {
                                TCFAnnotation a = i.next();
                                if (a.model.getLaunch() != launch) continue;
                                i.remove();
                                a.dispose();
                            }
                        }
                    }
                });
                // ** MonitorExit[var2_2] (shouldn't be in output)
                TCFAnnotationManager.this.updateActiveLaunch();
                return;
            }
        }

        public void onProcessOutput(TCFLaunch launch, String process_id, int stream_id, byte[] data) {
        }

        public void onProcessStreamError(TCFLaunch launch, String process_id, int stream_id, Exception error, int lost_size) {
        }
    };
    private final ISelectionListener selection_listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            TCFAnnotationManager.this.updateActiveLaunch();
        }
    };
    private final IWindowListener window_listener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
            TCFAnnotationManager.this.updateActiveLaunch();
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (!$assertionsDisabled && TCFAnnotationManager.this.windows.get(window) == null) {
                throw new AssertionError();
            }
            window.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", TCFAnnotationManager.this.selection_listener);
            ((WorkbenchWindowInfo)TCFAnnotationManager.this.windows.remove(window)).dispose();
            TCFAnnotationManager.this.updateActiveLaunch();
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            TCFAnnotationManager.this.updateActiveLaunch();
        }

        public void windowOpened(IWorkbenchWindow window) {
            if (TCFAnnotationManager.this.windows.get(window) != null) {
                return;
            }
            window.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", TCFAnnotationManager.this.selection_listener);
            TCFAnnotationManager.this.windows.put(window, new WorkbenchWindowInfo());
            TCFAnnotationManager.this.updateActiveLaunch();
        }
    };
    private final Display display = Display.getDefault();
    private int refresh_breakpoint_view_cnt = 0;
    private int update_active_launch_cnt = 0;
    private boolean started;
    private boolean disposed;

    public TCFAnnotationManager() {
        assert (Protocol.isDispatchThread());
        TCFLaunch.addListener((TCFLaunch.LaunchListener)this.launch_listener);
        this.displayExec(new Runnable(){

            public void run() {
                if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                    TCFAnnotationManager.this.display.timerExec(200, (Runnable)this);
                } else if (!PlatformUI.getWorkbench().isClosing()) {
                    TCFAnnotationManager.this.started = true;
                    PlatformUI.getWorkbench().addWindowListener(TCFAnnotationManager.this.window_listener);
                    IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                    int n = iWorkbenchWindowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        TCFAnnotationManager.this.window_listener.windowOpened(window);
                        ++n2;
                    }
                    IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (w != null) {
                        TCFAnnotationManager.this.window_listener.windowActivated(w);
                    }
                }
            }
        });
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        assert (Protocol.isDispatchThread());
        this.disposed = true;
        TCFLaunch.removeListener((TCFLaunch.LaunchListener)this.launch_listener);
        this.displayExec(new Runnable(){

            public void run() {
                if (!TCFAnnotationManager.this.started) {
                    return;
                }
                PlatformUI.getWorkbench().removeWindowListener(TCFAnnotationManager.this.window_listener);
                for (IWorkbenchWindow window : TCFAnnotationManager.this.windows.keySet()) {
                    window.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", TCFAnnotationManager.this.selection_listener);
                    ((WorkbenchWindowInfo)TCFAnnotationManager.this.windows.get(window)).dispose();
                }
                TCFAnnotationManager.this.windows.clear();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayExec(Runnable r) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (!this.display.isDisposed()) {
                this.display.asyncExec(r);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void updateActiveLaunch() {
        assert (!this.disposed);
        final int cnt = ++this.update_active_launch_cnt;
        this.displayExec(new Runnable(){

            public void run() {
                ILaunch x;
                if (cnt != TCFAnnotationManager.this.update_active_launch_cnt) {
                    return;
                }
                TCFLaunch launch = null;
                IAdaptable adaptable = DebugUITools.getDebugContext();
                if (adaptable != null && (x = (ILaunch)adaptable.getAdapter(ILaunch.class)) instanceof TCFLaunch) {
                    final TCFLaunch l = (TCFLaunch)x;
                    final boolean[] b = new boolean[1];
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        public void run() {
                            IChannel channel = l.getChannel();
                            b[0] = channel != null && channel.getState() == 1;
                        }
                    });
                    if (b[0]) {
                        launch = l;
                    }
                }
                if (TCFAnnotationManager.this.active_launch != launch) {
                    TCFAnnotationManager.this.active_launch = launch;
                    TCFAnnotationManager.this.refreshBreakpointView();
                }
            }
        });
    }

    private void refreshBreakpointView() {
        assert (!this.disposed);
        final int cnt = ++this.refresh_breakpoint_view_cnt;
        this.displayExec(new Runnable(){

            public void run() {
                if (cnt != TCFAnnotationManager.this.refresh_breakpoint_view_cnt) {
                    return;
                }
                for (IWorkbenchWindow window : TCFAnnotationManager.this.windows.keySet()) {
                    IDebugView view = (IDebugView)window.getActivePage().findView("org.eclipse.debug.ui.BreakpointView");
                    if (view == null) continue;
                    view.getViewer().refresh();
                }
            }
        });
    }

    String getBreakpointStatus(TCFBreakpoint breakpoint) {
        Map map;
        TCFBreakpointsStatus bs;
        assert (Protocol.isDispatchThread());
        if (this.disposed) {
            return null;
        }
        TCFLaunch launch = this.active_launch;
        if (launch != null && launch.getBreakpointsStatus() != null && (bs = launch.getBreakpointsStatus()) != null && (map = bs.getStatus((IBreakpoint)breakpoint)) != null) {
            String status = null;
            String error = (String)map.get("Error");
            Object planted = map.get("Instances");
            if (error != null) {
                status = error;
            } else if (planted != null) {
                status = "Planted";
            }
            return status;
        }
        return null;
    }

    void addStackFrameAnnotation(TCFModel model, String exe_id, boolean top_frame, IWorkbenchPage page, ITextEditor editor, IRegion region) {
        WorkbenchWindowInfo info;
        IEditorInput editor_input;
        IDocumentProvider doc_provider;
        if (this.disposed) {
            return;
        }
        assert (Thread.currentThread() == this.display.getThread());
        TCFAnnotation annotation = null;
        IAnnotationModel ann_model = null;
        if (editor != null && region != null && (ann_model = (doc_provider = editor.getDocumentProvider()).getAnnotationModel((Object)(editor_input = editor.getEditorInput()))) != null) {
            Image image;
            String text;
            String type;
            if (top_frame) {
                type = "org.eclipse.tm.tcf.debug.top_frame";
                text = "Debug Current Instruction Pointer";
                image = DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER_TOP");
            } else {
                type = "org.eclipse.tm.tcf.debug.stack_frame";
                text = "Debug Stack Frame";
                image = DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER");
            }
            annotation = new TCFAnnotation(model, exe_id, editor, image, new Position(region.getOffset(), region.getLength()));
            annotation.setType(type);
            annotation.setText(text);
        }
        if (page != null && (info = this.windows.get(page.getWorkbenchWindow())) != null) {
            if (annotation != null && info.annotations.size() == 1) {
                for (TCFAnnotation a : info.annotations) {
                    if (a.model != annotation.model || a.editor != annotation.editor || a.image != annotation.image || !a.exe_id.equals(annotation.exe_id) || !a.position.equals((Object)annotation.position) || !a.getType().equals(annotation.getType()) || !a.getText().equals(annotation.getText())) continue;
                    return;
                }
            }
            for (TCFAnnotation a : info.annotations) {
                a.dispose();
            }
            info.annotations.clear();
            if (annotation != null) {
                ann_model.addAnnotation(annotation, annotation.position);
                info.annotations.add(annotation);
            }
        }
    }

    void removeStackFrameAnnotation(TCFModel model, Set<String> ids) {
        if (this.disposed) {
            return;
        }
        assert (Thread.currentThread() == this.display.getThread());
        for (WorkbenchWindowInfo info : this.windows.values()) {
            Iterator<TCFAnnotation> i = info.annotations.iterator();
            while (i.hasNext()) {
                TCFAnnotation a = i.next();
                if (a.model != model || !ids.contains(a.exe_id)) continue;
                i.remove();
                a.dispose();
            }
        }
    }

    class TCFAnnotation
    extends Annotation {
        final TCFModel model;
        final String exe_id;
        final ITextEditor editor;
        final Image image;
        final Position position;

        TCFAnnotation(TCFModel model, String exe_id, ITextEditor editor, Image image, Position position) {
            this.model = model;
            this.exe_id = exe_id;
            this.editor = editor;
            this.image = image;
            this.position = position;
        }

        protected Image getImage() {
            return this.image;
        }

        void dispose() {
            IAnnotationModel ann_model;
            assert (Thread.currentThread() == TCFAnnotationManager.this.display.getThread());
            IDocumentProvider doc_provider = this.editor.getDocumentProvider();
            IEditorInput editor_input = this.editor.getEditorInput();
            if (doc_provider != null && (ann_model = doc_provider.getAnnotationModel((Object)editor_input)) != null) {
                ann_model.removeAnnotation((Annotation)this);
            }
        }
    }

    private class WorkbenchWindowInfo {
        final ArrayList<TCFAnnotation> annotations = new ArrayList();

        private WorkbenchWindowInfo() {
        }

        void dispose() {
            for (TCFAnnotation a : this.annotations) {
                a.dispose();
            }
            this.annotations.clear();
        }
    }
}

