/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.tm.internal.tcf.debug.launch.TCFLocalAgent;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IPathMap;
import org.eclipse.tm.tcf.util.TCFTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFLaunchDelegate
extends LaunchConfigurationDelegate {
    public static final String ATTR_PEER_ID = "org.eclipse.tm.tcf.debug.PeerID";
    public static final String ATTR_PROJECT_NAME = "org.eclipse.tm.tcf.debug.ProjectName";
    public static final String ATTR_LOCAL_PROGRAM_FILE = "org.eclipse.tm.tcf.debug.LocalProgramFile";
    public static final String ATTR_REMOTE_PROGRAM_FILE = "org.eclipse.tm.tcf.debug.ProgramFile";
    public static final String ATTR_COPY_TO_REMOTE_FILE = "org.eclipse.tm.tcf.debug.CopyToRemote";
    public static final String ATTR_PROGRAM_ARGUMENTS = "org.eclipse.tm.tcf.debug.ProgramArguments";
    public static final String ATTR_WORKING_DIRECTORY = "org.eclipse.tm.tcf.debug.WorkingDirectory";
    public static final String ATTR_ATTACH_CHILDREN = "org.eclipse.tm.tcf.debug.AttachChildren";
    public static final String ATTR_USE_TERMINAL = "org.eclipse.tm.tcf.debug.UseTerminal";
    public static final String ATTR_RUN_LOCAL_AGENT = "org.eclipse.tm.tcf.debug.RunLocalAgent";
    public static final String ATTR_USE_LOCAL_AGENT = "org.eclipse.tm.tcf.debug.UseLocalAgent";
    public static final String ATTR_SIGNALS_DONT_STOP = "org.eclipse.tm.tcf.debug.SignalsDontStop";
    public static final String ATTR_SIGNALS_DONT_PASS = "org.eclipse.tm.tcf.debug.SignalsDontPath";
    public static final String ATTR_PATH_MAP = "org.eclipse.tm.tcf.debug.PathMap";
    public static final String ATTR_MEMORY_MAP = "org.eclipse.tm.tcf.debug.MemoryMap";

    public static ArrayList<PathMapRule> parsePathMapAttribute(String s) {
        ArrayList<PathMapRule> map = new ArrayList<PathMapRule>();
        StringBuffer bf = new StringBuffer();
        int i = 0;
        block0: while (i < s.length()) {
            PathMapRule e = new PathMapRule(new HashMap<String, Object>());
            block1: while (i < s.length()) {
                char ch;
                if ((ch = s.charAt(i++)) == '|') {
                    map.add(e);
                    continue block0;
                }
                bf.setLength(0);
                bf.append(ch);
                while (i < s.length()) {
                    if ((ch = s.charAt(i++)) == '=') break;
                    bf.append(ch);
                }
                String nm = bf.toString();
                bf.setLength(0);
                while (i < s.length()) {
                    if ((ch = s.charAt(i++)) == '|') {
                        if (bf.length() <= 0) continue block1;
                        e.props.put(nm, bf.toString());
                        continue block1;
                    }
                    if (ch == '\\') {
                        int n = 0;
                        while (i < s.length()) {
                            char d;
                            if ((d = s.charAt(i++)) == ';') break;
                            n = n * 10 + (d - 48);
                        }
                        bf.append((char)n);
                        continue;
                    }
                    bf.append(ch);
                }
            }
        }
        return map;
    }

    public static String getProgramPath(String project_name, String program_name) {
        if (program_name == null || program_name.length() == 0) {
            return null;
        }
        if (project_name == null || project_name.length() == 0) {
            File file = new File(program_name);
            if (!file.isAbsolute()) {
                File ws = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                file = new File(ws, program_name);
            }
            return file.getAbsolutePath();
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(project_name);
        Path program_path = new Path(program_name);
        if (!program_path.isAbsolute()) {
            if (project == null || !project.getFile(program_name).exists()) {
                return null;
            }
            program_path = project.getFile(program_name).getLocation();
        }
        return program_path.toOSString();
    }

    public ILaunch getLaunch(final ILaunchConfiguration configuration, final String mode) throws CoreException {
        return (ILaunch)new TCFTask<ILaunch>(){
            int cnt;

            public void run() {
                if (this.cnt++ < 2) {
                    Protocol.invokeLater((Runnable)((Object)this));
                } else {
                    this.done((Object)new TCFLaunch(configuration, mode));
                }
            }
        }.getE();
    }

    public void launch(ILaunchConfiguration configuration, final String mode, final ILaunch launch, final IProgressMonitor monitor) throws CoreException {
        String local_id = null;
        int task_cnt = 1;
        if (configuration.getAttribute(ATTR_RUN_LOCAL_AGENT, true)) {
            ++task_cnt;
            if (monitor != null) {
                monitor.beginTask("Starting TCF Agent", task_cnt);
            }
            local_id = TCFLocalAgent.runLocalAgent();
        } else if (configuration.getAttribute(ATTR_USE_LOCAL_AGENT, true)) {
            ++task_cnt;
            if (monitor != null) {
                monitor.beginTask("Searching TCF Agent", task_cnt);
            }
            if ((local_id = TCFLocalAgent.getLocalAgentID()) == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tm.tcf.debug", 0, "Cannot find TCF agent on the local host", null));
            }
        }
        if (monitor != null) {
            monitor.beginTask("Launching TCF debugger session", task_cnt);
        }
        final String id = configuration.getAttribute(ATTR_USE_LOCAL_AGENT, true) ? local_id : configuration.getAttribute(ATTR_PEER_ID, "");
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                ((TCFLaunch)launch).launchTCF(mode, id);
                if (monitor != null) {
                    monitor.done();
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathMapRule
    implements IPathMap.PathMapRule {
        private final Map<String, Object> props;

        public PathMapRule(Map<String, Object> props) {
            this.props = props;
        }

        public Map<String, Object> getProperties() {
            return this.props;
        }

        public String getID() {
            return (String)this.props.get("ID");
        }

        public String getSource() {
            return (String)this.props.get("Source");
        }

        public String getDestination() {
            return (String)this.props.get("Destination");
        }

        public String getHost() {
            return (String)this.props.get("Host");
        }

        public String getProtocol() {
            return (String)this.props.get("Protocol");
        }

        public String toString() {
            StringBuffer bf = new StringBuffer();
            for (String nm : this.props.keySet()) {
                Object o = this.props.get(nm);
                if (o == null) continue;
                bf.append(nm);
                bf.append('=');
                String s = o.toString();
                int i = 0;
                while (i < s.length()) {
                    char ch = s.charAt(i);
                    if (ch >= ' ' && ch != '|' && ch != '\\') {
                        bf.append(ch);
                    } else {
                        bf.append('\\');
                        bf.append((int)ch);
                        bf.append(';');
                    }
                    ++i;
                }
                bf.append('|');
            }
            bf.append('|');
            return bf.toString();
        }
    }
}

