/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.model;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.tm.tcf.services.IMemoryMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFMemoryRegion
implements IMemoryMap.MemoryRegion,
Comparable<TCFMemoryRegion> {
    private final Map<String, Object> props;
    public final BigInteger addr;
    public final BigInteger size;

    public TCFMemoryRegion(Map<String, Object> props) {
        this.props = props;
        Number addr = (Number)props.get("Addr");
        Number size = (Number)props.get("Size");
        this.addr = addr == null || addr instanceof BigInteger ? (BigInteger)addr : new BigInteger(addr.toString());
        this.size = size == null || size instanceof BigInteger ? (BigInteger)size : new BigInteger(size.toString());
    }

    public Number getAddress() {
        return this.addr;
    }

    public Number getSize() {
        return this.size;
    }

    public Number getOffset() {
        return (Number)this.props.get("Offs");
    }

    public String getFileName() {
        return (String)this.props.get("FileName");
    }

    public String getSectionName() {
        return (String)this.props.get("SectionName");
    }

    public int getFlags() {
        Number n = (Number)this.props.get("Flags");
        if (n != null) {
            return n.intValue();
        }
        return 0;
    }

    public Map<String, Object> getProperties() {
        return this.props;
    }

    @Override
    public int compareTo(TCFMemoryRegion r) {
        if (this.addr == null && r.addr == null) {
            return 0;
        }
        if (this.addr == null) {
            return -1;
        }
        if (r.addr == null) {
            return 1;
        }
        return this.addr.compareTo(r.addr);
    }
}

