/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.rse.files;

import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.services.files.HostFilePermissions;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;
import org.eclipse.tm.internal.tcf.rse.files.TCFFileService;
import org.eclipse.tm.tcf.services.IFileSystem;

public class TCFFileResource
extends AbstractResource
implements IHostFile,
IHostFilePermissionsContainer {
    private final TCFFileService service;
    private String parent;
    private String name;
    private final IFileSystem.FileAttrs attrs;
    private final boolean root;
    private IHostFilePermissions permissions;

    public TCFFileResource(TCFFileService service, String parent, String name, IFileSystem.FileAttrs attrs, boolean root) {
        if (name == null) {
            int i = parent.lastIndexOf(47);
            if (i > 0) {
                name = parent.substring(i + 1);
                parent = parent.substring(0, i);
            } else if (i == 0) {
                name = parent.substring(i + 1);
                parent = "/";
            } else {
                name = parent;
                parent = null;
            }
        }
        this.service = service;
        this.parent = parent;
        this.name = name;
        this.attrs = attrs;
        this.root = root;
        if (attrs != null) {
            this.permissions = new HostFilePermissions(attrs.permissions, "" + attrs.uid, "" + attrs.gid);
        }
    }

    private String toLocalPath(String path) {
        if (path.length() > 1 && path.charAt(1) == ':') {
            return path.replace('/', '\\');
        }
        return path.replace('\\', '/');
    }

    public boolean canRead() {
        return this.attrs != null && this.service.canRead(this.attrs);
    }

    public boolean canWrite() {
        return this.attrs != null && this.service.canWrite(this.attrs);
    }

    public boolean exists() {
        return this.attrs != null;
    }

    public synchronized String getAbsolutePath() {
        if (this.root) {
            return this.toLocalPath(this.name);
        }
        if (this.parent.endsWith("/")) {
            return this.toLocalPath(String.valueOf(this.parent) + this.name);
        }
        return this.toLocalPath(String.valueOf(this.parent) + '/' + this.name);
    }

    public long getModifiedDate() {
        if (this.attrs == null) {
            return 0L;
        }
        if ((this.attrs.flags & 8) == 0) {
            return 0L;
        }
        return this.attrs.mtime;
    }

    public synchronized String getName() {
        return this.toLocalPath(this.name);
    }

    public synchronized String getParentPath() {
        if (this.root) {
            return null;
        }
        return this.toLocalPath(this.parent);
    }

    public long getSize() {
        if (this.attrs == null) {
            return 0L;
        }
        if ((this.attrs.flags & 1) == 0) {
            return 0L;
        }
        return this.attrs.size;
    }

    public boolean isArchive() {
        return false;
    }

    public boolean isDirectory() {
        if (this.attrs == null) {
            return false;
        }
        return this.attrs.isDirectory();
    }

    public boolean isFile() {
        if (this.attrs == null) {
            return false;
        }
        return this.attrs.isFile();
    }

    public synchronized boolean isHidden() {
        return this.name.startsWith(".");
    }

    public synchronized boolean isRoot() {
        return this.root;
    }

    public synchronized void renameTo(String path) {
        if ((path = path.replace('\\', '/')).equals("/")) {
            this.name = "/";
            this.parent = "/";
            return;
        }
        assert (!path.endsWith("/"));
        int i = path.lastIndexOf(47);
        this.parent = path.substring(0, i);
        this.name = path.substring(i + 1);
    }

    public IHostFilePermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(IHostFilePermissions permissions) {
        this.permissions = permissions;
    }
}

