/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.rse.shells;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IStreams;
import org.eclipse.tm.tcf.util.TCFTask;

public class TCFTerminalInputStream
extends InputStream {
    private IStreams streams;
    private boolean connected = true;
    String is_id;
    private int value;
    private boolean bEof = false;
    private Buffer buffer;

    public TCFTerminalInputStream(IStreams streams, String is_id) throws IOException {
        if (streams == null) {
            throw new IOException("TCP streams is null");
        }
        this.streams = streams;
        this.is_id = is_id;
    }

    public synchronized int read() throws IOException {
        if (!this.connected) {
            throw new IOException("istream is not connected");
        }
        if (this.bEof) {
            return -1;
        }
        try {
            new TCFTask<Object>(){

                public void run() {
                    TCFTerminalInputStream.this.streams.read(TCFTerminalInputStream.this.is_id, 1, new IStreams.DoneRead(){

                        public void doneRead(IToken token, Exception error, int lostSize, byte[] data, boolean eos) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            TCFTerminalInputStream.this.bEof = eos;
                            if (data != null) {
                                TCFTerminalInputStream.this.value = data[0];
                            } else {
                                TCFTerminalInputStream.this.value = -1;
                            }
                            this.done(this);
                        }
                    });
                }
            }.getIO();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        return this.value;
    }

    public synchronized int read(byte[] b, int off, final int len) throws IOException {
        if (!this.connected) {
            throw new IOException("istream is not connected");
        }
        if (this.bEof) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        try {
            new TCFTask<Buffer>(){

                public void run() {
                    TCFTerminalInputStream.this.streams.read(TCFTerminalInputStream.this.is_id, len, new IStreams.DoneRead(){

                        public void doneRead(IToken token, Exception error, int lostSize, byte[] data, boolean eos) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            TCFTerminalInputStream.this.bEof = eos;
                            if (data != null) {
                                TCFTerminalInputStream.this.buffer = new Buffer();
                                ((TCFTerminalInputStream)(this).TCFTerminalInputStream.this).buffer.buf = data;
                            }
                            this.done(TCFTerminalInputStream.this.buffer);
                        }
                    });
                }
            }.getIO();
            if (this.buffer.buf != null) {
                int length = this.buffer.buf.length;
                System.arraycopy(this.buffer.buf, 0, b, off, length);
                return length;
            }
            if (this.bEof) {
                return -1;
            }
            return 0;
        }
        catch (Exception ee) {
            throw new IOException(ee.getMessage());
        }
    }

    public void close() throws IOException {
        if (!this.connected) {
            return;
        }
        new TCFTask<Object>(){

            public void run() {
                TCFTerminalInputStream.this.streams.disconnect(TCFTerminalInputStream.this.is_id, new IStreams.DoneDisconnect(){

                    public void doneDisconnect(IToken token, Exception error) {
                        TCFTerminalInputStream.this.connected = false;
                        this.done(this);
                    }
                });
            }
        }.getIO();
        this.connected = false;
    }

    private static class Buffer {
        byte[] buf;

        Buffer() {
        }
    }
}

