/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf;

import java.util.LinkedList;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tm.tcf.protocol.IEventQueue;
import org.eclipse.tm.tcf.protocol.Protocol;

class EventQueue
implements IEventQueue,
Runnable {
    private final LinkedList<Runnable> queue = new LinkedList();
    private final Thread thread = new Thread(this);
    private boolean waiting;
    private boolean shutdown;
    private int job_cnt;

    EventQueue() {
        this.thread.setDaemon(true);
        this.thread.setName("TCF Event Dispatcher");
        Job.getJobManager().addJobChangeListener(new IJobChangeListener(){

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                EventQueue eventQueue = EventQueue.this;
                eventQueue.job_cnt = eventQueue.job_cnt - 1;
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
                EventQueue eventQueue = EventQueue.this;
                eventQueue.job_cnt = eventQueue.job_cnt + 1;
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
    }

    void start() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        try {
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                this.shutdown = true;
                if (this.waiting) {
                    this.waiting = false;
                    this.notifyAll();
                }
            }
            this.thread.join();
        }
        catch (Exception e) {
            Protocol.log((String)"Failed to shutdown TCF event dispatch thread", (Throwable)e);
        }
    }

    private void error(Throwable x) {
        Protocol.log((String)"Unhandled exception in TCF event dispatch", (Throwable)x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    Runnable r = null;
                    EventQueue eventQueue = this;
                    synchronized (eventQueue) {
                        while (this.queue.isEmpty()) {
                            if (this.shutdown) {
                                return;
                            }
                            this.waiting = true;
                            this.wait();
                        }
                        r = this.queue.removeFirst();
                    }
                    r.run();
                }
            }
            catch (Throwable x) {
                this.error(x);
                continue;
            }
            break;
        }
    }

    public synchronized void invokeLater(Runnable r) {
        assert (r != null);
        if (this.shutdown) {
            throw new IllegalStateException("TCF event dispatcher has shut down");
        }
        this.queue.add(r);
        if (this.waiting) {
            this.waiting = false;
            this.notifyAll();
        }
    }

    public boolean isDispatchThread() {
        return Thread.currentThread() == this.thread;
    }

    public synchronized int getCongestion() {
        if (Job.getJobManager().isIdle()) {
            this.job_cnt = 0;
        }
        int l0 = this.job_cnt / 10 - 100;
        int l1 = this.queue.size() / 10 - 100;
        if (l1 > l0) {
            l0 = l1;
        }
        if (l0 > 100) {
            l0 = 100;
        }
        return l0;
    }
}

