/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.dsf;

import com.ibm.icu.text.MessageFormat;
import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.model.ICDebugElement;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICThread;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.IDisassemblyBlock;
import org.eclipse.cdt.debug.internal.core.CRequest;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.ui.CDebugUIMessages;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AbstractDisassemblyBackend;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.CDIDisassemblyRetrieval;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyUtils;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyBackend;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyPartCallback;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyRetrieval;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Shell;

public class DisassemblyBackendCdi
extends AbstractDisassemblyBackend
implements IDebugEventSetListener {
    private ICThread fTargetContext;
    private String fCdiSessionId;
    private ICStackFrame fTargetFrameContext;
    private CDIDisassemblyRetrieval fDisassemblyRetrieval;
    private int fFrameLevel;

    public void init(IDisassemblyPartCallback callback) {
        super.init(callback);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public boolean hasDebugContext() {
        return this.fTargetContext != null;
    }

    private String getSessionId(ICDebugElement debugElement) {
        return "cdi-" + System.identityHashCode(debugElement.getDebugTarget());
    }

    public IDisassemblyBackend.SetDebugContextResult setDebugContext(IAdaptable context) {
        assert (this.supportsDebugContext(context)) : "caller should not have invoked us";
        IDisassemblyBackend.SetDebugContextResult result = new IDisassemblyBackend.SetDebugContextResult();
        ICDebugTarget cdiDebugTarget = (ICDebugTarget)((ICDebugElement)context).getDebugTarget();
        String cdiSessionId = this.getSessionId((ICDebugElement)cdiDebugTarget);
        this.fDisassemblyRetrieval = new CDIDisassemblyRetrieval(cdiDebugTarget);
        if (!cdiSessionId.equals(this.fCdiSessionId)) {
            this.fTargetContext = null;
            this.fTargetFrameContext = null;
            result.contextChanged = true;
            if (context instanceof ICStackFrame) {
                this.fFrameLevel = 0;
                this.fTargetContext = (ICThread)((ICStackFrame)context).getThread();
                try {
                    IStackFrame topFrame = this.fTargetContext.getTopStackFrame();
                    if (topFrame != null) {
                        this.fTargetFrameContext = (ICStackFrame)context;
                        this.fFrameLevel = ((CStackFrame)topFrame).getLevel() - this.fTargetFrameContext.getLevel();
                    }
                }
                catch (DebugException debugException) {}
            }
            if (this.fTargetContext != null) {
                result.sessionId = this.fCdiSessionId = cdiSessionId;
            }
        } else if (context instanceof ICStackFrame) {
            result.sessionId = this.fCdiSessionId;
            this.fTargetFrameContext = null;
            this.fFrameLevel = 0;
            ICThread newTargetContext = (ICThread)((ICStackFrame)context).getThread();
            ICThread oldTargetContext = this.fTargetContext;
            this.fTargetContext = newTargetContext;
            if (oldTargetContext == null) {
                result.contextChanged = true;
            } else if (newTargetContext != null) {
                result.contextChanged = !oldTargetContext.getDebugTarget().equals(newTargetContext.getDebugTarget());
            }
            try {
                IStackFrame topFrame = this.fTargetContext.getTopStackFrame();
                if (topFrame != null) {
                    this.fTargetFrameContext = (ICStackFrame)context;
                    this.fFrameLevel = ((CStackFrame)topFrame).getLevel() - this.fTargetFrameContext.getLevel();
                }
            }
            catch (DebugException debugException) {}
            if (!result.contextChanged) {
                this.fCallback.gotoFrame(this.fFrameLevel);
            }
        } else {
            this.fTargetContext = null;
            this.fTargetFrameContext = null;
            result.contextChanged = true;
        }
        return result;
    }

    public boolean supportsDebugContext(IAdaptable context) {
        return DisassemblyBackendCdi.supportsDebugContext_(context);
    }

    public static boolean supportsDebugContext_(IAdaptable context) {
        return context != null && context.getAdapter(ICDebugElement.class) != null;
    }

    public void clearDebugContext() {
        this.fTargetContext = null;
        this.fCdiSessionId = null;
        this.fTargetFrameContext = null;
        this.fDisassemblyRetrieval = null;
        this.fFrameLevel = 0;
    }

    public void retrieveFrameAddress(final int targetFrame) {
        try {
            IStackFrame[] stackFrames = this.fTargetContext.getStackFrames();
            if (stackFrames.length <= targetFrame) {
                this.fCallback.setUpdatePending(false);
                return;
            }
            IStackFrame stackFrame = stackFrames[targetFrame];
            this.fDisassemblyRetrieval.asyncGetFrameAddress(stackFrame, new AddressRequest(){

                public void done() {
                    DisassemblyBackendCdi.this.fCallback.setUpdatePending(false);
                    if (this.isSuccess()) {
                        BigInteger address = this.getAddress();
                        if (targetFrame == 0) {
                            DisassemblyBackendCdi.this.fCallback.updatePC(address);
                        } else {
                            DisassemblyBackendCdi.this.fCallback.gotoFrame(targetFrame, address);
                        }
                    }
                }
            });
        }
        catch (DebugException exc) {
            DisassemblyUtils.internalError(exc);
        }
    }

    public int getFrameLevel() {
        return this.fFrameLevel;
    }

    public boolean isSuspended() {
        return this.fTargetContext != null && this.fTargetContext.isSuspended();
    }

    public String getFrameFile() {
        return this.fTargetFrameContext != null ? this.fTargetFrameContext.getFile() : null;
    }

    public int getFrameLine() {
        return this.fTargetFrameContext.getFrameLineNumber();
    }

    public void retrieveDisassembly(final BigInteger startAddress, BigInteger endAddress, final String file, int lineNumber, final int lines, final boolean mixed, final boolean showSymbols, final boolean showDisassembly, final int linesHint) {
        if (this.fTargetContext == null || this.fTargetContext.isTerminated()) {
            return;
        }
        BigInteger addressLength = BigInteger.valueOf(lines * 4);
        if (endAddress.subtract(startAddress).compareTo(addressLength) > 0) {
            endAddress = startAddress.add(addressLength);
        }
        final BigInteger finalEndAddress = startAddress.add(BigInteger.valueOf(32L)).max(endAddress);
        DisassemblyRequest disassemblyRequest = new DisassemblyRequest(){

            public void done() {
                if (this.isSuccess() && this.getDisassemblyBlock() != null) {
                    if (!DisassemblyBackendCdi.this.insertDisassembly(startAddress, finalEndAddress, this.getDisassemblyBlock(), mixed, showSymbols, showDisassembly)) {
                        if (file != null) {
                            DisassemblyBackendCdi.this.fCallback.setUpdatePending(true);
                            DisassemblyBackendCdi.this.retrieveDisassembly(startAddress, finalEndAddress, null, -1, lines, mixed, showSymbols, showDisassembly, linesHint);
                        } else if (mixed) {
                            DisassemblyBackendCdi.this.fCallback.setUpdatePending(true);
                            DisassemblyBackendCdi.this.retrieveDisassembly(startAddress, finalEndAddress, null, -1, lines, false, showSymbols, showDisassembly, linesHint);
                        } else {
                            DisassemblyBackendCdi.this.fCallback.doScrollLocked(new Runnable(){

                                public void run() {
                                    (this).DisassemblyBackendCdi.this.fCallback.insertError(startAddress, "Unable to retrieve disassembly data from backend.");
                                }
                            });
                        }
                    }
                } else {
                    final IStatus status = this.getStatus();
                    if (status != null && !status.isOK()) {
                        DisassemblyBackendCdi.this.fCallback.doScrollLocked(new Runnable(){

                            public void run() {
                                (this).DisassemblyBackendCdi.this.fCallback.insertError(startAddress, status.getMessage());
                            }
                        });
                    }
                    DisassemblyBackendCdi.this.fCallback.setUpdatePending(false);
                }
            }
        };
        this.fDisassemblyRetrieval.asyncGetDisassembly(startAddress, finalEndAddress, file, lineNumber, lines, mixed, disassemblyRequest);
    }

    public Object insertSource(Position pos, BigInteger address, String file, int lineNumber) {
        ISourceLocator locator = this.fTargetContext.getLaunch().getSourceLocator();
        if (locator instanceof ISourceLookupDirector) {
            return ((ISourceLookupDirector)locator).getSourceElement((Object)file);
        }
        return null;
    }

    public boolean hasFrameContext() {
        return this.fTargetFrameContext != null;
    }

    public void gotoSymbol(String symbol) {
        final BigInteger address = this.evaluateAddressExpression(symbol, false);
        if (address != null) {
            this.fCallback.asyncExec(new Runnable(){

                public void run() {
                    DisassemblyBackendCdi.this.fCallback.gotoAddress(address);
                }
            });
        }
    }

    public BigInteger evaluateAddressExpression(String symbol, boolean suppressError) {
        block10: {
            if (this.fTargetFrameContext != null) {
                try {
                    CStackFrame cstackFrame = (CStackFrame)this.fTargetFrameContext;
                    ICDIExpression cdiExpression = cstackFrame.getCDITarget().createExpression(symbol);
                    CExpression cdtExpression = new CExpression(cstackFrame, cdiExpression, null);
                    IValue value = cdtExpression.getValue();
                    if (value instanceof ICValue) {
                        ICType type = ((ICValue)value).getType();
                        if (type == null) break block10;
                        String rawExpr = cdtExpression.getExpressionString();
                        String voidExpr = "(void *)(" + rawExpr + ')';
                        String[] attempts = new String[]{rawExpr, voidExpr};
                        int i = 0;
                        while (i < attempts.length) {
                            block11: {
                                String expr = attempts[i];
                                String addressStr = cstackFrame.evaluateExpressionToString(expr);
                                if (addressStr != null) {
                                    try {
                                        return addressStr.startsWith("0x") ? new BigInteger(addressStr.substring(2), 16) : new BigInteger(addressStr);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        if (i < attempts.length) break block11;
                                        throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.ui", MessageFormat.format((String)CDebugUIMessages.getString("DisassemblyBackendCdi_Symbol_Evaluation_Unusable"), (Object[])new String[]{symbol})));
                                    }
                                }
                            }
                            ++i;
                        }
                        break block10;
                    }
                    throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.ui", MessageFormat.format((String)CDebugUIMessages.getString("DisassemblyBackendCdi_Symbol_Didnt_Evaluate"), (Object[])new String[]{symbol})));
                }
                catch (CDIException exc) {
                    if (!suppressError) {
                        this.fCallback.asyncExec(new Runnable(){

                            public void run() {
                                ErrorDialog.openError((Shell)DisassemblyBackendCdi.this.fCallback.getSite().getShell(), (String)CDebugUIMessages.getString("DisassemblyBackendCdi_Error_Dlg_Title"), null, (IStatus)new Status(4, "org.eclipse.cdt.debug.ui", exc.getLocalizedMessage()));
                            }
                        });
                    }
                }
                catch (DebugException exc) {
                    if (suppressError) break block10;
                    this.fCallback.asyncExec(new Runnable(){

                        public void run() {
                            ErrorDialog.openError((Shell)DisassemblyBackendCdi.this.fCallback.getSite().getShell(), (String)CDebugUIMessages.getString("DisassemblyBackendCdi_Error_Dlg_Title"), null, (IStatus)exc.getStatus());
                        }
                    });
                }
            }
        }
        return null;
    }

    public void retrieveDisassembly(String file, int lines, final BigInteger endAddress, final boolean mixed, final boolean showSymbols, final boolean showDisassembly) {
        DisassemblyRequest disassemblyRequest = new DisassemblyRequest(){

            public void done() {
                if (this.isSuccess() && this.getDisassemblyBlock() != null) {
                    DisassemblyBackendCdi.this.insertDisassembly(null, endAddress, this.getDisassemblyBlock(), mixed, showSymbols, showDisassembly);
                } else {
                    IStatus status = this.getStatus();
                    if (status != null && !status.isOK()) {
                        DisassemblyBackendCdi.this.fCallback.asyncExec(new Runnable(){

                            public void run() {
                                ErrorDialog.openError((Shell)(this).DisassemblyBackendCdi.this.fCallback.getSite().getShell(), (String)"Error", null, (IStatus)this.getStatus());
                            }
                        });
                    }
                    DisassemblyBackendCdi.this.fCallback.setUpdatePending(false);
                }
            }
        };
        assert (!this.fCallback.getUpdatePending());
        this.fCallback.setUpdatePending(true);
        this.fDisassemblyRetrieval.asyncGetDisassembly(null, endAddress, file, 1, lines, mixed, disassemblyRequest);
    }

    /*
     * Exception decompiling
     */
    private boolean insertDisassembly(BigInteger startAddress, BigInteger endAddress, IDisassemblyBlock disassemblyBlock, boolean mixed, boolean showSymbols, boolean showDisassembly) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Object eventSource;
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 8 && (eventSource = event.getSource()) instanceof CDebugTarget && this.getSessionId((ICDebugElement)((CDebugTarget)eventSource)).equals(this.fCdiSessionId)) {
                this.fCallback.handleTargetEnded();
                return;
            }
            ++n2;
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public String evaluateExpression(String expression) {
        if (this.fTargetFrameContext != null) {
            try {
                ICType type;
                CStackFrame cstackFrame = (CStackFrame)this.fTargetFrameContext;
                ICDIExpression cdiExpression = cstackFrame.getCDITarget().createExpression(expression);
                CExpression cdtExpression = new CExpression(cstackFrame, cdiExpression, null);
                IValue value = cdtExpression.getValue();
                if (value instanceof ICValue && (type = ((ICValue)value).getType()) != null) {
                    return cstackFrame.evaluateExpressionToString(cdtExpression.getExpressionString());
                }
            }
            catch (Exception exception) {}
        }
        return "";
    }

    private class AddressRequest
    extends CRequest
    implements IDisassemblyRetrieval.AddressRequest {
        private BigInteger fAddress;

        private AddressRequest() {
        }

        public BigInteger getAddress() {
            return this.fAddress;
        }

        public void setAddress(BigInteger address) {
            this.fAddress = address;
        }
    }

    private class DisassemblyRequest
    extends CRequest
    implements IDisassemblyRetrieval.DisassemblyRequest {
        private IDisassemblyBlock fBlock;

        private DisassemblyRequest() {
        }

        public IDisassemblyBlock getDisassemblyBlock() {
            return this.fBlock;
        }

        public void setDisassemblyBlock(IDisassemblyBlock block) {
            this.fBlock = block;
        }
    }
}

