/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.text.c.hover.SourceViewerInformationControl;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractCompareViewerInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2,
DisposeListener {
    private CompareViewerControl fCompareViewerControl;
    private ICompareInput fCompareInput;
    private Color fBackgroundColor;
    private boolean fIsSystemBackgroundColor = true;
    private Label fTitleLabel;

    public AbstractCompareViewerInformationControl(Shell parent, boolean isResizable) {
        super(parent, isResizable);
        this.create();
    }

    public AbstractCompareViewerInformationControl(Shell parent, ToolBarManager toolBarManager) {
        super(parent, toolBarManager);
        this.create();
    }

    private void initializeColors() {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        RGB bgRGB = store.getBoolean("sourceHoverBackgroundColor.SystemDefault") ? SourceViewerInformationControl.getVisibleBackgroundColor(this.getShell().getDisplay()) : PreferenceConverter.getColor((IPreferenceStore)store, (String)"sourceHoverBackgroundColor");
        if (bgRGB != null) {
            this.fBackgroundColor = new Color((Device)this.getShell().getDisplay(), bgRGB);
            this.fIsSystemBackgroundColor = false;
        } else {
            this.fBackgroundColor = this.getShell().getDisplay().getSystemColor(29);
            this.fIsSystemBackgroundColor = true;
        }
    }

    protected void createContent(Composite parent) {
        this.initializeColors();
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        if (this.hasHeader()) {
            this.createTitleLabel(content);
        }
        CompareConfiguration compareConfig = new CompareConfiguration();
        compareConfig.setLeftEditable(false);
        compareConfig.setRightEditable(false);
        this.fCompareViewerControl = this.createCompareViewerControl(content, 0, compareConfig);
        this.addDisposeListener(this);
    }

    protected CompareViewerControl createCompareViewerControl(Composite parent, int style, CompareConfiguration compareConfig) {
        CompareViewerControl compareViewer = new CompareViewerControl(parent, style, compareConfig);
        return compareViewer;
    }

    protected Viewer createContentViewer(Composite parent, ICompareInput input, CompareConfiguration cc) {
        return CompareUI.findContentViewer(null, (ICompareInput)input, (Composite)parent, (CompareConfiguration)cc);
    }

    private void createTitleLabel(Composite parent) {
        this.fTitleLabel = new Label(parent, 16384);
        this.fTitleLabel.setLayoutData((Object)new GridData(768));
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.fTitleLabel.setFont(JFaceResources.getDialogFont());
        Display display = parent.getDisplay();
        Color foreground = display.getSystemColor(30);
        Color background = display.getSystemColor(31);
        this.fTitleLabel.setForeground(foreground);
        this.fTitleLabel.setBackground(background);
        this.addMoveSupport((Control)this.fTitleLabel);
    }

    public void setTitleText(String titleText) {
        if (this.fTitleLabel != null) {
            this.fTitleLabel.setText(titleText);
        }
    }

    protected final CompareViewerControl getCompareViewer() {
        return this.fCompareViewerControl;
    }

    protected final CompareConfiguration getCompareConfiguration() {
        return this.fCompareViewerControl.getCompareConfiguration();
    }

    protected boolean hasHeader() {
        return false;
    }

    protected Color getBackgroundColor() {
        return this.fBackgroundColor;
    }

    public void setInformation(String content) {
    }

    public void setInput(Object input) {
        if (input instanceof ICompareInput) {
            this.fCompareInput = (ICompareInput)input;
            if (this.fCompareViewerControl != null) {
                this.fCompareViewerControl.setInput(this.fCompareInput);
            }
        } else if (!(input instanceof String)) {
            this.fCompareInput = null;
            if (this.fCompareViewerControl != null) {
                this.fCompareViewerControl.setInput(this.fCompareInput);
            }
        }
    }

    public void dispose() {
        if (!this.fIsSystemBackgroundColor) {
            this.fBackgroundColor.dispose();
        }
        super.dispose();
    }

    public void widgetDisposed(DisposeEvent event) {
        this.fCompareViewerControl = null;
    }

    public boolean hasContents() {
        return this.fCompareViewerControl != null && this.fCompareInput != null;
    }

    public Point computeSizeHint() {
        int x = -1;
        int y = -1;
        Point size = this.getShell().computeSize(x, y);
        Point constraints = this.getSizeConstraints();
        if (constraints != null) {
            if (size.x < constraints.x) {
                x = constraints.x;
            }
            if (size.y < constraints.y) {
                y = constraints.y;
            }
        }
        if (x != -1 || y != -1) {
            size = this.getShell().computeSize(x, y, false);
        }
        return size;
    }

    public void setFocus() {
        super.setFocus();
        this.fCompareViewerControl.setFocus();
    }

    public Rectangle computeTrim() {
        Rectangle trim = super.computeTrim();
        this.addInternalTrim(trim);
        return trim;
    }

    private void addInternalTrim(Rectangle trim) {
        Rectangle textTrim = this.fCompareViewerControl.computeTrim(0, 0, 0, 0);
        trim.x += textTrim.x;
        trim.y += textTrim.y;
        trim.width += textTrim.width;
        trim.height += textTrim.height;
        if (this.fTitleLabel != null) {
            trim.height += this.fTitleLabel.computeSize((int)-1, (int)-1).y;
        }
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        Font font = JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont");
        GC gc = new GC((Drawable)this.fCompareViewerControl);
        gc.setFont(font);
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        return new Point(widthInChars * width, heightInChars * height);
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return null;
    }

    protected final void addMoveSupport(final Control control) {
        MouseAdapter moveSupport = new MouseAdapter(){
            private MouseMoveListener fMoveListener;
            private final Control fShell;
            {
                this.fShell = AbstractCompareViewerInformationControl.this.getShell();
            }

            public void mouseDown(MouseEvent e) {
                Point shellLoc = this.fShell.getLocation();
                final int shellX = shellLoc.x;
                final int shellY = shellLoc.y;
                Point mouseLoc = control.toDisplay(e.x, e.y);
                final int mouseX = mouseLoc.x;
                final int mouseY = mouseLoc.y;
                this.fMoveListener = new MouseMoveListener(){

                    public void mouseMove(MouseEvent e2) {
                        Point mouseLoc2 = control.toDisplay(e2.x, e2.y);
                        int dx = mouseLoc2.x - mouseX;
                        int dy = mouseLoc2.y - mouseY;
                        fShell.setLocation(shellX + dx, shellY + dy);
                    }
                };
                control.addMouseMoveListener(this.fMoveListener);
            }

            public void mouseUp(MouseEvent e) {
                control.removeMouseMoveListener(this.fMoveListener);
                this.fMoveListener = null;
            }
        };
        control.addMouseListener((MouseListener)moveSupport);
    }

    protected class CompareViewerControl
    extends ViewForm {
        private CompareConfiguration fCompareConfiguration;
        private Viewer fViewer;

        public CompareViewerControl(Composite parent, int styles, CompareConfiguration cc) {
            super(parent, styles & 0xFFFFF7FF);
            this.verticalSpacing = 0;
            this.fCompareConfiguration = cc;
        }

        public CompareConfiguration getCompareConfiguration() {
            return this.fCompareConfiguration;
        }

        public void setInput(ICompareInput input) {
            if (this.fViewer == null) {
                this.fViewer = AbstractCompareViewerInformationControl.this.createContentViewer((Composite)this, input, this.fCompareConfiguration);
                this.setContent(this.fViewer.getControl());
            }
            this.fViewer.setInput((Object)input);
        }
    }
}

