/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.expression;

import java.util.LinkedList;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionsChangedEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.InvalidExpressionVMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.VMExpressionUpdate;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;

public class SingleExpressionVMNode
extends AbstractVMNode
implements IElementLabelProvider {
    private final SingleExpressionManager fManager = new SingleExpressionManager();

    public SingleExpressionVMNode(ExpressionVMProvider provider) {
        super(provider);
    }

    public String toString() {
        return "SingleExpressionVMNode";
    }

    private ExpressionVMProvider getExpressionVMProvider() {
        return (ExpressionVMProvider)this.getVMProvider();
    }

    public void update(IHasChildrenUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            updates[i].setHasChilren(this.fManager.getExpressions().length != 0);
            updates[i].done();
            ++i;
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
            if (this.checkUpdate((IViewerUpdate)update)) {
                update.setChildCount(this.fManager.getExpressions().length);
                update.done();
            }
            ++n2;
        }
    }

    public void update(IChildrenUpdate[] updates) {
        IChildrenUpdate[] iChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenUpdate update = iChildrenUpdateArray[n2];
            this.doUpdateChildren(update);
            ++n2;
        }
    }

    public void doUpdateChildren(final IChildrenUpdate update) {
        int length;
        IExpression[] expressions = this.fManager.getExpressions();
        final ViewerCountingRequestMonitor multiRm = new ViewerCountingRequestMonitor(this.getVMProvider().getExecutor(), (IViewerUpdate)update);
        int multiRmCount = 0;
        int lowOffset = update.getOffset();
        if (lowOffset < 0) {
            lowOffset = 0;
        }
        if ((length = update.getLength()) <= 0) {
            length = expressions.length;
        }
        int highOffset = lowOffset + length;
        int i = lowOffset;
        while (i < highOffset && i < expressions.length + 1) {
            if (i < expressions.length) {
                ++multiRmCount;
                final int childIndex = i;
                final IExpression expression = expressions[i];
                ((ExpressionVMProvider)this.getVMProvider()).update(new VMExpressionUpdate((IViewerUpdate)update, expression, new DataRequestMonitor<Object>(this.getVMProvider().getExecutor(), (RequestMonitor)multiRm){

                    protected void handleSuccess() {
                        update.setChild(this.getData(), childIndex);
                        multiRm.done();
                    }

                    protected void handleError() {
                        update.setChild((Object)new InvalidExpressionVMContext(SingleExpressionVMNode.this, expression), childIndex);
                        multiRm.done();
                    }
                }));
            }
            ++i;
        }
        multiRm.setDoneCount(multiRmCount);
    }

    public void update(ILabelUpdate[] updates) {
        ILabelUpdate[] iLabelUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelUpdate update = iLabelUpdateArray[n2];
            update.done();
            ++n2;
        }
    }

    @Override
    public int getDeltaFlags(Object event) {
        int retVal = 0;
        if (event instanceof ExpressionsChangedEvent) {
            retVal |= 0x413;
        }
        IExpression[] iExpressionArray = this.fManager.getExpressions();
        int n = iExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression expression = iExpressionArray[n2];
            retVal |= this.getExpressionVMProvider().getDeltaFlagsForExpression(expression, event);
            ++n2;
        }
        return retVal;
    }

    @Override
    public void buildDelta(Object event, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof ExpressionsChangedEvent) {
            this.buildDeltaForExpressionsChangedEvent((ExpressionsChangedEvent)event, parentDelta, nodeOffset, requestMonitor);
        } else {
            CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), requestMonitor);
            int buildDeltaForExpressionCallCount = 0;
            IExpression[] expressions = this.fManager.getExpressions();
            int i = 0;
            while (i < expressions.length) {
                int flags = this.getExpressionVMProvider().getDeltaFlagsForExpression(expressions[i], event);
                if (flags != 0) {
                    int elementOffset = nodeOffset >= 0 ? nodeOffset + i : -1;
                    this.getExpressionVMProvider().buildDeltaForExpression(expressions[i], elementOffset, event, parentDelta, this.getTreePathFromDelta((IModelDelta)parentDelta), new RequestMonitor(this.getExecutor(), (RequestMonitor)multiRm));
                    ++buildDeltaForExpressionCallCount;
                }
                ++i;
            }
            multiRm.setDoneCount(buildDeltaForExpressionCallCount);
        }
    }

    private void buildDeltaForExpressionsChangedEvent(ExpressionsChangedEvent event, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), requestMonitor);
        int i = 0;
        while (i < event.getExpressions().length) {
            int expIndex = event.getIndex() != -1 ? nodeOffset + event.getIndex() + i : -1;
            this.getExpressionVMProvider().buildDeltaForExpression(event.getExpressions()[i], expIndex, event, parentDelta, this.getTreePathFromDelta((IModelDelta)parentDelta), new RequestMonitor(this.getExecutor(), (RequestMonitor)multiRm));
            ++i;
        }
        multiRm.setDoneCount(event.getExpressions().length);
    }

    private TreePath getTreePathFromDelta(IModelDelta delta) {
        LinkedList<Object> elementList = new LinkedList<Object>();
        IModelDelta listDelta = delta;
        elementList.add(0, listDelta.getElement());
        while (listDelta.getParentDelta() != null) {
            elementList.add(0, listDelta.getElement());
            listDelta = listDelta.getParentDelta();
        }
        return new TreePath(elementList.toArray());
    }

    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        this.doUpdateChildren(update);
    }

    public IDMVMContext createVMContext(IDMContext dmc) {
        return new RootDMVMContext(this.getVMProvider().getRootVMNode(), dmc);
    }

    public void setExpression(IExpressions.IExpressionDMContext dmc) {
        String text = dmc.getExpression();
        this.fManager.setExpression(new SimpleExpression(text));
    }

    private static class RootDMVMContext
    extends AbstractVMContext
    implements IDMVMContext {
        private final IDMContext fDmc;

        public RootDMVMContext(IVMNode node, IDMContext dmc) {
            super(node);
            this.fDmc = dmc;
        }

        @Override
        public IDMContext getDMContext() {
            return this.fDmc;
        }

        @Override
        public Object getAdapter(Class adapter) {
            Object superAdapter = super.getAdapter(adapter);
            if (superAdapter != null) {
                return superAdapter;
            }
            if (adapter.isInstance(this.fDmc)) {
                return this.fDmc;
            }
            return this.fDmc.getAdapter(adapter);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof RootDMVMContext) {
                RootDMVMContext otherVmc = (RootDMVMContext)other;
                return this.getVMNode().equals(otherVmc.getVMNode()) && this.fDmc.equals(otherVmc.fDmc);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.getVMNode().hashCode() + this.fDmc.hashCode();
        }
    }

    private static class SimpleExpression
    implements IExpression {
        private String fExpressionText;

        SimpleExpression(String text) {
            this.fExpressionText = text;
        }

        public void dispose() {
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public String getExpressionText() {
            return this.fExpressionText;
        }

        public IValue getValue() {
            return null;
        }

        public ILaunch getLaunch() {
            return null;
        }

        public String getModelIdentifier() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof SimpleExpression) {
                return this.fExpressionText.equals(((SimpleExpression)obj).getExpressionText());
            }
            return false;
        }

        public int hashCode() {
            return this.fExpressionText.hashCode();
        }
    }

    private static class SingleExpressionManager {
        private static final IExpression[] NO_EXPRESSIONS = new IExpression[0];
        IExpression fExpression;

        private SingleExpressionManager() {
        }

        public IExpression[] getExpressions() {
            if (this.fExpression != null) {
                return new IExpression[]{this.fExpression};
            }
            return NO_EXPRESSIONS;
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }
    }
}

