/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast;

import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCastExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPackExpansionExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.gnu.c.IGCCASTArrayRangeDesignator;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.parser.ASTProblem;

@Deprecated
public class ASTSignatureUtil {
    private static final String COMMA_SPACE = ", ";
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String getNodeSignature(IASTNode node) {
        if (node instanceof IASTDeclarator) {
            return ASTSignatureUtil.getSignature((IASTDeclarator)node);
        }
        if (node instanceof IASTDeclSpecifier) {
            return ASTSignatureUtil.getSignature((IASTDeclSpecifier)node);
        }
        if (node instanceof IASTTypeId) {
            return ASTSignatureUtil.getSignature((IASTTypeId)node);
        }
        if (node instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration decl = (IASTSimpleDeclaration)node;
            StringBuffer buffer = new StringBuffer(ASTSignatureUtil.getSignature(decl.getDeclSpecifier()));
            IASTDeclarator[] declarators = decl.getDeclarators();
            int i = 0;
            while (i < declarators.length) {
                buffer.append(SPACE);
                buffer.append(ASTSignatureUtil.getSignature(declarators[i]));
                if (declarators[i].getInitializer() != null && declarators[i].getInitializer() instanceof ICPPASTConstructorInitializer) {
                    buffer.append(ASTSignatureUtil.getInitializerString(declarators[i].getInitializer()));
                }
                ++i;
            }
            buffer.append(";");
            return buffer.toString();
        }
        if (node instanceof IASTExpression) {
            return ASTSignatureUtil.getExpressionString((IASTExpression)node);
        }
        return EMPTY_STRING;
    }

    public static String getParameterSignature(IASTDeclarator decltor) {
        if (!(decltor instanceof IASTStandardFunctionDeclarator) && !(decltor instanceof ICASTKnRFunctionDeclarator)) {
            return EMPTY_STRING;
        }
        StringBuffer result = new StringBuffer();
        String[] parms = ASTSignatureUtil.getParameterSignatureArray(decltor);
        result.append(Keywords.cpLPAREN);
        int i = 0;
        while (i < parms.length) {
            if (parms[i] != null) {
                result.append(parms[i]);
                if (i < parms.length - 1) {
                    result.append(COMMA_SPACE);
                }
            }
            ++i;
        }
        result.append(Keywords.cpRPAREN);
        return result.toString();
    }

    public static String[] getParameterSignatureArray(IASTDeclarator decltor) {
        String[] result;
        block8: {
            block7: {
                if (!(decltor instanceof IASTStandardFunctionDeclarator) && !(decltor instanceof ICASTKnRFunctionDeclarator)) {
                    return EMPTY_STRING_ARRAY;
                }
                result = EMPTY_STRING_ARRAY;
                if (!(decltor instanceof IASTStandardFunctionDeclarator)) break block7;
                IASTParameterDeclaration[] parms = null;
                parms = ((IASTStandardFunctionDeclarator)decltor).getParameters();
                if (((IASTStandardFunctionDeclarator)decltor).takesVarArgs()) {
                    result = new String[parms.length + 1];
                    result[parms.length] = "...";
                } else {
                    result = new String[parms.length];
                }
                int i = 0;
                while (i < parms.length) {
                    if (parms[i] != null) {
                        result[i] = ASTSignatureUtil.getSignature(parms[i].getDeclarator());
                    }
                    ++i;
                }
                break block8;
            }
            if (!(decltor instanceof ICASTKnRFunctionDeclarator)) break block8;
            IASTName[] names = null;
            names = ((ICASTKnRFunctionDeclarator)decltor).getParameterNames();
            result = new String[names.length];
            int i = 0;
            while (i < names.length) {
                IASTDeclarator declaratorForParameterName;
                if (names[i] != null && (declaratorForParameterName = ((ICASTKnRFunctionDeclarator)decltor).getDeclaratorForParameterName(names[i])) != null) {
                    result[i] = ASTSignatureUtil.getSignature(declaratorForParameterName);
                }
                ++i;
            }
        }
        return result;
    }

    private static String getDeclaratorSpecificSignature(IASTDeclarator declarator) {
        int n;
        StringBuffer result = new StringBuffer();
        IASTPointerOperator[] ops = declarator.getPointerOperators();
        boolean needSpace = false;
        if (ops != null && ops.length > 0) {
            IASTPointerOperator[] iASTPointerOperatorArray = ops;
            n = ops.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator op = iASTPointerOperatorArray[n2];
                if (op != null) {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    if (op instanceof IASTPointer) {
                        IASTPointer ptr = (IASTPointer)op;
                        result.append(Keywords.cpSTAR);
                        needSpace = true;
                        if (ptr.isConst()) {
                            if (needSpace) {
                                result.append(SPACE);
                            }
                            result.append("const");
                            needSpace = true;
                        }
                        if (ptr.isVolatile()) {
                            if (needSpace) {
                                result.append(SPACE);
                            }
                            result.append("volatile");
                            needSpace = true;
                        }
                        if (ptr.isRestrict()) {
                            if (needSpace) {
                                result.append(SPACE);
                            }
                            result.append("restrict");
                            needSpace = true;
                        }
                    }
                    if (op instanceof ICPPASTReferenceOperator) {
                        if (needSpace) {
                            result.append(SPACE);
                        }
                        result.append(Keywords.cpAMPER);
                        needSpace = true;
                    }
                }
                ++n2;
            }
        }
        if (declarator instanceof IASTArrayDeclarator) {
            IASTArrayModifier[] mods;
            IASTArrayModifier[] iASTArrayModifierArray = mods = ((IASTArrayDeclarator)declarator).getArrayModifiers();
            int n3 = mods.length;
            n = 0;
            while (n < n3) {
                IASTArrayModifier mod = iASTArrayModifierArray[n];
                if (mod != null) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append(Keywords.cpLBRACKET);
                    if (mod instanceof ICASTArrayModifier) {
                        if (((ICASTArrayModifier)mod).isConst()) {
                            if (needSpace) {
                                result.append(SPACE);
                                needSpace = false;
                            }
                            result.append("const");
                            needSpace = true;
                        }
                        if (((ICASTArrayModifier)mod).isRestrict()) {
                            if (needSpace) {
                                result.append(SPACE);
                                needSpace = false;
                            }
                            result.append("restrict");
                            needSpace = true;
                        }
                        if (((ICASTArrayModifier)mod).isStatic()) {
                            if (needSpace) {
                                result.append(SPACE);
                                needSpace = false;
                            }
                            result.append("static");
                            needSpace = true;
                        }
                        if (((ICASTArrayModifier)mod).isVolatile()) {
                            if (needSpace) {
                                result.append(SPACE);
                                needSpace = false;
                            }
                            result.append("volatile");
                        }
                    }
                    result.append(Keywords.cpRBRACKET);
                }
                ++n;
            }
        }
        return result.toString();
    }

    private static String getDeclaratorSignature(IASTDeclarator declarator) {
        if (declarator == null) {
            return EMPTY_STRING;
        }
        StringBuffer result = new StringBuffer();
        result.append(ASTSignatureUtil.getDeclaratorSpecificSignature(declarator));
        if (declarator.getNestedDeclarator() != null) {
            result.append(SPACE);
            result.append(Keywords.cpLPAREN);
            result.append(ASTSignatureUtil.getDeclaratorSignature(declarator.getNestedDeclarator()));
            result.append(Keywords.cpRPAREN);
        }
        result.append(ASTSignatureUtil.getParameterSignature(declarator));
        return result.toString();
    }

    public static String getInitializerString(IASTInitializer init) {
        StringBuffer result = new StringBuffer();
        if (init instanceof IASTEqualsInitializer) {
            result.append(Keywords.cpASSIGN);
            result.append(ASTSignatureUtil.getInitializerClauseString(((IASTEqualsInitializer)init).getInitializerClause()));
        } else if (init instanceof IASTInitializerList) {
            result.append(Keywords.cpLBRACE);
            ASTSignatureUtil.appendExpressionList(result, ((IASTInitializerList)init).getClauses());
            result.append(Keywords.cpRBRACE);
        } else if (init instanceof ICASTDesignatedInitializer) {
            ICASTDesignator[] designators = ((ICASTDesignatedInitializer)init).getDesignators();
            int i = 0;
            while (i < designators.length) {
                result.append(ASTSignatureUtil.getDesignatorSignature(designators[i]));
                if (i < designators.length - 1) {
                    result.append(COMMA_SPACE);
                }
                ++i;
            }
            result.append(Keywords.cpASSIGN);
            result.append(ASTSignatureUtil.getInitializerClauseString(((ICASTDesignatedInitializer)init).getOperand()));
        } else if (init instanceof ICPPASTConstructorInitializer) {
            result.append("(");
            ASTSignatureUtil.appendExpressionList(result, ((ICPPASTConstructorInitializer)init).getArguments());
            result.append(")");
        }
        return result.toString();
    }

    private static void appendExpressionList(StringBuffer result, IASTInitializerClause[] inits) {
        int i = 0;
        while (i < inits.length) {
            result.append(ASTSignatureUtil.getInitializerClauseString(inits[i]));
            if (i < inits.length - 1) {
                result.append(COMMA_SPACE);
            }
            ++i;
        }
    }

    private static String getInitializerClauseString(IASTInitializerClause initializerClause) {
        if (initializerClause instanceof IASTExpression) {
            return ASTSignatureUtil.getExpressionString((IASTExpression)initializerClause);
        }
        if (initializerClause instanceof IASTInitializer) {
            return ASTSignatureUtil.getInitializerString((IASTInitializer)((Object)initializerClause));
        }
        return EMPTY_STRING;
    }

    private static String getDesignatorSignature(ICASTDesignator designator) {
        StringBuffer result = new StringBuffer();
        if (designator instanceof ICASTArrayDesignator) {
            result.append(Keywords.cpLBRACKET);
            result.append(ASTSignatureUtil.getExpressionString(((ICASTArrayDesignator)designator).getSubscriptExpression()));
            result.append(Keywords.cpRBRACKET);
        } else if (designator instanceof ICASTFieldDesignator) {
            result.append(Keywords.cpDOT);
            result.append(((ICASTFieldDesignator)designator).getName().toString());
        } else if (designator instanceof IGCCASTArrayRangeDesignator) {
            result.append(Keywords.cpLBRACKET);
            result.append(ASTSignatureUtil.getExpressionString(((IGCCASTArrayRangeDesignator)designator).getRangeFloor()));
            result.append(SPACE);
            result.append(Keywords.cpELLIPSIS);
            result.append(SPACE);
            result.append(ASTSignatureUtil.getExpressionString(((IGCCASTArrayRangeDesignator)designator).getRangeCeiling()));
            result.append(Keywords.cpRBRACKET);
        }
        return result.toString();
    }

    public static String getSignature(IASTDeclarator declarator) {
        StringBuffer result = new StringBuffer();
        IASTDeclSpecifier declSpec = null;
        IASTNode node = declarator.getParent();
        while (node instanceof IASTDeclarator) {
            declarator = (IASTDeclarator)node;
            node = node.getParent();
        }
        if (node instanceof IASTParameterDeclaration) {
            declSpec = ((IASTParameterDeclaration)node).getDeclSpecifier();
        } else if (node instanceof IASTSimpleDeclaration) {
            declSpec = ((IASTSimpleDeclaration)node).getDeclSpecifier();
        } else if (node instanceof IASTFunctionDefinition) {
            declSpec = ((IASTFunctionDefinition)node).getDeclSpecifier();
        } else if (node instanceof IASTTypeId) {
            declSpec = ((IASTTypeId)node).getDeclSpecifier();
        }
        String specString = ASTSignatureUtil.getSignature(declSpec);
        if (specString != null && !specString.equals(EMPTY_STRING)) {
            result.append(specString);
        }
        String decltorString = ASTSignatureUtil.getDeclaratorSignature(declarator);
        if (specString != null && specString.length() > 0 && decltorString != null && decltorString.length() > 0) {
            result.append(SPACE);
        }
        result.append(decltorString);
        return result.toString();
    }

    public static String getSignature(IASTDeclSpecifier declSpec) {
        if (declSpec == null) {
            return EMPTY_STRING;
        }
        boolean needSpace = false;
        StringBuffer result = new StringBuffer();
        if (declSpec.getStorageClass() == 6) {
            result.append("mutable");
            needSpace = true;
        }
        if (declSpec.getStorageClass() == 4) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append("auto");
            needSpace = true;
        }
        if (declSpec.getStorageClass() == 2) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append("extern");
            needSpace = true;
        }
        if (declSpec.getStorageClass() == 5) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append("register");
            needSpace = true;
        }
        if (declSpec.getStorageClass() == 3) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append("static");
            needSpace = true;
        }
        if (declSpec.getStorageClass() == 1) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append("typedef");
            needSpace = true;
        }
        if (declSpec.isConst()) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append("const");
            needSpace = true;
        }
        if (declSpec.isInline()) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append("inline");
            needSpace = true;
        }
        if (declSpec.isRestrict()) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append("restrict");
            needSpace = true;
        }
        if (declSpec.isVolatile()) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append("volatile");
            needSpace = true;
        }
        if (declSpec instanceof ICPPASTDeclSpecifier) {
            ICPPASTDeclSpecifier cppDeclSpec = (ICPPASTDeclSpecifier)declSpec;
            if (cppDeclSpec.isThreadLocal()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("thread_local");
                needSpace = true;
            }
            if (cppDeclSpec.isConstexpr()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("constexpr");
                needSpace = true;
            }
            if (cppDeclSpec.isExplicit()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("explicit");
                needSpace = true;
            }
            if (cppDeclSpec.isFriend()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("friend");
                needSpace = true;
            }
            if (cppDeclSpec.isVirtual()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("virtual");
                needSpace = true;
            }
        }
        if (declSpec instanceof IASTCompositeTypeSpecifier) {
            result.append(((IASTCompositeTypeSpecifier)declSpec).getName());
        } else if (declSpec instanceof IASTElaboratedTypeSpecifier) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append(((IASTElaboratedTypeSpecifier)declSpec).getName());
        } else if (declSpec instanceof IASTEnumerationSpecifier) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append("enum");
            needSpace = true;
        } else if (declSpec instanceof IASTNamedTypeSpecifier) {
            if (needSpace) {
                result.append(SPACE);
                needSpace = false;
            }
            result.append(((IASTNamedTypeSpecifier)declSpec).getName().toString());
            needSpace = true;
        } else if (declSpec instanceof IASTSimpleDeclSpecifier) {
            IASTSimpleDeclSpecifier sds = (IASTSimpleDeclSpecifier)declSpec;
            if (sds.isLongLong()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("long long");
                needSpace = true;
            }
            if (sds.isComplex()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append(Keywords.c_COMPLEX);
                needSpace = true;
            }
            if (sds.isImaginary()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append(Keywords.c_IMAGINARY);
                needSpace = true;
            }
            if (sds.isLong()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("long");
                needSpace = true;
            }
            if (sds.isShort()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("short");
                needSpace = true;
            }
            if (sds.isSigned()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("signed");
                needSpace = true;
            }
            if (sds.isUnsigned()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("unsigned");
                needSpace = true;
            }
            switch (sds.getType()) {
                case 8: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("typeof");
                    needSpace = true;
                    break;
                }
                case 9: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append(Keywords.cDECLTYPE);
                    needSpace = true;
                    break;
                }
                case 10: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append(Keywords.cAUTO);
                    needSpace = true;
                    break;
                }
                case 6: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    if (declSpec instanceof ICASTSimpleDeclSpecifier) {
                        result.append(Keywords.c_BOOL);
                    } else {
                        result.append("bool");
                    }
                    needSpace = true;
                    break;
                }
                case 2: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("char");
                    needSpace = true;
                    break;
                }
                case 7: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("wchar_t");
                    needSpace = true;
                    break;
                }
                case 11: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("char16_t");
                    needSpace = true;
                    break;
                }
                case 12: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("char32_t");
                    needSpace = true;
                    break;
                }
                case 5: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("double");
                    needSpace = true;
                    break;
                }
                case 4: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("float");
                    needSpace = true;
                    break;
                }
                case 3: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("int");
                    needSpace = true;
                    break;
                }
                case 1: {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("void");
                    needSpace = true;
                }
            }
        }
        return result.toString();
    }

    public static String getSignature(IASTTypeId typeId) {
        return ASTSignatureUtil.getSignature(typeId.getAbstractDeclarator());
    }

    public static String getExpressionString(IASTExpression expression) {
        if (expression instanceof IASTArraySubscriptExpression) {
            return ASTSignatureUtil.getArraySubscriptExpression((IASTArraySubscriptExpression)expression);
        }
        if (expression instanceof IASTBinaryExpression) {
            return ASTSignatureUtil.getBinaryExpression((IASTBinaryExpression)expression);
        }
        if (expression instanceof IASTCastExpression) {
            return ASTSignatureUtil.getCastExpression((IASTCastExpression)expression);
        }
        if (expression instanceof IASTConditionalExpression) {
            return ASTSignatureUtil.getConditionalExpression((IASTConditionalExpression)expression);
        }
        if (expression instanceof IASTExpressionList) {
            return ASTSignatureUtil.getExpressionList((IASTExpressionList)expression);
        }
        if (expression instanceof IASTFieldReference) {
            return ASTSignatureUtil.getFieldReference((IASTFieldReference)expression);
        }
        if (expression instanceof IASTFunctionCallExpression) {
            return ASTSignatureUtil.getFunctionCallExpression((IASTFunctionCallExpression)expression);
        }
        if (expression instanceof IASTIdExpression) {
            return ASTSignatureUtil.getIdExpression((IASTIdExpression)expression);
        }
        if (expression instanceof IASTLiteralExpression) {
            return ASTSignatureUtil.getLiteralExpression((IASTLiteralExpression)expression);
        }
        if (expression instanceof IASTTypeIdExpression) {
            return ASTSignatureUtil.getTypeIdExpression((IASTTypeIdExpression)expression);
        }
        if (expression instanceof IASTUnaryExpression) {
            return ASTSignatureUtil.getUnaryExpression((IASTUnaryExpression)expression);
        }
        if (expression instanceof ICASTTypeIdInitializerExpression) {
            return ASTSignatureUtil.getTypeIdInitializerExpression((ICASTTypeIdInitializerExpression)expression);
        }
        if (expression instanceof ICPPASTDeleteExpression) {
            return ASTSignatureUtil.getDeleteExpression((ICPPASTDeleteExpression)expression);
        }
        if (expression instanceof ICPPASTNewExpression) {
            return ASTSignatureUtil.getNewExpression((ICPPASTNewExpression)expression);
        }
        if (expression instanceof ICPPASTSimpleTypeConstructorExpression) {
            return ASTSignatureUtil.getSimpleTypeConstructorExpression((ICPPASTSimpleTypeConstructorExpression)expression);
        }
        if (expression instanceof IGNUASTCompoundStatementExpression) {
            return ASTSignatureUtil.getCompoundStatementExpression((IGNUASTCompoundStatementExpression)expression);
        }
        if (expression instanceof ICPPASTPackExpansionExpression) {
            return ASTSignatureUtil.getPackExpansionExpression((ICPPASTPackExpansionExpression)expression);
        }
        return ASTSignatureUtil.getEmptyExpression(expression);
    }

    private static String getArraySubscriptExpression(IASTArraySubscriptExpression expression) {
        StringBuffer result = new StringBuffer();
        result.append(ASTSignatureUtil.getExpressionString(expression.getArrayExpression()));
        result.append(Keywords.cpLBRACKET);
        result.append(ASTSignatureUtil.getInitializerClauseString(expression.getArgument()));
        result.append(Keywords.cpRBRACKET);
        return result.toString();
    }

    private static String getCastExpression(IASTCastExpression expression) {
        StringBuffer result = new StringBuffer();
        boolean normalCast = false;
        if (expression.getOperator() == 0) {
            normalCast = true;
        }
        if (normalCast) {
            result.append(Keywords.cpLPAREN);
            result.append(ASTSignatureUtil.getSignature(expression.getTypeId()));
            result.append(Keywords.cpRPAREN);
            result.append(ASTSignatureUtil.getExpressionString(expression.getOperand()));
        } else {
            result.append(ASTSignatureUtil.getCastOperatorString(expression));
            result.append(Keywords.cpLT);
            result.append(ASTSignatureUtil.getSignature(expression.getTypeId()));
            result.append(Keywords.cpGT);
            result.append(Keywords.cpLPAREN);
            result.append(ASTSignatureUtil.getExpressionString(expression.getOperand()));
            result.append(Keywords.cpRPAREN);
        }
        return result.toString();
    }

    private static String getFieldReference(IASTFieldReference expression) {
        StringBuffer result = new StringBuffer();
        result.append(ASTSignatureUtil.getExpressionString(expression.getFieldOwner()));
        if (expression.isPointerDereference()) {
            result.append(Keywords.cpARROW);
        } else {
            result.append(Keywords.cpDOT);
        }
        result.append(expression.getFieldName().toString());
        return result.toString();
    }

    private static String getFunctionCallExpression(IASTFunctionCallExpression expression) {
        StringBuffer result = new StringBuffer();
        result.append(ASTSignatureUtil.getExpressionString(expression.getFunctionNameExpression()));
        result.append(Keywords.cpLPAREN);
        IASTInitializerClause[] clauses = expression.getArguments();
        int i = 0;
        while (i < clauses.length) {
            if (i > 0) {
                result.append(COMMA_SPACE);
            }
            result.append(ASTSignatureUtil.getInitializerClauseString(clauses[i]));
            ++i;
        }
        result.append(Keywords.cpRPAREN);
        return result.toString();
    }

    private static String getTypeIdInitializerExpression(ICASTTypeIdInitializerExpression expression) {
        StringBuffer result = new StringBuffer();
        result.append(Keywords.cpLPAREN);
        result.append(ASTSignatureUtil.getSignature(expression.getTypeId()));
        result.append(Keywords.cpRPAREN);
        result.append(ASTSignatureUtil.getInitializerString(expression.getInitializer()));
        return result.toString();
    }

    private static String getDeleteExpression(ICPPASTDeleteExpression expression) {
        StringBuffer result = new StringBuffer();
        result.append("delete");
        result.append(SPACE);
        if (expression.getOperand() != null) {
            result.append(ASTSignatureUtil.getExpressionString(expression.getOperand()));
        }
        return result.toString();
    }

    private static String getSimpleTypeConstructorExpression(ICPPASTSimpleTypeConstructorExpression expression) {
        StringBuffer result = new StringBuffer();
        result.append(ASTSignatureUtil.getSignature(expression.getDeclSpecifier()));
        result.append(ASTSignatureUtil.getInitializerString(expression.getInitializer()));
        return result.toString();
    }

    private static String getCompoundStatementExpression(IGNUASTCompoundStatementExpression expression) {
        return String.valueOf(Keywords.cpELLIPSIS);
    }

    private static String getTypeIdExpression(IASTTypeIdExpression expression) {
        StringBuffer result = new StringBuffer();
        String operator = ASTSignatureUtil.getTypeIdExpressionOperator(expression);
        if (operator != null && !operator.equals(EMPTY_STRING)) {
            result.append(operator);
        }
        if (operator != null && !operator.equals(EMPTY_STRING)) {
            result.append(SPACE);
            result.append(Keywords.cpLPAREN);
        }
        result.append(ASTSignatureUtil.getSignature(expression.getTypeId()));
        if (operator != null && !operator.equals(EMPTY_STRING)) {
            result.append(Keywords.cpRPAREN);
        }
        return result.toString();
    }

    private static String getExpressionList(IASTExpressionList expression) {
        StringBuffer result = new StringBuffer();
        IASTExpression[] exps = expression.getExpressions();
        if (exps != null && exps.length > 0) {
            int i = 0;
            while (i < exps.length) {
                result.append(ASTSignatureUtil.getExpressionString(exps[i]));
                if (i < exps.length - 1) {
                    result.append(COMMA_SPACE);
                }
                ++i;
            }
        }
        return result.toString();
    }

    private static String getEmptyExpression(IASTExpression expression) {
        return EMPTY_STRING;
    }

    private static String getLiteralExpression(IASTLiteralExpression expression) {
        return expression.toString();
    }

    private static String getIdExpression(IASTIdExpression expression) {
        return expression.getName().toString();
    }

    private static String getConditionalExpression(IASTConditionalExpression expression) {
        StringBuffer result = new StringBuffer();
        result.append(ASTSignatureUtil.getExpressionString(expression.getLogicalConditionExpression()));
        result.append(SPACE);
        result.append(Keywords.cpQUESTION);
        result.append(SPACE);
        IASTExpression positiveExpression = expression.getPositiveResultExpression();
        if (positiveExpression != null) {
            result.append(ASTSignatureUtil.getExpressionString(positiveExpression));
            result.append(SPACE);
        }
        result.append(Keywords.cpCOLON);
        result.append(SPACE);
        result.append(ASTSignatureUtil.getExpressionString(expression.getNegativeResultExpression()));
        return result.toString();
    }

    private static String getNewExpression(ICPPASTNewExpression expression) {
        StringBuffer result = new StringBuffer();
        result.append("new");
        result.append(SPACE);
        IASTInitializerClause[] args = expression.getPlacementArguments();
        if (args != null) {
            result.append("(");
            ASTSignatureUtil.appendExpressionList(result, args);
            result.append(")");
        }
        result.append(ASTSignatureUtil.getSignature(expression.getTypeId()));
        IASTInitializer initializer = expression.getInitializer();
        if (initializer != null) {
            result.append(ASTSignatureUtil.getInitializerString(initializer));
        }
        return result.toString();
    }

    private static String getBinaryExpression(IASTBinaryExpression expression) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ASTSignatureUtil.getExpressionString(expression.getOperand1()));
        buffer.append(SPACE);
        buffer.append(ASTSignatureUtil.getBinaryOperatorString(expression));
        buffer.append(SPACE);
        buffer.append(ASTSignatureUtil.getExpressionString(expression.getOperand2()));
        return buffer.toString();
    }

    private static String getUnaryExpression(IASTUnaryExpression expression) {
        StringBuffer buffer = new StringBuffer();
        boolean postOperator = false;
        boolean primaryBracketed = false;
        switch (expression.getOperator()) {
            case 9: 
            case 10: {
                postOperator = true;
                break;
            }
            case 11: {
                primaryBracketed = true;
                break;
            }
            default: {
                postOperator = false;
            }
        }
        if (!postOperator && !primaryBracketed) {
            buffer.append(ASTSignatureUtil.getUnaryOperatorString(expression));
        }
        switch (expression.getOperator()) {
            case 8: 
            case 12: 
            case 13: {
                buffer.append(SPACE);
            }
        }
        if (primaryBracketed) {
            buffer.append(Keywords.cpLPAREN);
        }
        buffer.append(ASTSignatureUtil.getExpressionString(expression.getOperand()));
        if (primaryBracketed) {
            buffer.append(Keywords.cpRPAREN);
        }
        if (postOperator && !primaryBracketed) {
            buffer.append(ASTSignatureUtil.getUnaryOperatorString(expression));
        }
        return buffer.toString();
    }

    public static String getCastOperatorString(IASTCastExpression expression) {
        int op = expression.getOperator();
        String opString = EMPTY_STRING;
        if (expression instanceof ICPPASTCastExpression) {
            switch (op) {
                case 4: {
                    opString = "const_cast";
                    break;
                }
                case 1: {
                    opString = "dynamic_cast";
                    break;
                }
                case 3: {
                    opString = "reinterpret_cast";
                    break;
                }
                case 2: {
                    opString = "static_cast";
                    break;
                }
            }
        }
        if (!opString.equals(EMPTY_STRING)) {
            return opString;
        }
        switch (op) {
            case 0: {
                opString = "cast";
            }
        }
        return opString;
    }

    public static String getUnaryOperatorString(IASTUnaryExpression ue) {
        int op = ue.getOperator();
        String opString = EMPTY_STRING;
        if (ue instanceof ICPPASTUnaryExpression) {
            switch (op) {
                case 12: {
                    opString = "throw";
                    break;
                }
                case 13: {
                    opString = "typeid";
                }
            }
        }
        if (!opString.equals(EMPTY_STRING)) {
            return opString;
        }
        switch (op) {
            case 15: {
                opString = "alignof";
                break;
            }
            case 5: {
                opString = String.valueOf(Keywords.cpAMPER);
                break;
            }
            case 3: {
                opString = String.valueOf(Keywords.cpMINUS);
                break;
            }
            case 7: {
                opString = String.valueOf(Keywords.cpNOT);
                break;
            }
            case 2: {
                opString = String.valueOf(Keywords.cpPLUS);
                break;
            }
            case 10: {
                opString = String.valueOf(Keywords.cpDECR);
                break;
            }
            case 9: {
                opString = String.valueOf(Keywords.cpINCR);
                break;
            }
            case 1: {
                opString = String.valueOf(Keywords.cpDECR);
                break;
            }
            case 0: {
                opString = String.valueOf(Keywords.cpINCR);
                break;
            }
            case 8: {
                opString = "sizeof";
                break;
            }
            case 16: {
                opString = "sizeof" + new String(Keywords.cpELLIPSIS);
                break;
            }
            case 4: {
                opString = String.valueOf(Keywords.cpSTAR);
                break;
            }
            case 6: {
                opString = String.valueOf(Keywords.cpCOMPL);
            }
        }
        return opString;
    }

    public static String getBinaryOperatorString(IASTBinaryExpression be) {
        int op = be.getOperator();
        String opString = EMPTY_STRING;
        switch (op) {
            case 1: {
                opString = String.valueOf(Keywords.cpSTAR);
                break;
            }
            case 2: {
                opString = String.valueOf(Keywords.cpDIV);
                break;
            }
            case 3: {
                opString = String.valueOf(Keywords.cpMOD);
                break;
            }
            case 4: {
                opString = String.valueOf(Keywords.cpPLUS);
                break;
            }
            case 5: {
                opString = String.valueOf(Keywords.cpMINUS);
                break;
            }
            case 6: {
                opString = String.valueOf(Keywords.cpSHIFTL);
                break;
            }
            case 7: {
                opString = String.valueOf(Keywords.cpSHIFTR);
                break;
            }
            case 8: {
                opString = String.valueOf(Keywords.cpLT);
                break;
            }
            case 9: {
                opString = String.valueOf(Keywords.cpGT);
                break;
            }
            case 10: {
                opString = String.valueOf(Keywords.cpLTEQUAL);
                break;
            }
            case 11: {
                opString = String.valueOf(Keywords.cpGTEQUAL);
                break;
            }
            case 12: {
                opString = String.valueOf(Keywords.cpAMPER);
                break;
            }
            case 13: {
                opString = String.valueOf(Keywords.cpXOR);
                break;
            }
            case 14: {
                opString = String.valueOf(Keywords.cpBITOR);
                break;
            }
            case 15: {
                opString = String.valueOf(Keywords.cpAND);
                break;
            }
            case 16: {
                opString = String.valueOf(Keywords.cpOR);
                break;
            }
            case 17: {
                opString = String.valueOf(Keywords.cpASSIGN);
                break;
            }
            case 18: {
                opString = String.valueOf(Keywords.cpSTARASSIGN);
                break;
            }
            case 19: {
                opString = String.valueOf(Keywords.cpDIVASSIGN);
                break;
            }
            case 20: {
                opString = String.valueOf(Keywords.cpMODASSIGN);
                break;
            }
            case 21: {
                opString = String.valueOf(Keywords.cpPLUSASSIGN);
                break;
            }
            case 22: {
                opString = String.valueOf(Keywords.cpMINUSASSIGN);
                break;
            }
            case 23: {
                opString = String.valueOf(Keywords.cpSHIFTLASSIGN);
                break;
            }
            case 24: {
                opString = String.valueOf(Keywords.cpSHIFTRASSIGN);
                break;
            }
            case 25: {
                opString = String.valueOf(Keywords.cpAMPERASSIGN);
                break;
            }
            case 26: {
                opString = String.valueOf(Keywords.cpXORASSIGN);
                break;
            }
            case 27: {
                opString = String.valueOf(Keywords.cpBITORASSIGN);
                break;
            }
            case 28: {
                opString = String.valueOf(Keywords.cpEQUAL);
                break;
            }
            case 29: {
                opString = String.valueOf(Keywords.cpNOTEQUAL);
                break;
            }
            case 32: {
                opString = String.valueOf(Keywords.cpMAX);
                break;
            }
            case 33: {
                opString = String.valueOf(Keywords.cpMIN);
                break;
            }
            case 31: {
                opString = String.valueOf(Keywords.cpARROW);
                break;
            }
            case 30: {
                opString = String.valueOf(Keywords.cpDOT);
            }
        }
        return opString;
    }

    private static String getTypeIdExpressionOperator(IASTTypeIdExpression expression) {
        String result = EMPTY_STRING;
        if (expression instanceof IGNUASTTypeIdExpression) {
            switch (expression.getOperator()) {
                case 2: {
                    result = "alignof";
                    break;
                }
                case 3: {
                    result = "typeof";
                }
            }
        }
        if (expression instanceof ICPPASTTypeIdExpression) {
            switch (expression.getOperator()) {
                case 1: {
                    result = "typeid";
                }
            }
        }
        if (expression.getOperator() == 0) {
            result = "sizeof";
        }
        return result;
    }

    private static String getPackExpansionExpression(ICPPASTPackExpansionExpression expression) {
        return ASTSignatureUtil.getExpressionString(expression.getPattern()) + Keywords.cpELLIPSIS;
    }

    public static String getProblemMessage(int problemID, String detail) {
        return ASTProblem.getMessage(problemID, detail);
    }
}

