/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTExpressionList;

public class CASTFunctionCallExpression
extends ASTNode
implements IASTFunctionCallExpression,
IASTAmbiguityParent {
    private IASTExpression functionName;
    private IASTInitializerClause[] fArguments;

    public CASTFunctionCallExpression() {
        this.setArguments(null);
    }

    public CASTFunctionCallExpression(IASTExpression functionName, IASTInitializerClause[] args) {
        this.setFunctionNameExpression(functionName);
        this.setArguments(args);
    }

    @Override
    public CASTFunctionCallExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTFunctionCallExpression copy(IASTNode.CopyStyle style) {
        IASTInitializerClause[] args = null;
        if (this.fArguments.length > 0) {
            args = new IASTInitializerClause[this.fArguments.length];
            int i = 0;
            while (i < this.fArguments.length) {
                args[i] = this.fArguments[i].copy(style);
                ++i;
            }
        }
        CASTFunctionCallExpression copy = new CASTFunctionCallExpression(null, args);
        copy.setFunctionNameExpression(this.functionName == null ? null : this.functionName.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public void setFunctionNameExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.functionName = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(FUNCTION_NAME);
        }
    }

    @Override
    public IASTExpression getFunctionNameExpression() {
        return this.functionName;
    }

    @Override
    public IASTInitializerClause[] getArguments() {
        return this.fArguments;
    }

    @Override
    public void setArguments(IASTInitializerClause[] arguments) {
        this.assertNotFrozen();
        if (arguments == null) {
            this.fArguments = IASTExpression.EMPTY_EXPRESSION_ARRAY;
        } else {
            this.fArguments = arguments;
            IASTInitializerClause[] iASTInitializerClauseArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                IASTInitializerClause arg = iASTInitializerClauseArray[n2];
                arg.setParent(this);
                arg.setPropertyInParent(ARGUMENT);
                ++n2;
            }
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.functionName != null && !this.functionName.accept(action)) {
            return false;
        }
        IASTInitializerClause[] iASTInitializerClauseArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            if (!arg.accept(action)) {
                return false;
            }
            ++n2;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.functionName) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.functionName = (IASTExpression)other;
        }
        int i = 0;
        while (i < this.fArguments.length) {
            if (child == this.fArguments[i]) {
                other.setPropertyInParent(child.getPropertyInParent());
                other.setParent(child.getParent());
                this.fArguments[i] = (IASTInitializerClause)other;
            }
            ++i;
        }
    }

    @Override
    public IType getExpressionType() {
        IType type = this.getFunctionNameExpression().getExpressionType();
        while (type instanceof ITypeContainer) {
            type = ((ITypeContainer)type).getType();
        }
        if (type instanceof IFunctionType) {
            return ((IFunctionType)type).getReturnType();
        }
        return new ProblemType(10004);
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    public final IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    @Deprecated
    public IASTExpression getParameterExpression() {
        if (this.fArguments.length == 0) {
            return null;
        }
        if (this.fArguments.length == 1) {
            IASTInitializerClause arg = this.fArguments[0];
            if (arg instanceof IASTExpression) {
                return (IASTExpression)arg;
            }
            return null;
        }
        CASTExpressionList result = new CASTExpressionList();
        IASTInitializerClause[] iASTInitializerClauseArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            if (arg instanceof IASTExpression) {
                result.addExpression(((IASTExpression)arg).copy());
            }
            ++n2;
        }
        result.setParent(this);
        result.setPropertyInParent(ARGUMENT);
        return result;
    }

    @Override
    @Deprecated
    public void setParameterExpression(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression == null) {
            this.setArguments(null);
        } else if (expression instanceof IASTExpressionList) {
            this.setArguments(((IASTExpressionList)expression).getExpressions());
        } else {
            this.setArguments(new IASTExpression[]{expression});
        }
    }
}

