/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTIdExpression
extends ASTNode
implements IASTIdExpression,
IASTCompletionContext {
    private IASTName name;

    public CASTIdExpression() {
    }

    public CASTIdExpression(IASTName name) {
        this.setName(name);
    }

    @Override
    public CASTIdExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTIdExpression copy(IASTNode.CopyStyle style) {
        CASTIdExpression copy = new CASTIdExpression(this.name == null ? null : this.name.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public IASTName getName() {
        return this.name;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ID_NAME);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 1;
        }
        return 3;
    }

    @Override
    public IType getExpressionType() {
        IBinding binding = this.getName().resolveBinding();
        try {
            if (binding instanceof IVariable) {
                return ((IVariable)binding).getType();
            }
            if (binding instanceof IFunction) {
                return ((IFunction)binding).getType();
            }
            if (binding instanceof IEnumerator) {
                return ((IEnumerator)binding).getType();
            }
            if (binding instanceof IProblemBinding) {
                return new ProblemType(10001);
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return new ProblemType(10004);
    }

    @Override
    public boolean isLValue() {
        return true;
    }

    @Override
    public final IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.LVALUE;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        IBinding[] bindings = CVisitor.findBindingsForContentAssist(n, isPrefix);
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i] instanceof IEnumeration || bindings[i] instanceof ICompositeType) {
                bindings[i] = null;
            }
            ++i;
        }
        return ArrayUtil.removeNulls(IBinding.class, bindings);
    }
}

