/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;

public class CPPASTCompoundStatementExpression
extends ASTNode
implements IGNUASTCompoundStatementExpression {
    private IASTCompoundStatement statement;

    public CPPASTCompoundStatementExpression() {
    }

    public CPPASTCompoundStatementExpression(IASTCompoundStatement statement) {
        this.setCompoundStatement(statement);
    }

    @Override
    public CPPASTCompoundStatementExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTCompoundStatementExpression copy(IASTNode.CopyStyle style) {
        CPPASTCompoundStatementExpression copy = new CPPASTCompoundStatementExpression();
        copy.setCompoundStatement(this.statement == null ? null : this.statement.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public IASTCompoundStatement getCompoundStatement() {
        return this.statement;
    }

    @Override
    public void setCompoundStatement(IASTCompoundStatement statement) {
        this.assertNotFrozen();
        this.statement = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(STATEMENT);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.statement != null && !this.statement.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public IType getExpressionType() {
        IASTStatement st;
        IASTCompoundStatement compound = this.getCompoundStatement();
        IASTStatement[] statements = compound.getStatements();
        if (statements.length > 0 && (st = statements[statements.length - 1]) instanceof IASTExpressionStatement) {
            return ExpressionTypes.prvalueType(((IASTExpressionStatement)st).getExpression().getExpressionType());
        }
        return new ProblemType(10004);
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }
}

