/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICPPASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTConstructorInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTConstructorChainInitializer
extends ASTNode
implements ICPPASTConstructorChainInitializer,
IASTImplicitNameOwner,
ICPPASTCompletionContext {
    private IASTName name;
    private IASTImplicitName[] implicitNames;
    private IASTInitializer initializer;
    private boolean fIsPackExpansion;

    public CPPASTConstructorChainInitializer() {
    }

    public CPPASTConstructorChainInitializer(IASTName id, IASTInitializer initializer) {
        this.setMemberInitializerId(id);
        this.setInitializer(initializer);
    }

    @Override
    public CPPASTConstructorChainInitializer copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTConstructorChainInitializer copy(IASTNode.CopyStyle style) {
        CPPASTConstructorChainInitializer copy = new CPPASTConstructorChainInitializer();
        copy.setMemberInitializerId(this.name == null ? null : this.name.copy(style));
        copy.setInitializer(this.initializer == null ? null : this.initializer.copy(style));
        copy.setOffsetAndLength(this);
        copy.fIsPackExpansion = this.fIsPackExpansion;
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public IASTName getMemberInitializerId() {
        return this.name;
    }

    @Override
    public void setMemberInitializerId(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(MEMBER_ID);
        }
    }

    @Override
    public IASTInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public void setInitializer(IASTInitializer init) {
        this.assertNotFrozen();
        this.initializer = init;
        if (init != null) {
            init.setParent(this);
            init.setPropertyInParent(INITIALIZER);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitInitializers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName implicitName = iASTImplicitNameArray[n2];
                if (!implicitName.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.initializer != null && !this.initializer.accept(action)) {
            return false;
        }
        return !action.shouldVisitInitializers || action.leave(this) != 2;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (this.name == n) {
            return 1;
        }
        return 3;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix, String[] namespaces) {
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
        CharArraySet baseClasses = null;
        int i = 0;
        while (i < bindings.length) {
            IBinding b = bindings[i];
            if (!(b instanceof ICPPField) && !(b instanceof ICPPNamespace)) {
                if (b instanceof ICPPConstructor || b instanceof ICPPClassType) {
                    if (baseClasses == null) {
                        baseClasses = this.getBaseClasses(n);
                    }
                    if (!baseClasses.containsKey(b.getNameCharArray())) {
                        bindings[i] = null;
                    }
                } else {
                    bindings[i] = null;
                }
            }
            ++i;
        }
        return ArrayUtil.removeNulls(IBinding.class, bindings);
    }

    private CharArraySet getBaseClasses(IASTName name) {
        CharArraySet result = new CharArraySet(2);
        IASTNode parent = name.getParent();
        while (parent != null) {
            ICPPASTFunctionDefinition fdef;
            IBinding method;
            if (parent instanceof ICPPASTFunctionDefinition && (method = (fdef = (ICPPASTFunctionDefinition)parent).getDeclarator().getName().resolveBinding()) instanceof ICPPMethod) {
                ICPPClassType cls = ((ICPPMethod)method).getClassOwner();
                ICPPBase[] iCPPBaseArray = cls.getBases();
                int n = iCPPBaseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPBase base = iCPPBaseArray[n2];
                    result.put(base.getBaseClassSpecifierName().getSimpleID());
                    ++n2;
                }
                return result;
            }
            parent = parent.getParent();
        }
        return result;
    }

    @Override
    public boolean isPackExpansion() {
        return this.fIsPackExpansion;
    }

    @Override
    public void setIsPackExpansion(boolean val) {
        this.assertNotFrozen();
        this.fIsPackExpansion = val;
    }

    @Override
    @Deprecated
    public IASTExpression getInitializerValue() {
        if (this.initializer == null || this.initializer instanceof IASTExpression) {
            return (IASTExpression)((Object)this.initializer);
        }
        if (this.initializer instanceof ICPPASTConstructorInitializer) {
            IASTExpression expr = ((ICPPASTConstructorInitializer)this.initializer).getExpression();
            if (expr != null) {
                expr = expr.copy();
                expr.setParent(this);
                expr.setPropertyInParent(INITIALIZER);
            }
            return expr;
        }
        return null;
    }

    @Override
    @Deprecated
    public void setInitializerValue(IASTExpression expression) {
        this.assertNotFrozen();
        CPPASTConstructorInitializer ctorInit = new CPPASTConstructorInitializer();
        if (expression == null) {
            this.setInitializer(ctorInit);
        } else if (expression instanceof IASTInitializer) {
            this.setInitializer((IASTInitializer)((Object)expression));
        } else {
            ctorInit.setExpression(expression);
            ctorInit.setOffsetAndLength((ASTNode)((Object)expression));
            this.setInitializer(ctorInit);
        }
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPConstructor ctor = CPPSemantics.findImplicitlyCalledConstructor(this);
            if (ctor == null) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                CPPASTImplicitName ctorName = new CPPASTImplicitName(ctor.getNameCharArray(), (IASTNode)this);
                ctorName.setBinding(ctor);
                IASTName id = this.name;
                if (id instanceof ICPPASTQualifiedName) {
                    id = ((ICPPASTQualifiedName)id).getLastName();
                }
                ctorName.setOffsetAndLength((ASTNode)((Object)id));
                this.implicitNames = new IASTImplicitName[]{ctorName};
            }
        }
        return this.implicitNames;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return this.findBindings(n, isPrefix, null);
    }
}

