/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionCallExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTRangeBasedForStatement
extends ASTAttributeOwner
implements ICPPASTRangeBasedForStatement,
IASTAmbiguityParent {
    private IScope fScope;
    private IASTDeclaration fDeclaration;
    private IASTInitializerClause fInitClause;
    private IASTStatement fBody;
    private IASTImplicitName[] fImplicitNames;

    @Override
    public CPPASTRangeBasedForStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTRangeBasedForStatement copy(IASTNode.CopyStyle style) {
        CPPASTRangeBasedForStatement copy = new CPPASTRangeBasedForStatement();
        copy.setDeclaration(this.fDeclaration == null ? null : this.fDeclaration.copy(style));
        copy.setInitializerClause(this.fInitClause == null ? null : this.fInitClause.copy(style));
        copy.setBody(this.fBody == null ? null : this.fBody.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    @Override
    public void setDeclaration(IASTDeclaration declaration) {
        this.assertNotFrozen();
        this.fDeclaration = declaration;
        if (declaration != null) {
            declaration.setParent(this);
            declaration.setPropertyInParent(DECLARATION);
        }
    }

    @Override
    public IASTInitializerClause getInitializerClause() {
        return this.fInitClause;
    }

    @Override
    public void setInitializerClause(IASTInitializerClause initClause) {
        this.assertNotFrozen();
        this.fInitClause = initClause;
        if (initClause != null) {
            initClause.setParent(this);
            initClause.setPropertyInParent(INITIALIZER);
        }
    }

    @Override
    public IASTStatement getBody() {
        return this.fBody;
    }

    @Override
    public void setBody(IASTStatement statement) {
        this.assertNotFrozen();
        this.fBody = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(BODY);
        }
    }

    @Override
    public IScope getScope() {
        if (this.fScope == null) {
            this.fScope = new CPPBlockScope(this);
        }
        return this.fScope;
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.fImplicitNames == null) {
            IASTInitializerClause forInit = this.getInitializerClause();
            ASTNode position = (ASTNode)((Object)forInit);
            if (forInit instanceof IASTExpression) {
                ICPPClassType ct;
                IASTExpression forInitExpr = (IASTExpression)forInit;
                IType type = SemanticUtil.getNestedType(forInitExpr.getExpressionType(), 9);
                if (type instanceof IArrayType) {
                    this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                } else if (type instanceof ICPPClassType && CPPSemantics.findBindings((ct = (ICPPClassType)type).getCompositeScope(), "begin", true).length > 0) {
                    CPPASTName name = new CPPASTName(CPPVisitor.BEGIN);
                    name.setOffset(position.getOffset());
                    CPPASTFieldReference fieldRef = new CPPASTFieldReference(name, forInitExpr.copy());
                    CPPASTFunctionCallExpression expr = new CPPASTFunctionCallExpression(fieldRef, CPPVisitor.NO_ARGS);
                    expr.setParent(this);
                    expr.setPropertyInParent(ICPPASTRangeBasedForStatement.INITIALIZER);
                    CPPASTImplicitName begin = new CPPASTImplicitName(name.toCharArray(), (IASTNode)this);
                    begin.setBinding(name.resolveBinding());
                    begin.setOffsetAndLength(position);
                    name = new CPPASTName(CPPVisitor.END);
                    name.setOffset(position.getOffset());
                    fieldRef.setFieldName(name);
                    CPPASTImplicitName end = new CPPASTImplicitName(name.toCharArray(), (IASTNode)this);
                    end.setBinding(name.resolveBinding());
                    end.setOffsetAndLength(position);
                    this.fImplicitNames = new IASTImplicitName[]{begin, end};
                }
            }
            if (this.fImplicitNames == null) {
                CPPASTName name = new CPPASTName(CPPVisitor.BEGIN);
                name.setOffset(position.getOffset());
                CPPASTIdExpression fname = new CPPASTIdExpression(name);
                CPPASTFunctionCallExpression expr = new CPPASTFunctionCallExpression(fname, new IASTInitializerClause[]{forInit.copy()});
                expr.setParent(this);
                expr.setPropertyInParent(ICPPASTRangeBasedForStatement.INITIALIZER);
                CPPASTImplicitName begin = new CPPASTImplicitName(name.toCharArray(), (IASTNode)this);
                begin.setBinding(name.resolveBinding());
                begin.setOffsetAndLength(position);
                name = new CPPASTName(CPPVisitor.END);
                name.setOffset(position.getOffset());
                fname.setName(name);
                CPPASTImplicitName end = new CPPASTImplicitName(name.toCharArray(), (IASTNode)this);
                end.setBinding(name.resolveBinding());
                end.setOffsetAndLength(position);
                this.fImplicitNames = new IASTImplicitName[]{begin, end};
            }
        }
        return this.fImplicitNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        IASTImplicitName[] implicits;
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributes(action)) {
            return false;
        }
        if (this.fDeclaration != null && !this.fDeclaration.accept(action)) {
            return false;
        }
        if (this.fInitClause != null && !this.fInitClause.accept(action)) {
            return false;
        }
        IASTImplicitName[] iASTImplicitNameArray = implicits = action.shouldVisitImplicitNames ? this.getImplicitNames() : null;
        if (implicits != null) {
            IASTImplicitName[] iASTImplicitNameArray2 = implicits;
            int n = implicits.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName implicit = iASTImplicitNameArray2[n2];
                if (!implicit.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.fBody != null && !this.fBody.accept(action)) {
            return false;
        }
        return !action.shouldVisitStatements || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fDeclaration) {
            this.setDeclaration((IASTDeclaration)other);
        } else if (child == this.fInitClause) {
            this.setInitializerClause((IASTInitializerClause)other);
        } else if (child == this.fBody) {
            this.setBody((IASTStatement)other);
        }
    }
}

