/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.AbstractGNUSourceCodeParser;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.NameOrTemplateIDVariants;

public class CPPASTTemplateIDAmbiguity
extends ASTAmbiguousNode
implements IASTAmbiguousExpression {
    private AbstractGNUSourceCodeParser.BinaryOperator fLastOperator;
    private IASTInitializerClause fLastExpression;
    private final NameOrTemplateIDVariants.BranchPoint fVariants;
    private IASTNode[] fNodes;
    private AbstractGNUSourceCodeParser fParser;

    public CPPASTTemplateIDAmbiguity(AbstractGNUSourceCodeParser parser, AbstractGNUSourceCodeParser.BinaryOperator lastOperator, IASTInitializerClause expr, NameOrTemplateIDVariants.BranchPoint variants) {
        this.fParser = parser;
        this.fLastOperator = lastOperator;
        this.fLastExpression = expr;
        this.fVariants = variants;
    }

    @Override
    protected final IASTNode doResolveAmbiguity(ASTVisitor resolver) {
        IASTAmbiguityParent owner = (IASTAmbiguityParent)((Object)this.getParent());
        IASTNode nodeToReplace = this;
        int minOffset = -1;
        NameOrTemplateIDVariants.BranchPoint v = this.fVariants;
        while (v != null) {
            NameOrTemplateIDVariants.Variant selected = null;
            int bestCount = 0;
            NameOrTemplateIDVariants.Variant q = v.getFirstVariant();
            while (q != null) {
                IASTName[] templateNames = q.getTemplateNames();
                if (templateNames.length > bestCount) {
                    IASTExpression expression = q.getExpression();
                    if (((ASTNode)((Object)expression)).getOffset() < minOffset) break;
                    owner.replace(nodeToReplace, expression);
                    nodeToReplace = this.resolveNestedAmbiguities(expression, resolver);
                    int count = this.checkNames(templateNames);
                    if (count > bestCount) {
                        selected = q;
                        bestCount = count;
                    }
                }
                q = q.getNext();
            }
            if (selected != null) {
                minOffset = selected.getRightOffset();
                AbstractGNUSourceCodeParser.BinaryOperator targetOp = selected.getTargetOperator();
                if (targetOp == null) {
                    this.fLastExpression = selected.getExpression();
                    this.fLastOperator = v.getLeftOperator();
                } else {
                    targetOp.exchange(selected.getExpression());
                    targetOp.setNext(v.getLeftOperator());
                }
            }
            v = v.getNext();
        }
        owner.replace(nodeToReplace, this);
        IASTExpression expr = this.fParser.buildExpression(this.fLastOperator, this.fLastExpression);
        owner.replace(this, expr);
        expr.accept(resolver);
        return expr;
    }

    private int checkNames(IASTName[] templateNames) {
        int count = 0;
        IASTName[] iASTNameArray = templateNames;
        int n = templateNames.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName templateName = iASTNameArray[n2];
            if (templateName.getTranslationUnit() != null) {
                IBinding b = templateName.resolveBinding();
                if (b instanceof IProblemBinding) {
                    if (!this.containsFunctionTemplate(((IProblemBinding)b).getCandidateBindings())) {
                        return -1;
                    }
                    ++count;
                } else if (b instanceof ICPPSpecialization || b instanceof ICPPTemplateDefinition || b instanceof ICPPConstructor || b instanceof IFunction && b instanceof ICPPUnknownBinding) {
                    ++count;
                } else {
                    return -1;
                }
            }
            ++n2;
        }
        return count;
    }

    private boolean containsFunctionTemplate(IBinding[] candidateBindings) {
        IBinding[] iBindingArray = candidateBindings;
        int n = candidateBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding cand = iBindingArray[n2];
            if (cand instanceof ICPPFunctionTemplate || cand instanceof ICPPFunction && cand instanceof ICPPSpecialization) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IASTNode[] getNodes() {
        if (this.fNodes == null) {
            ArrayList<IASTInitializerClause> nl = new ArrayList<IASTInitializerClause>();
            nl.add(this.fLastExpression);
            AbstractGNUSourceCodeParser.BinaryOperator op = this.fLastOperator;
            while (op != null) {
                nl.add(op.getExpression());
                op = op.getNext();
            }
            Collections.reverse(nl);
            this.fNodes = nl.toArray(new IASTNode[nl.size()]);
        }
        return this.fNodes;
    }

    @Override
    public IASTExpression copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTExpression copy(IASTNode.CopyStyle style) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addExpression(IASTExpression e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTExpression[] getExpressions() {
        throw new UnsupportedOperationException();
    }
}

