/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTTypeIdExpression
extends ASTNode
implements ICPPASTTypeIdExpression {
    private int op;
    private IASTTypeId typeId;

    public CPPASTTypeIdExpression() {
    }

    public CPPASTTypeIdExpression(int op, IASTTypeId typeId) {
        this.op = op;
        this.setTypeId(typeId);
    }

    @Override
    public CPPASTTypeIdExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTTypeIdExpression copy(IASTNode.CopyStyle style) {
        CPPASTTypeIdExpression copy = new CPPASTTypeIdExpression(this.op, this.typeId == null ? null : this.typeId.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public int getOperator() {
        return this.op;
    }

    @Override
    public void setOperator(int value) {
        this.assertNotFrozen();
        this.op = value;
    }

    @Override
    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    @Override
    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public IType getExpressionType() {
        switch (this.getOperator()) {
            case 0: 
            case 2: {
                return CPPVisitor.get_SIZE_T(this);
            }
            case 1: {
                return CPPVisitor.get_type_info(this);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return CPPBasicType.BOOLEAN;
            }
        }
        return CPPVisitor.createType(this.getTypeId());
    }

    @Override
    public boolean isLValue() {
        switch (this.getOperator()) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.isLValue() ? IASTExpression.ValueCategory.LVALUE : IASTExpression.ValueCategory.PRVALUE;
    }
}

