/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.AttributeUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ProblemFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.PlatformObject;

public class CPPFunction
extends PlatformObject
implements ICPPFunction,
ICPPInternalFunction {
    protected IASTDeclarator[] declarations;
    protected ICPPASTFunctionDeclarator definition;
    protected ICPPFunctionType type;
    private static final int FULLY_RESOLVED = 1;
    private static final int RESOLUTION_IN_PROGRESS = 2;
    private int bits = 0;

    public CPPFunction(IASTDeclarator declarator) {
        if (declarator != null) {
            IASTNode parent = ASTQueries.findOutermostDeclarator(declarator).getParent();
            if (parent instanceof IASTFunctionDefinition) {
                if (declarator instanceof ICPPASTFunctionDeclarator) {
                    this.definition = (ICPPASTFunctionDeclarator)declarator;
                }
            } else {
                this.declarations = new IASTDeclarator[]{declarator};
            }
            IASTName name = this.getASTName();
            name.setBinding(this);
        }
    }

    private void resolveAllDeclarations() {
        if ((this.bits & 3) == 0) {
            this.bits |= 2;
            IASTTranslationUnit tu = null;
            if (this.definition != null) {
                tu = this.definition.getTranslationUnit();
            } else if (this.declarations != null) {
                tu = this.declarations[0].getTranslationUnit();
            } else {
                IScope scope = this.getScope();
                IASTNode node = ASTInternal.getPhysicalNodeOfScope(scope);
                if (node != null) {
                    tu = node.getTranslationUnit();
                }
            }
            if (tu != null) {
                CPPVisitor.getDeclarations(tu, this);
            }
            this.declarations = ArrayUtil.trim(IASTDeclarator.class, this.declarations);
            this.bits |= 1;
            this.bits &= 0xFFFFFFFD;
        }
    }

    public IASTDeclarator[] getDeclarations() {
        return this.declarations;
    }

    @Override
    public ICPPASTFunctionDeclarator getDefinition() {
        return this.definition;
    }

    @Override
    public final void addDefinition(IASTNode node) {
        IASTDeclarator dtor = this.extractRelevantDtor(node);
        if (dtor instanceof ICPPASTFunctionDeclarator) {
            ICPPASTFunctionDeclarator fdtor = (ICPPASTFunctionDeclarator)dtor;
            this.updateFunctionParameterBindings(fdtor);
            this.definition = fdtor;
        }
    }

    @Override
    public final void addDeclaration(IASTNode node) {
        IASTDeclarator dtor = this.extractRelevantDtor(node);
        if (dtor == null) {
            return;
        }
        if (dtor instanceof ICPPASTFunctionDeclarator) {
            this.updateFunctionParameterBindings((ICPPASTFunctionDeclarator)dtor);
        }
        this.declarations = this.declarations == null || this.declarations.length == 0 ? new IASTDeclarator[]{dtor} : (((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? ArrayUtil.prepend(this.declarations, dtor) : ArrayUtil.append(this.declarations, dtor));
    }

    private IASTDeclarator extractRelevantDtor(IASTNode node) {
        while (node instanceof IASTName) {
            node = node.getParent();
        }
        if (!(node instanceof IASTDeclarator)) {
            return null;
        }
        return ASTQueries.findTypeRelevantDeclarator((IASTDeclarator)node);
    }

    @Override
    public ICPPParameter[] getParameters() {
        ICPPASTFunctionDeclarator dtor = this.getPreferredDtor();
        if (dtor == null) {
            return CPPBuiltinParameter.createParameterList(this.getType());
        }
        IASTParameterDeclaration[] params = dtor.getParameters();
        int size = params.length;
        ICPPParameter[] result = new ICPPParameter[size];
        if (size > 0) {
            int i = 0;
            while (i < size) {
                IASTParameterDeclaration p = params[i];
                IASTName name = this.getParamName(p);
                IBinding binding = name.resolveBinding();
                result[i] = binding instanceof ICPPParameter ? (ICPPParameter)binding : new CPPParameter.CPPParameterProblem(p, 5, name.toCharArray());
                ++i;
            }
        }
        return result;
    }

    @Override
    public IScope getFunctionScope() {
        this.resolveAllDeclarations();
        if (this.definition != null) {
            return this.definition.getFunctionScope();
        }
        IASTDeclarator[] iASTDeclaratorArray = this.declarations;
        int n = this.declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclarator dtor = iASTDeclaratorArray[n2];
            if (dtor instanceof ICPPASTFunctionDeclarator) {
                return ((ICPPASTFunctionDeclarator)dtor).getFunctionScope();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getASTName().toString();
    }

    @Override
    public char[] getNameCharArray() {
        return this.getASTName().getSimpleID();
    }

    protected IASTName getASTName() {
        IASTDeclarator dtor = this.definition != null ? this.definition : this.declarations[0];
        IASTName name = (dtor = ASTQueries.findInnermostDeclarator(dtor)).getName();
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        return name;
    }

    @Override
    public IScope getScope() {
        IASTName n = this.getASTName();
        IScope scope = CPPVisitor.getContainingScope(n);
        if (scope instanceof ICPPClassScope) {
            IASTNode node;
            ICPPASTDeclSpecifier declSpec = null;
            if (this.definition != null) {
                node = ASTQueries.findOutermostDeclarator(this.definition).getParent();
                IASTFunctionDefinition def = (IASTFunctionDefinition)node;
                declSpec = (ICPPASTDeclSpecifier)def.getDeclSpecifier();
            } else {
                node = ASTQueries.findOutermostDeclarator(this.declarations[0]).getParent();
                IASTSimpleDeclaration decl = (IASTSimpleDeclaration)node;
                declSpec = (ICPPASTDeclSpecifier)decl.getDeclSpecifier();
            }
            if (declSpec.isFriend()) {
                try {
                    while (scope instanceof ICPPClassScope) {
                        scope = scope.getParent();
                    }
                }
                catch (DOMException dOMException) {}
            }
        }
        return scope;
    }

    @Override
    public ICPPFunctionType getType() {
        if (this.type == null) {
            IType t = SemanticUtil.getNestedType(CPPVisitor.createType(this.definition != null ? this.definition : this.declarations[0]), 1);
            this.type = t instanceof ICPPFunctionType ? (ICPPFunctionType)t : (t instanceof ISemanticProblem ? new ProblemFunctionType(((ISemanticProblem)((Object)t)).getID()) : new ProblemFunctionType(10001));
        }
        return this.type;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IBinding resolveParameter(CPPParameter param) {
        pos = param.getParameterPosition();
        tdeclLen = this.declarations == null ? 0 : this.declarations.length;
        i = -1;
        while (i < tdeclLen) {
            block6: {
                block5: {
                    if (i != -1) break block5;
                    tdecl = this.definition;
                    if (tdecl != null) ** GOTO lbl16
                    break block6;
                }
                dtor = this.declarations[i];
                if (!(dtor instanceof ICPPASTFunctionDeclarator)) {
                    if (dtor == null) {
                        break;
                    }
                } else {
                    tdecl = (ICPPASTFunctionDeclarator)dtor;
lbl16:
                    // 2 sources

                    if (pos < (params = tdecl.getParameters()).length) {
                        oName = this.getParamName(params[pos]);
                        return oName.resolvePreBinding();
                    }
                }
            }
            ++i;
        }
        return param;
    }

    private IASTName getParamName(IASTParameterDeclaration paramDecl) {
        return ASTQueries.findInnermostDeclarator(paramDecl.getDeclarator()).getName();
    }

    /*
     * Unable to fully structure code
     */
    protected final void updateFunctionParameterBindings(ICPPASTFunctionDeclarator fdtor) {
        updateParams = fdtor.getParameters();
        k = 0;
        tdeclLen = this.declarations == null ? 0 : this.declarations.length;
        i = -1;
        while (i < tdeclLen && k < updateParams.length) {
            block6: {
                block5: {
                    if (i != -1) break block5;
                    tdecl = this.definition;
                    if (tdecl != null) ** GOTO lbl17
                    break block6;
                }
                dtor = this.declarations[i];
                if (!(dtor instanceof ICPPASTFunctionDeclarator)) {
                    if (dtor == null) {
                        break;
                    }
                } else {
                    tdecl = (ICPPASTFunctionDeclarator)dtor;
lbl17:
                    // 2 sources

                    params = tdecl.getParameters();
                    end = Math.min(params.length, updateParams.length);
                    while (k < end) {
                        oName = this.getParamName(params[k]);
                        b = oName.resolvePreBinding();
                        n = this.getParamName(updateParams[k]);
                        n.setBinding(b);
                        ASTInternal.addDeclaration(b, n);
                        ++k;
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public final boolean isStatic() {
        return this.isStatic(true);
    }

    @Override
    public boolean isStatic(boolean resolveAll) {
        if (resolveAll && (this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        return CPPFunction.hasStorageClass(this, 3);
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public static boolean hasStorageClass(ICPPInternalFunction function, int storage) {
        IASTDeclarator dtor = (IASTDeclarator)function.getDefinition();
        IASTNode[] ds = function.getDeclarations();
        int i = -1;
        do {
            if (dtor == null) continue;
            IASTNode parent = dtor.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || declSpec.getStorageClass() != storage) continue;
            return true;
        } while (ds != null && ++i < ds.length && (dtor = (IASTDeclarator)ds[i]) != null);
        return false;
    }

    @Override
    public boolean isDeleted() {
        return CPPFunction.isDeletedDefinition(this.getDefinition());
    }

    public static boolean isDeletedDefinition(IASTNode def) {
        while (def != null && !(def instanceof IASTDeclaration)) {
            def = def.getParent();
        }
        if (def instanceof ICPPASTFunctionDefinition) {
            return ((ICPPASTFunctionDefinition)def).isDeleted();
        }
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isInline() {
        IASTDeclarator dtor = this.getDefinition();
        IASTDeclarator[] ds = this.getDeclarations();
        int i = -1;
        do {
            if (dtor == null) continue;
            IASTNode parent = dtor.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || !declSpec.isInline()) continue;
            return true;
        } while (ds != null && ++i < ds.length && (dtor = ds[i]) != null);
        return false;
    }

    @Override
    public boolean isExternC() {
        if (CPPVisitor.isExternC(this.getDefinition())) {
            return true;
        }
        IASTDeclarator[] ds = this.getDeclarations();
        if (ds != null) {
            IASTDeclarator[] iASTDeclaratorArray = ds;
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator element = iASTDeclaratorArray[n2];
                if (CPPVisitor.isExternC(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean isExtern() {
        return CPPFunction.hasStorageClass(this, 2);
    }

    @Override
    public boolean isAuto() {
        return CPPFunction.hasStorageClass(this, 4);
    }

    @Override
    public boolean isRegister() {
        return CPPFunction.hasStorageClass(this, 5);
    }

    @Override
    public boolean takesVarArgs() {
        ICPPASTFunctionDeclarator dtor = this.getPreferredDtor();
        return dtor != null ? dtor.takesVarArgs() : false;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        ICPPFunctionType t = this.getType();
        result.append(t != null ? ASTTypeUtil.getParameterTypeString(t) : "()");
        return result.toString();
    }

    @Override
    public IBinding getOwner() {
        return CPPVisitor.findNameOwner(this.getASTName(), false);
    }

    @Override
    public IType[] getExceptionSpecification() {
        ICPPASTFunctionDeclarator declarator = this.getPreferredDtor();
        if (declarator != null) {
            IASTTypeId[] astTypeIds = declarator.getExceptionSpecification();
            if (astTypeIds.equals(ICPPASTFunctionDeclarator.NO_EXCEPTION_SPECIFICATION)) {
                return null;
            }
            if (astTypeIds.equals(IASTTypeId.EMPTY_TYPEID_ARRAY)) {
                return IType.EMPTY_TYPE_ARRAY;
            }
            IType[] typeIds = new IType[astTypeIds.length];
            int i = 0;
            while (i < astTypeIds.length) {
                typeIds[i] = CPPVisitor.createType(astTypeIds[i]);
                ++i;
            }
            return typeIds;
        }
        return null;
    }

    protected ICPPASTFunctionDeclarator getPreferredDtor() {
        ICPPASTFunctionDeclarator dtor = this.getDefinition();
        if (dtor != null) {
            return dtor;
        }
        IASTDeclarator[] dtors = this.getDeclarations();
        if (dtors != null) {
            IASTDeclarator[] iASTDeclaratorArray = dtors;
            int n = dtors.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator declarator = iASTDeclaratorArray[n2];
                if (declarator instanceof ICPPASTFunctionDeclarator) {
                    return (ICPPASTFunctionDeclarator)declarator;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public int getRequiredArgumentCount() {
        return CPPFunction.getRequiredArgumentCount(this.getParameters());
    }

    public static int getRequiredArgumentCount(ICPPParameter[] pars) {
        for (int result = pars.length; result > 0; --result) {
            ICPPParameter p = pars[result - 1];
            if (p.hasDefaultValue() || p.isParameterPack()) {
                continue;
            }
            if (pars.length == 1 && SemanticUtil.isVoidType(p.getType())) {
                return 0;
            }
            return result;
        }
        return 0;
    }

    @Override
    public boolean hasParameterPack() {
        ICPPParameter[] pars = this.getParameters();
        return pars.length > 0 && pars[pars.length - 1].isParameterPack();
    }

    @Override
    public boolean isNoReturn() {
        ICPPASTFunctionDeclarator dtor = this.getPreferredDtor();
        return dtor != null && AttributeUtil.hasNoreturnAttribute(dtor);
    }
}

