/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.core.runtime.Assert;

public class CPPTypedefSpecialization
extends CPPSpecialization
implements ITypedef,
ITypeContainer {
    public static final int MAX_RESOLUTION_DEPTH = 5;
    public static final int MAX_TYPE_NESTING = 60;
    private IType type;
    private int fResolutionDepth;

    public CPPTypedefSpecialization(IBinding specialized, ICPPClassType owner, ICPPTemplateParameterMap tpmap) {
        super(specialized, owner, tpmap);
    }

    private ITypedef getTypedef() {
        return (ITypedef)this.getSpecializedBinding();
    }

    @Override
    public IType getType() {
        return this.getType(60);
    }

    private IType getType(int maxDepth) {
        if (this.type == null) {
            try {
                if (++this.fResolutionDepth > 5) {
                    this.type = new RecursionResolvingBinding(this.getDefinition(), this.getNameCharArray());
                } else {
                    this.type = this.specializeType(this.getTypedef().getType());
                    if (!this.verifyType(this.type, maxDepth)) {
                        this.type = new RecursionResolvingBinding(this.getDefinition(), this.getNameCharArray());
                    }
                }
            }
            finally {
                --this.fResolutionDepth;
            }
        }
        return this.type;
    }

    private boolean verifyType(IType type, int maxTypeNesting) {
        while (true) {
            if (--maxTypeNesting < 0) {
                return false;
            }
            if (this.equals(type)) {
                return false;
            }
            if (type instanceof CPPTypedefSpecialization) {
                type = ((CPPTypedefSpecialization)type).getType(maxTypeNesting);
                continue;
            }
            if (!(type instanceof ITypeContainer)) break;
            type = ((ITypeContainer)type).getType();
        }
        return true;
    }

    public int incResolutionDepth(int increment) {
        this.fResolutionDepth += increment;
        return this.fResolutionDepth;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    @Override
    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            IType t = this.getType();
            if (t != null) {
                return t.isSameType(((ITypedef)o).getType());
            }
            return false;
        }
        IType t = this.getType();
        if (t != null) {
            return t.isSameType(o);
        }
        return false;
    }

    @Override
    public void setType(IType type) {
        this.type = type;
    }

    static final class RecursionResolvingBinding
    extends ProblemBinding {
        public RecursionResolvingBinding(IASTNode node, char[] arg) {
            super(node, 14, arg);
            Assert.isTrue((boolean)CPPASTNameBase.sAllowRecursionBindings, (String)this.getMessage());
        }
    }
}

