/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;

public class FunctionSetType
implements IType {
    private ICPPFunction[] fFunctionSet;
    private boolean fPointerType;
    private IASTName fName;

    public FunctionSetType(ICPPFunction[] functions, IASTName name, boolean addressOf) {
        this.fName = name;
        this.fFunctionSet = functions;
        this.fPointerType = addressOf;
    }

    @Override
    public boolean isSameType(IType type) {
        return type == this;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public IASTExpression.ValueCategory getValueCategory() {
        return this.fPointerType ? IASTExpression.ValueCategory.PRVALUE : IASTExpression.ValueCategory.LVALUE;
    }

    public Cost costForTarget(IType paramType) {
        ICPPFunction result = CPPSemantics.resolveTargetedFunction(paramType, this.fName, this.fFunctionSet);
        if (result instanceof ICPPFunction && !(result instanceof IProblemBinding)) {
            Cost c = new Cost(paramType, paramType, Cost.Rank.IDENTITY);
            c.setSelectedFunction(result);
            return c;
        }
        return Cost.NO_CONVERSION;
    }

    public void applySelectedFunction(ICPPFunction selectedFunction) {
        if (selectedFunction != null) {
            this.fName.setBinding(selectedFunction);
        }
    }

    public ICPPFunction[] getFunctionSet() {
        return this.fFunctionSet;
    }

    public void setToUnknown() {
        this.fName.setBinding(new CPPUnknownFunction(null, this.fName.toCharArray()));
    }
}

