/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;

class InitializerListType
implements IType {
    private final ICPPASTInitializerList fInitializerList;
    private IType[] fExpressionTypes;
    private IASTExpression.ValueCategory[] fLValues;

    public InitializerListType(ICPPASTInitializerList list) {
        this.fInitializerList = list;
    }

    @Override
    public boolean isSameType(IType type) {
        return false;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ICPPASTInitializerList getInitializerList() {
        return this.fInitializerList;
    }

    public IType[] getExpressionTypes() {
        if (this.fExpressionTypes == null) {
            IASTInitializerClause[] clauses = this.fInitializerList.getClauses();
            this.fExpressionTypes = new IType[clauses.length];
            int i = 0;
            while (i < clauses.length) {
                IASTInitializerClause clause = clauses[i];
                if (clause instanceof IASTExpression) {
                    this.fExpressionTypes[i] = ((IASTExpression)clause).getExpressionType();
                } else if (clause instanceof ICPPASTInitializerList) {
                    this.fExpressionTypes[i] = new InitializerListType((ICPPASTInitializerList)clause);
                } else assert (false);
                ++i;
            }
        }
        return this.fExpressionTypes;
    }

    public IASTExpression.ValueCategory[] getValueCategories() {
        if (this.fLValues == null) {
            IASTInitializerClause[] clauses = this.fInitializerList.getClauses();
            this.fLValues = new IASTExpression.ValueCategory[clauses.length];
            int i = 0;
            while (i < clauses.length) {
                IASTInitializerClause clause = clauses[i];
                if (clause instanceof IASTExpression) {
                    this.fLValues[i] = ((IASTExpression)clause).getValueCategory();
                }
                ++i;
            }
        }
        return this.fLValues;
    }
}

