/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPackExpansionExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPCompositeBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class LookupData {
    protected IASTName astName;
    protected CPPASTTranslationUnit tu;
    public Map<ICPPNamespaceScope, List<ICPPNamespaceScope>> usingDirectives = Collections.emptyMap();
    public ObjectSet<IScope> visited = new ObjectSet(1);
    public boolean checkWholeClassScope = false;
    public boolean ignoreUsingDirectives = false;
    public boolean usingDirectivesOnly = false;
    public boolean forceQualified = false;
    public boolean forAssociatedScopes = false;
    public boolean contentAssist = false;
    public boolean prefixLookup = false;
    public boolean typesOnly = false;
    public boolean checkPointOfDecl = true;
    public boolean usesEnclosingScope = true;
    public boolean argsContainImpliedObject = false;
    public boolean ignoreMembers = false;
    public boolean fNoNarrowing = false;
    private IASTInitializerClause[] functionArgs;
    private IType[] functionArgTypes;
    private IASTExpression.ValueCategory[] functionArgValueCategories;
    public ICPPClassType skippedScope;
    public Object foundItems = null;
    public ProblemBinding problem;

    public LookupData(IASTName n) {
        this.astName = n;
        this.tu = (CPPASTTranslationUnit)this.astName.getTranslationUnit();
        this.typesOnly = LookupData.typesOnly(this.astName);
        this.checkWholeClassScope = LookupData.checkWholeClassScope(n);
    }

    public LookupData() {
        this.astName = null;
    }

    public final char[] getNameCharArray() {
        if (this.astName != null) {
            return this.astName.toCharArray();
        }
        return CharArrayUtils.EMPTY;
    }

    public boolean includeBlockItem(IASTNode item) {
        if (this.astName.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return true;
        }
        return this.astName != null && this.astName.getParent() instanceof IASTIdExpression || item instanceof ICPPASTNamespaceDefinition || item instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)item).getDeclSpecifier() instanceof IASTCompositeTypeSpecifier || item instanceof ICPPASTTemplateDeclaration;
    }

    static boolean typesOnly(IASTName name) {
        if (name == null) {
            return false;
        }
        if (name.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTNode parent = name.getParent();
        if (parent instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier || parent instanceof ICPPASTElaboratedTypeSpecifier || parent instanceof ICPPASTCompositeTypeSpecifier) {
            return true;
        }
        if (parent instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)parent).getNames();
            return name != ns[ns.length - 1];
        }
        return false;
    }

    public boolean forUsingDeclaration() {
        IASTNode p2;
        if (this.astName == null) {
            return false;
        }
        if (this.astName.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTNode p1 = this.astName.getParent();
        if (p1 instanceof ICPPASTUsingDeclaration) {
            return true;
        }
        if (p1 instanceof ICPPASTQualifiedName && (p2 = p1.getParent()) instanceof ICPPASTUsingDeclaration) {
            IASTName[] ns = ((ICPPASTQualifiedName)p1).getNames();
            return ns[ns.length - 1] == this.astName;
        }
        return false;
    }

    public IASTDeclaration forDeclaration() {
        IASTNode node = this.getDeclarator();
        while (node instanceof IASTDeclarator) {
            node = node.getParent();
        }
        if (node instanceof IASTSimpleDeclaration || node instanceof IASTFunctionDefinition) {
            return (IASTDeclaration)node;
        }
        return null;
    }

    public IASTDeclarator getDeclarator() {
        IASTNode node;
        IASTName name = this.astName;
        if (name == null || name.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return null;
        }
        if (name.getParent() instanceof ICPPASTTemplateId) {
            name = (IASTName)name.getParent();
        }
        if ((node = name.getParent()) instanceof ICPPASTQualifiedName) {
            if (((ICPPASTQualifiedName)node).getLastName() != name) {
                return null;
            }
            node = node.getParent();
        }
        if (node instanceof IASTDeclarator) {
            return (IASTDeclarator)node;
        }
        return null;
    }

    public boolean forExplicitFunctionSpecialization() {
        IASTDeclaration decl = this.forDeclaration();
        if (decl != null) {
            IASTName n = this.astName;
            if (n.getParent() instanceof ICPPASTTemplateId) {
                n = (IASTName)n.getParent();
            }
            ICPPASTTemplateDeclaration tmplDecl = CPPTemplates.getTemplateDeclaration(n);
            return tmplDecl instanceof ICPPASTTemplateSpecialization;
        }
        return false;
    }

    public boolean forExplicitFunctionInstantiation() {
        IASTDeclaration decl = this.forDeclaration();
        return decl != null && decl.getParent() instanceof ICPPASTExplicitTemplateInstantiation;
    }

    public boolean qualified() {
        if (this.forceQualified) {
            return true;
        }
        IASTName n = this.astName;
        if (n == null || n.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTNode p = n.getParent();
        if (p instanceof ICPPASTTemplateId) {
            n = (IASTName)p;
            p = p.getParent();
        }
        if (p instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qname = (ICPPASTQualifiedName)p;
            if (qname.isFullyQualified()) {
                return true;
            }
            IASTName[] qnames = qname.getNames();
            if (qnames.length > 0 && qnames[0] != n) {
                return true;
            }
        }
        return p instanceof ICPPASTFieldReference;
    }

    public boolean isFunctionCall() {
        if (this.astName == null) {
            return false;
        }
        if (this.astName.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTNode p1 = this.astName.getParent();
        if (p1 instanceof ICPPASTQualifiedName) {
            p1 = p1.getParent();
        }
        return p1 instanceof IASTIdExpression && p1.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkWholeClassScope(IASTName name) {
        if (name == null) {
            return false;
        }
        if (name.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return true;
        }
        node = name.getParent();
        while (node instanceof IASTName) {
            name = (IASTName)node;
            node = name.getParent();
        }
        nameProp = name.getPropertyInParent();
        if (nameProp == IASTIdExpression.ID_NAME || nameProp == IASTFieldReference.FIELD_NAME || nameProp == ICASTFieldDesignator.FIELD_NAME || nameProp == ICPPASTUsingDirective.QUALIFIED_NAME || nameProp == ICPPASTUsingDeclaration.NAME || nameProp == IASTFunctionCallExpression.FUNCTION_NAME || nameProp == IASTNamedTypeSpecifier.NAME || nameProp == ICPPASTConstructorChainInitializer.MEMBER_ID) ** GOTO lbl40
        return false;
lbl-1000:
        // 1 sources

        {
            if (node.getParent() instanceof IASTFunctionDefinition) {
                prop = node.getPropertyInParent();
                if (prop == IASTFunctionDefinition.DECL_SPECIFIER || prop == IASTFunctionDefinition.DECLARATOR) {
                    return false;
                }
                parent = node.getParent();
                while (parent != null) {
                    if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                        return true;
                    }
                    parent = parent.getParent();
                }
                return false;
            }
            if ((node instanceof IASTInitializerList || node instanceof IASTEqualsInitializer) && node.getPropertyInParent() == IASTDeclarator.INITIALIZER) {
                decl = node.getParent();
                while (decl instanceof IASTDeclarator) {
                    decl = decl.getParent();
                }
                if (decl instanceof IASTParameterDeclaration) {
                    parent = decl.getParent();
                    while (parent != null) {
                        if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                            return true;
                        }
                        parent = parent.getParent();
                    }
                    return false;
                }
                if (decl instanceof IASTSimpleDeclaration && decl.getPropertyInParent() == IASTCompositeTypeSpecifier.MEMBER_DECLARATION && (declSpec = ((IASTSimpleDeclaration)decl).getDeclSpecifier()).getStorageClass() != 3) {
                    return true;
                }
            }
            node = node.getParent();
lbl40:
            // 2 sources

            ** while (node != null)
        }
lbl41:
        // 1 sources

        return false;
    }

    public boolean hasResultOrProblem() {
        return this.problem != null || this.hasResults();
    }

    public boolean hasResults() {
        if (this.foundItems == null) {
            return false;
        }
        if (this.foundItems instanceof Object[]) {
            return ((Object[])this.foundItems).length != 0;
        }
        if (this.foundItems instanceof CharArrayObjectMap) {
            return ((CharArrayObjectMap)this.foundItems).size() != 0;
        }
        return false;
    }

    public boolean hasTypeOrMemberFunctionResult() {
        if (this.foundItems == null) {
            return false;
        }
        if (this.foundItems instanceof Object[]) {
            Object[] objectArray = (Object[])this.foundItems;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof ICPPMethod || item instanceof IType) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public IType getImpliedObjectType() {
        if (this.astName == null) {
            return null;
        }
        IASTName name = this.astName;
        IASTNode nameParent = name.getParent();
        while (nameParent instanceof IASTName) {
            name = (IASTName)nameParent;
            nameParent = name.getParent();
        }
        ASTNodeProperty prop = name.getPropertyInParent();
        if (prop == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return null;
        }
        if (prop == IASTFieldReference.FIELD_NAME) {
            ICPPASTFieldReference fieldRef = (ICPPASTFieldReference)nameParent;
            return fieldRef.getFieldOwnerType();
        }
        if (prop == IASTIdExpression.ID_NAME) {
            IScope scope = CPPVisitor.getContainingScope(name);
            if (scope instanceof ICPPClassScope) {
                return ((ICPPClassScope)scope).getClassType();
            }
            return CPPVisitor.getImpliedObjectType(scope);
        }
        return null;
    }

    public boolean forFriendship() {
        if (this.astName == null) {
            return false;
        }
        IASTNode node = this.astName.getParent();
        while (node instanceof IASTName) {
            node = node.getParent();
        }
        IASTDeclaration decl = null;
        IASTDeclarator dtor = null;
        if (node instanceof ICPPASTDeclSpecifier && node.getParent() instanceof IASTDeclaration) {
            decl = (IASTDeclaration)node.getParent();
        } else if (node instanceof IASTDeclarator) {
            dtor = (IASTDeclarator)node;
            while (dtor.getParent() instanceof IASTDeclarator) {
                dtor = (IASTDeclarator)dtor.getParent();
            }
            if (!(dtor.getParent() instanceof IASTDeclaration)) {
                return false;
            }
            decl = (IASTDeclaration)dtor.getParent();
        } else {
            return false;
        }
        if (decl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simple = (IASTSimpleDeclaration)decl;
            if (!((ICPPASTDeclSpecifier)simple.getDeclSpecifier()).isFriend()) {
                return false;
            }
            if (dtor != null) {
                return true;
            }
            return simple.getDeclarators().length == 0;
        }
        if (decl instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fnDef = (IASTFunctionDefinition)decl;
            if (!((ICPPASTDeclSpecifier)fnDef.getDeclSpecifier()).isFriend()) {
                return false;
            }
            return dtor != null;
        }
        return false;
    }

    public boolean checkAssociatedScopes() {
        IASTName name = this.astName;
        if (name == null || name instanceof ICPPASTQualifiedName) {
            return false;
        }
        IASTNode parent = name.getParent();
        if (name.getPropertyInParent() == ICPPASTTemplateId.TEMPLATE_NAME) {
            parent = parent.getParent();
        }
        if (parent instanceof ICPPASTQualifiedName) {
            return false;
        }
        return this.isFunctionCall();
    }

    public boolean checkClassContainingFriend() {
        if (this.astName == null || this.astName instanceof ICPPASTQualifiedName) {
            return false;
        }
        IASTNode p = this.astName.getParent();
        ASTNodeProperty prop = null;
        while (p != null) {
            prop = p.getPropertyInParent();
            if (prop == ICPPASTTemplateId.TEMPLATE_ID_ARGUMENT || prop == IASTDeclarator.DECLARATOR_NAME) {
                return false;
            }
            if (p instanceof IASTDeclarator && !(((IASTDeclarator)p).getName() instanceof ICPPASTQualifiedName)) {
                return false;
            }
            if (p instanceof IASTDeclaration) {
                if (prop == IASTCompositeTypeSpecifier.MEMBER_DECLARATION) {
                    return CPPVisitor.isFriendDeclaration(p);
                }
                return false;
            }
            p = p.getParent();
        }
        return false;
    }

    public void setFunctionArguments(boolean containsImpliedObject, IASTInitializerClause ... exprs) {
        this.argsContainImpliedObject = containsImpliedObject;
        this.functionArgs = exprs;
        if (exprs.length != 0) {
            IASTNode node = exprs[0];
            boolean checkForDependentName = false;
            while (node != null) {
                if (node instanceof ICPPASTTemplateDeclaration) {
                    checkForDependentName = true;
                    break;
                }
                node = node.getParent();
            }
            if (checkForDependentName) {
                IType[] types;
                IType[] iTypeArray = types = this.getFunctionArgumentTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (CPPTemplates.isDependentType(type)) {
                        this.checkPointOfDecl = false;
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    public IType[] getFunctionArgumentTypes() {
        if (this.functionArgTypes == null && this.functionArgs != null) {
            IASTInitializerClause[] exprs = this.functionArgs;
            this.functionArgTypes = new IType[exprs.length];
            int i = 0;
            while (i < exprs.length) {
                IASTInitializerClause e = exprs[i];
                if (e instanceof IASTExpression) {
                    IType t = ExpressionTypes.typeOrFunctionSet((IASTExpression)e);
                    this.functionArgTypes[i] = SemanticUtil.getSimplifiedType(t);
                } else if (e instanceof ICPPASTInitializerList) {
                    this.functionArgTypes[i] = new InitializerListType((ICPPASTInitializerList)e);
                }
                ++i;
            }
        }
        return this.functionArgTypes;
    }

    public IASTExpression.ValueCategory[] getFunctionArgumentValueCategories() {
        IASTInitializerClause[] args;
        if (this.functionArgValueCategories == null && (args = this.functionArgs) != null) {
            this.functionArgValueCategories = new IASTExpression.ValueCategory[args.length];
            int i = 0;
            while (i < args.length) {
                IASTInitializerClause arg = args[i];
                if (arg instanceof IASTExpression) {
                    this.functionArgValueCategories[i] = ExpressionTypes.valueCat((IASTExpression)arg);
                }
                ++i;
            }
        }
        return this.functionArgValueCategories;
    }

    public int getFunctionArgumentCount() {
        if (this.functionArgs != null) {
            return this.functionArgs.length;
        }
        return 0;
    }

    public int getFunctionArgumentPackExpansionCount() {
        int count = 0;
        if (this.functionArgs != null) {
            IASTInitializerClause[] iASTInitializerClauseArray = this.functionArgs;
            int n = this.functionArgs.length;
            int n2 = 0;
            while (n2 < n) {
                IASTInitializerClause arg = iASTInitializerClauseArray[n2];
                if (arg instanceof ICPPASTPackExpansionExpression) {
                    ++count;
                }
                ++n2;
            }
        }
        return count;
    }

    public boolean hasFunctionArguments() {
        return this.functionArgs != null;
    }

    public IBinding[] getFoundBindings() {
        Object[] items;
        if (this.foundItems instanceof Object[] && (items = (Object[])this.foundItems).length != 0) {
            IBinding[] bindings = new IBinding[items.length];
            int k = 0;
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof IBinding && !(item instanceof ICPPUsingDeclaration) && !(item instanceof CPPCompositeBinding)) {
                    bindings[k++] = (IBinding)item;
                }
                ++n2;
            }
            if (k != 0) {
                return ArrayUtil.trimAt(IBinding.class, bindings, k - 1);
            }
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }
}

