/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.changegenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ToolFactory;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModification;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationMap;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationStore;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTRewriteAnalyzer;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ContainerNode;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ProblemRuntimeException;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ChangeGeneratorMessages;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ChangeGeneratorWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.TextEditUtil;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ChangeGenerator
extends ASTVisitor {
    private final Map<IASTNode, Map<ASTModification.ModificationKind, List<ASTModification>>> classifiedModifications = new HashMap<IASTNode, Map<ASTModification.ModificationKind, List<ASTModification>>>();
    private int processedOffset;
    private MultiTextEdit rootEdit;
    private CompositeChange change;
    private final ASTModificationStore modificationStore;
    private final NodeCommentMap commentMap;

    public ChangeGenerator(ASTModificationStore modificationStore, NodeCommentMap commentMap) {
        this.shouldVisitArrayModifiers = true;
        this.shouldVisitBaseSpecifiers = true;
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitDeclarators = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitNamespaces = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitPointerOperators = true;
        this.shouldVisitStatements = true;
        this.shouldVisitTemplateParameters = true;
        this.shouldVisitTranslationUnit = true;
        this.shouldVisitTypeIds = true;
        this.modificationStore = modificationStore;
        this.commentMap = commentMap;
    }

    public void generateChange(IASTNode rootNode) throws ProblemRuntimeException {
        this.generateChange(rootNode, this);
    }

    private void generateChange(IASTNode rootNode, ASTVisitor pathProvider) throws ProblemRuntimeException {
        this.change = new CompositeChange(ChangeGeneratorMessages.ChangeGenerator_compositeChange);
        this.classifyModifications();
        rootNode.accept(pathProvider);
        if (this.rootEdit == null) {
            return;
        }
        IASTTranslationUnit ast = rootNode.getTranslationUnit();
        String source = ast.getRawSignature();
        ITranslationUnit tu = ast.getOriginatingTranslationUnit();
        this.formatChangedCode(source, tu);
        TextFileChange subchange = ASTRewriteAnalyzer.createCTextFileChange((IFile)tu.getResource());
        subchange.setEdit((TextEdit)this.rootEdit);
        this.change.add((Change)subchange);
    }

    private void classifyModifications() {
        ASTModificationMap rootModifications = this.modificationStore.getRootModifications();
        if (rootModifications == null) {
            return;
        }
        for (IASTNode node : rootModifications.getModifiedNodes()) {
            List<ASTModification> modifications = rootModifications.getModificationsForNode(node);
            for (ASTModification modification : modifications) {
                ASTModification.ModificationKind kind;
                List<ASTModification> list;
                Map<ASTModification.ModificationKind, List<ASTModification>> map = this.classifiedModifications.get(node);
                if (map == null) {
                    map = new TreeMap<ASTModification.ModificationKind, List<ASTModification>>();
                    this.classifiedModifications.put(node, map);
                }
                if ((list = map.get((Object)(kind = modification.getKind()))) == null) {
                    list = new ArrayList<ASTModification>(2);
                    map.put(kind, list);
                }
                list.add(modification);
            }
        }
    }

    @Override
    public int visit(IASTTranslationUnit tu) {
        IASTFileLocation location = tu.getFileLocation();
        this.processedOffset = location.getNodeOffset();
        return super.visit(tu);
    }

    @Override
    public int leave(IASTTranslationUnit tu) {
        this.handleAppends(tu);
        return super.leave(tu);
    }

    @Override
    public int visit(IASTDeclaration declaration) {
        this.handleInserts(declaration);
        if (this.requiresRewrite(declaration)) {
            this.handleReplace(declaration);
            return 1;
        }
        return super.visit(declaration);
    }

    @Override
    public int visit(IASTDeclarator declarator) {
        this.handleInserts(declarator);
        if (this.requiresRewrite(declarator)) {
            this.handleReplace(declarator);
            return 1;
        }
        return super.visit(declarator);
    }

    @Override
    public int visit(IASTArrayModifier arrayModifier) {
        this.handleInserts(arrayModifier);
        if (this.requiresRewrite(arrayModifier)) {
            this.handleReplace(arrayModifier);
            return 1;
        }
        return super.visit(arrayModifier);
    }

    @Override
    public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
        this.handleInserts(namespaceDefinition);
        if (this.requiresRewrite(namespaceDefinition)) {
            this.handleReplace(namespaceDefinition);
            return 1;
        }
        return super.visit(namespaceDefinition);
    }

    @Override
    public int leave(ICPPASTNamespaceDefinition namespaceDefinition) {
        if (!this.requiresRewrite(namespaceDefinition)) {
            this.handleAppends(namespaceDefinition);
        }
        return super.leave(namespaceDefinition);
    }

    @Override
    public int visit(IASTDeclSpecifier declSpec) {
        this.handleInserts(declSpec);
        if (this.requiresRewrite(declSpec)) {
            this.handleReplace(declSpec);
            return 1;
        }
        return super.visit(declSpec);
    }

    @Override
    public int leave(IASTDeclSpecifier declSpec) {
        if (!this.requiresRewrite(declSpec)) {
            this.handleAppends(declSpec);
        }
        return super.leave(declSpec);
    }

    @Override
    public int visit(IASTExpression expression) {
        this.handleInserts(expression);
        if (this.requiresRewrite(expression)) {
            this.handleReplace(expression);
            return 1;
        }
        return super.visit(expression);
    }

    @Override
    public int visit(IASTInitializer initializer) {
        this.handleInserts(initializer);
        if (this.requiresRewrite(initializer)) {
            this.handleReplace(initializer);
            return 1;
        }
        return super.visit(initializer);
    }

    @Override
    public int visit(IASTName name) {
        this.handleInserts(name);
        if (this.requiresRewrite(name)) {
            this.handleReplace(name);
            return 1;
        }
        return super.visit(name);
    }

    @Override
    public int visit(IASTParameterDeclaration parameterDeclaration) {
        this.handleInserts(parameterDeclaration);
        if (this.requiresRewrite(parameterDeclaration)) {
            this.handleReplace(parameterDeclaration);
            return 1;
        }
        return super.visit(parameterDeclaration);
    }

    @Override
    public int visit(IASTPointerOperator pointerOperator) {
        this.handleInserts(pointerOperator);
        if (this.requiresRewrite(pointerOperator)) {
            this.handleReplace(pointerOperator);
            return 1;
        }
        return super.visit(pointerOperator);
    }

    @Override
    public int visit(IASTTypeId typeId) {
        this.handleInserts(typeId);
        if (this.requiresRewrite(typeId)) {
            this.handleReplace(typeId);
            return 1;
        }
        return super.visit(typeId);
    }

    @Override
    public int visit(IASTStatement statement) {
        this.handleInserts(statement);
        if (this.requiresRewrite(statement)) {
            this.handleReplace(statement);
            return 1;
        }
        return super.visit(statement);
    }

    @Override
    public int leave(IASTStatement statement) {
        if (!this.requiresRewrite(statement)) {
            this.handleAppends(statement);
        }
        return super.leave(statement);
    }

    private void addChildEdit(TextEdit edit) {
        this.rootEdit.addChild(edit);
        this.processedOffset = edit.getExclusiveEnd();
    }

    private TextEdit clippedEdit(TextEdit edit, IRegion region) {
        if (edit.getOffset() < region.getOffset() && edit.getExclusiveEnd() <= region.getOffset() || edit.getOffset() >= this.endOffset(region)) {
            return null;
        }
        int offset = Math.max(edit.getOffset(), region.getOffset());
        int length = Math.min(this.endOffset(edit), this.endOffset(region)) - offset;
        if (offset == edit.getOffset() && length == edit.getLength()) {
            return edit;
        }
        if (edit instanceof DeleteEdit) {
            return new DeleteEdit(offset, length);
        }
        if (edit instanceof ReplaceEdit) {
            String replacement = ((ReplaceEdit)edit).getText();
            int start = Math.max(offset - edit.getOffset(), 0);
            int end = Math.min(this.endOffset(region) - offset, replacement.length());
            if (end <= start) {
                return new DeleteEdit(offset, length);
            }
            return new ReplaceEdit(offset, length, replacement.substring(start, end));
        }
        throw new IllegalArgumentException("Unexpected edit type: " + edit.getClass().getSimpleName());
    }

    private void formatChangedCode(String code, ITranslationUnit tu) {
        Document document = new Document(code);
        try {
            TextEdit edit = this.rootEdit.copy();
            edit.apply((IDocument)document, 2);
            TextEdit[] appliedEdits = edit.getChildren();
            TextEdit[] edits = this.rootEdit.removeChildren();
            IRegion[] regions = new IRegion[appliedEdits.length];
            int numRegions = 0;
            int prevEnd = -1;
            int i = 0;
            while (i < appliedEdits.length) {
                int newEnd;
                edit = appliedEdits[i];
                int offset = edit.getOffset();
                int end = offset + edit.getLength();
                int newOffset = document.getLineInformationOfOffset(offset).getOffset();
                edit = edits[i];
                int originalEnd = edit.getExclusiveEnd();
                int n = newEnd = (originalEnd == 0 || code.charAt(originalEnd - 1) == '\n') && end == newOffset ? end : this.endOffset(document.getLineInformationOfOffset(end));
                if (newOffset <= prevEnd) {
                    newOffset = regions[--numRegions].getOffset();
                }
                prevEnd = newEnd;
                regions[numRegions] = new Region(newOffset, newEnd - newOffset);
                ++numRegions;
                ++i;
            }
            if (numRegions < regions.length) {
                regions = Arrays.copyOf(regions, numRegions);
            }
            ICProject project = tu.getCProject();
            HashMap<String, String> options = new HashMap<String, String>(project.getOptions(true));
            options.put("org.eclipse.cdt.core.formatter.current_translation_unit", (String)((Object)tu));
            options.put("org.eclipse.cdt.core.formatter.comment.never_indent_line_comments_on_first_column", "false");
            CodeFormatter formatter = ToolFactory.createCodeFormatter(options);
            code = document.get();
            TextEdit[] formatEdits = formatter.format(8, code, regions, TextUtilities.getDefaultLineDelimiter((IDocument)document));
            MultiTextEdit combinedFormatEdit = new MultiTextEdit();
            TextEdit[] textEditArray = formatEdits;
            int n = formatEdits.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit formatEdit = textEditArray[n2];
                combinedFormatEdit = TextEditUtil.merge((TextEdit)combinedFormatEdit, formatEdit);
                ++n2;
            }
            formatEdits = TextEditUtil.flatten((TextEdit)combinedFormatEdit).removeChildren();
            MultiTextEdit result = new MultiTextEdit();
            int delta = 0;
            TextEdit edit1 = null;
            TextEdit edit2 = null;
            int i2 = 0;
            int j = 0;
            while (true) {
                if (edit1 == null && i2 < edits.length) {
                    edit1 = edits[i2++];
                }
                if (edit2 == null && j < formatEdits.length) {
                    edit2 = formatEdits[j++];
                }
                if (edit1 == null) {
                    if (edit2 == null) break;
                    edit2.moveTree(-delta);
                    result.addChild(edit2);
                    edit2 = null;
                    continue;
                }
                if (edit2 == null) {
                    delta += TextEditUtil.delta(edit1);
                    result.addChild(edit1);
                    edit1 = null;
                    continue;
                }
                if (edit2.getExclusiveEnd() - delta <= edit1.getOffset()) {
                    edit2.moveTree(-delta);
                    result.addChild(edit2);
                    edit2 = null;
                    continue;
                }
                TextEdit piece = this.clippedEdit(edit2, (IRegion)new Region(-1, edit1.getOffset() + delta));
                if (piece != null) {
                    piece.moveTree(-delta);
                    result.addChild(piece);
                }
                int d = TextEditUtil.delta(edit1);
                Region region = new Region(edit1.getOffset() + delta, edit1.getLength() + d);
                int end = this.endOffset((IRegion)region);
                MultiTextEdit format = new MultiTextEdit();
                while ((piece = this.clippedEdit(edit2, (IRegion)region)) != null) {
                    format.addChild(piece);
                    if (edit2 != null && (edit2.getExclusiveEnd() >= end || j >= formatEdits.length)) break;
                    edit2 = formatEdits[j++];
                }
                if (format.hasChildren()) {
                    format.moveTree(-delta);
                    edit1 = this.applyEdit((TextEdit)format, edit1);
                }
                delta += d;
                result.addChild(edit1);
                edit1 = null;
                edit2 = this.clippedEdit(edit2, (IRegion)new Region(end, Integer.MAX_VALUE - end));
            }
            this.rootEdit = result;
        }
        catch (MalformedTreeException e) {
            CCorePlugin.log(e);
        }
        catch (BadLocationException e) {
            CCorePlugin.log(e);
        }
    }

    private TextEdit applyEdit(TextEdit source, TextEdit target) throws MalformedTreeException, BadLocationException {
        source.moveTree(-target.getOffset());
        String text = target instanceof InsertEdit ? ((InsertEdit)target).getText() : (target instanceof ReplaceEdit ? ((ReplaceEdit)target).getText() : "");
        Document document = new Document(text);
        source.apply((IDocument)document, 0);
        text = document.get();
        if (target.getLength() == 0) {
            return new InsertEdit(target.getOffset(), text);
        }
        return new ReplaceEdit(target.getOffset(), target.getLength(), text);
    }

    private int endOffset(IRegion region) {
        return region.getOffset() + region.getLength();
    }

    private int endOffset(TextEdit edit) {
        return edit.getOffset() + edit.getLength();
    }

    private int endOffset(IASTFileLocation nodeLocation) {
        return nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
    }

    private int endOffset(IASTNode node) {
        return this.endOffset(node.getFileLocation());
    }

    private int offset(IASTNode node) {
        return node.getFileLocation().getNodeOffset();
    }

    private void handleInserts(IASTNode anchorNode) {
        List<ASTModification> modifications = this.getModifications(anchorNode, ASTModification.ModificationKind.INSERT_BEFORE);
        if (modifications.isEmpty()) {
            return;
        }
        ChangeGeneratorWriterVisitor writer = new ChangeGeneratorWriterVisitor(this.modificationStore, this.commentMap);
        IASTNode newNode = null;
        for (ASTModification modification : modifications) {
            boolean first = newNode == null;
            newNode = modification.getNewNode();
            if (first) {
                IASTNode prevNode = this.getPreviousSiblingOrPreprocessorNode(anchorNode);
                if (prevNode != null) {
                    if (ASTWriter.requireBlankLineInBetween(prevNode, newNode)) {
                        writer.newLine();
                    }
                } else if (anchorNode.getParent() instanceof ICPPASTNamespaceDefinition) {
                    writer.newLine();
                }
            }
            newNode.accept(writer);
            if (this.getContainingNodeList(anchorNode) == null) continue;
            writer.getScribe().print(", ");
        }
        if (ASTWriter.requireBlankLineInBetween(newNode, anchorNode)) {
            writer.newLine();
        }
        int insertPos = this.getOffsetIncludingComments(anchorNode);
        int length = 0;
        if (writer.getScribe().isAtBeginningOfLine()) {
            String tuCode = anchorNode.getTranslationUnit().getRawSignature();
            length = insertPos = this.skipPrecedingWhitespace(tuCode, insertPos);
            insertPos = this.skipPrecedingBlankLines(tuCode, insertPos);
            length -= insertPos;
        }
        this.addToRootEdit(anchorNode);
        String code = writer.toString();
        if (!code.isEmpty()) {
            this.addChildEdit((TextEdit)new InsertEdit(insertPos, code));
        }
        if (length != 0) {
            this.addChildEdit((TextEdit)new DeleteEdit(insertPos, length));
        }
    }

    private void handleReplace(IASTNode node) {
        List<ASTModification> modifications = this.getModifications(node, ASTModification.ModificationKind.REPLACE);
        String source = node.getTranslationUnit().getRawSignature();
        ChangeGeneratorWriterVisitor writer = new ChangeGeneratorWriterVisitor(this.modificationStore, this.commentMap);
        IASTFileLocation fileLocation = node.getFileLocation();
        this.addToRootEdit(node);
        if (modifications.size() == 1 && modifications.get(0).getNewNode() == null) {
            int offset = this.getOffsetIncludingComments(node);
            int endOffset = this.getEndOffsetIncludingComments(node);
            offset = Math.max(this.skipPrecedingBlankLines(source, offset), this.processedOffset);
            endOffset = this.skipTrailingBlankLines(source, endOffset);
            IASTNode[] siblingsList = this.getContainingNodeList(node);
            if (siblingsList != null) {
                if (siblingsList.length > 1) {
                    if (node == siblingsList[0]) {
                        endOffset = this.skipToTrailingDelimiter(source, ',', endOffset);
                    } else {
                        offset = this.skipToPrecedingDelimiter(source, ',', offset);
                    }
                } else if (node.getPropertyInParent() == ICPPASTFunctionDefinition.MEMBER_INITIALIZER) {
                    offset = this.skipToPrecedingDelimiter(source, ':', offset);
                }
            }
            IASTNode prevNode = this.getPreviousSiblingOrPreprocessorNode(node);
            IASTNode nextNode = this.getNextSiblingOrPreprocessorNode(node);
            if (prevNode != null && nextNode != null) {
                if (ASTWriter.requireBlankLineInBetween(prevNode, nextNode)) {
                    writer.newLine();
                }
            } else if (node.getParent() instanceof ICPPASTNamespaceDefinition) {
                writer.newLine();
            }
            String code = writer.toString();
            if (endOffset > offset) {
                this.addChildEdit((TextEdit)new DeleteEdit(offset, endOffset - offset));
            }
            if (!code.isEmpty()) {
                this.addChildEdit((TextEdit)new InsertEdit(endOffset, code));
            }
        } else {
            int commentEnd;
            node.accept(writer);
            String code = writer.toString();
            int offset = fileLocation.getNodeOffset();
            int endOffset = offset + fileLocation.getNodeLength();
            String lineSeparator = writer.getScribe().getLineSeparator();
            if (code.endsWith(lineSeparator)) {
                code = code.substring(0, code.length() - lineSeparator.length());
            }
            this.addChildEdit((TextEdit)new ReplaceEdit(offset, endOffset - offset, code));
            if ((node instanceof IASTStatement || node instanceof IASTDeclaration) && (commentEnd = this.getEndOffsetIncludingTrailingComments(node)) > endOffset) {
                this.addChildEdit((TextEdit)new DeleteEdit(endOffset, commentEnd - endOffset));
            }
        }
    }

    private void handleAppends(IASTNode node) {
        List<ASTModification> modifications = this.getModifications(node, ASTModification.ModificationKind.APPEND_CHILD);
        if (modifications.isEmpty()) {
            return;
        }
        ChangeGeneratorWriterVisitor writer = new ChangeGeneratorWriterVisitor(this.modificationStore, this.commentMap);
        ReplaceEdit anchor = this.getAppendAnchor(node);
        Assert.isNotNull((Object)anchor);
        IASTNode precedingNode = this.getLastNodeBeforeAppendPoint(node);
        for (ASTModification modification : modifications) {
            IASTNode newNode = modification.getNewNode();
            if (precedingNode != null) {
                if (ASTWriter.requireBlankLineInBetween(precedingNode, newNode)) {
                    writer.newLine();
                }
            } else if (node instanceof ICPPASTNamespaceDefinition) {
                writer.newLine();
            }
            precedingNode = null;
            newNode.accept(writer);
        }
        if (node instanceof ICPPASTNamespaceDefinition) {
            writer.newLine();
        }
        this.addToRootEdit(node);
        String code = writer.toString();
        if (!code.isEmpty()) {
            this.addChildEdit((TextEdit)new InsertEdit(anchor.getOffset(), code));
        }
        this.addChildEdit((TextEdit)new ReplaceEdit(anchor.getOffset(), anchor.getLength(), anchor.getText()));
        this.processedOffset = this.endOffset(node);
    }

    private void handleAppends(IASTTranslationUnit node) {
        String code;
        IASTNode nextNode;
        List<ASTModification> modifications = this.getModifications(node, ASTModification.ModificationKind.APPEND_CHILD);
        if (modifications.isEmpty()) {
            return;
        }
        IASTNode prevNode = null;
        IASTDeclaration[] declarations = node.getDeclarations();
        if (declarations.length != 0) {
            prevNode = declarations[declarations.length - 1];
        } else {
            IASTPreprocessorStatement[] preprocessorStatements = node.getAllPreprocessorStatements();
            if (preprocessorStatements.length != 0) {
                prevNode = preprocessorStatements[preprocessorStatements.length - 1];
            }
        }
        int offset = prevNode != null ? this.getEndOffsetIncludingComments(prevNode) : 0;
        String source = node.getRawSignature();
        int endOffset = this.skipTrailingBlankLines(source, offset);
        this.addToRootEdit(node);
        ChangeGeneratorWriterVisitor writer = new ChangeGeneratorWriterVisitor(this.modificationStore, this.commentMap);
        IASTNode newNode = null;
        for (ASTModification modification : modifications) {
            boolean first = newNode == null;
            newNode = modification.getNewNode();
            if (first && prevNode != null) {
                writer.newLine();
                if (ASTWriter.requireBlankLineInBetween(prevNode, newNode)) {
                    writer.newLine();
                }
            }
            newNode.accept(writer);
            if (writer.toString().endsWith("\n")) continue;
            writer.newLine();
        }
        if (prevNode != null && (nextNode = this.getNextSiblingOrPreprocessorNode(prevNode)) != null && ASTWriter.requireBlankLineInBetween(newNode, nextNode)) {
            writer.newLine();
        }
        if (!(code = writer.toString()).isEmpty()) {
            this.addChildEdit((TextEdit)new InsertEdit(offset, code));
        }
        if (endOffset > offset) {
            this.addChildEdit((TextEdit)new DeleteEdit(offset, endOffset - offset));
        }
    }

    private IASTNode[] getContainingNodeList(IASTNode node) {
        if (node.getPropertyInParent() == IASTStandardFunctionDeclarator.FUNCTION_PARAMETER) {
            return ((IASTStandardFunctionDeclarator)node.getParent()).getParameters();
        }
        if (node.getPropertyInParent() == IASTExpressionList.NESTED_EXPRESSION) {
            return ((IASTExpressionList)node.getParent()).getExpressions();
        }
        if (node.getPropertyInParent() == ICPPASTFunctionDefinition.MEMBER_INITIALIZER) {
            return ((ICPPASTFunctionDefinition)node.getParent()).getMemberInitializers();
        }
        if (node.getPropertyInParent() == ICPPASTFunctionDeclarator.EXCEPTION_TYPEID) {
            return ((ICPPASTFunctionDeclarator)node.getParent()).getExceptionSpecification();
        }
        return null;
    }

    private IASTNode getLastNodeBeforeAppendPoint(IASTNode node) {
        IASTNode[] children = node instanceof ICPPASTNamespaceDefinition ? ((ICPPASTNamespaceDefinition)node).getDeclarations(true) : (node instanceof IASTCompositeTypeSpecifier ? ((IASTCompositeTypeSpecifier)node).getDeclarations(true) : node.getChildren());
        int i = children.length;
        while (--i >= 0) {
            IASTNode child = this.getReplacementNode(children[i]);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private IASTNode getReplacementNode(IASTNode node) {
        List<ASTModification> modifications = this.getModifications(node, ASTModification.ModificationKind.REPLACE);
        if (!modifications.isEmpty()) {
            node = modifications.get(modifications.size() - 1).getNewNode();
        }
        return node;
    }

    private IASTNode getPreviousSiblingNode(IASTNode node) {
        IASTNode parent = node.getParent();
        IASTNode[] siblings = parent instanceof ICPPASTNamespaceDefinition ? ((ICPPASTNamespaceDefinition)parent).getDeclarations(true) : (parent instanceof IASTCompositeTypeSpecifier ? ((IASTCompositeTypeSpecifier)parent).getDeclarations(true) : parent.getChildren());
        boolean beforeNode = false;
        int i = siblings.length;
        while (--i >= 0) {
            IASTNode sibling = siblings[i];
            if (sibling == node) {
                beforeNode = true;
                continue;
            }
            if (!beforeNode || (sibling = this.getReplacementNode(sibling)) == null) continue;
            return sibling;
        }
        return null;
    }

    private IASTNode getPreviousSiblingOrPreprocessorNode(IASTNode node) {
        int endOffset;
        IASTPreprocessorStatement statement;
        int offset = this.offset(node);
        IASTTranslationUnit ast = node.getTranslationUnit();
        IASTPreprocessorStatement[] preprocessorStatements = ast.getAllPreprocessorStatements();
        int low = 0;
        int high = preprocessorStatements.length;
        while (low < high) {
            int mid = (low + high) / 2;
            IASTPreprocessorStatement statement2 = preprocessorStatements[mid];
            if (statement2.isPartOfTranslationUnitFile() && this.endOffset(statement2) > offset) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        if (--low >= 0 && (statement = preprocessorStatements[low]).isPartOfTranslationUnitFile() && !this.doesRegionContainNode(ast, endOffset = this.endOffset(statement), offset - endOffset)) {
            return statement;
        }
        return this.getPreviousSiblingNode(node);
    }

    private IASTNode getNextSiblingNode(IASTNode node) {
        IASTNode parent = node.getParent();
        IASTNode[] siblings = parent instanceof ICPPASTNamespaceDefinition ? ((ICPPASTNamespaceDefinition)parent).getDeclarations(true) : (parent instanceof IASTCompositeTypeSpecifier ? ((IASTCompositeTypeSpecifier)parent).getDeclarations(true) : parent.getChildren());
        boolean beforeNode = false;
        IASTNode[] iASTNodeArray = siblings;
        int n = siblings.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode sibling = iASTNodeArray[n2];
            if (sibling == node) {
                beforeNode = true;
            } else if (beforeNode && (sibling = this.getReplacementNode(sibling)) != null) {
                return sibling;
            }
            ++n2;
        }
        return null;
    }

    private IASTNode getNextSiblingOrPreprocessorNode(IASTNode node) {
        int offset;
        IASTPreprocessorStatement statement;
        int endOffset = this.endOffset(node);
        IASTTranslationUnit ast = node.getTranslationUnit();
        IASTPreprocessorStatement[] preprocessorStatements = ast.getAllPreprocessorStatements();
        int low = 0;
        int high = preprocessorStatements.length;
        while (low < high) {
            int mid = (low + high) / 2;
            IASTPreprocessorStatement statement2 = preprocessorStatements[mid];
            if (statement2.isPartOfTranslationUnitFile() && this.offset(statement2) > endOffset) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        if (high < preprocessorStatements.length && (statement = preprocessorStatements[high]).isPartOfTranslationUnitFile() && !this.doesRegionContainNode(ast, endOffset, (offset = this.offset(statement)) - endOffset)) {
            return statement;
        }
        return this.getNextSiblingNode(node);
    }

    private boolean doesRegionContainNode(IASTTranslationUnit ast, int offset, int length) {
        IASTNodeSelector nodeSelector = ast.getNodeSelector(ast.getFilePath());
        while (length > 0) {
            IASTNode node = nodeSelector.findFirstContainedNode(offset, length - 1);
            if (node == null) {
                return false;
            }
            if (!this.isNodeRemoved(node)) {
                return true;
            }
            int oldOffset = offset;
            offset = this.endOffset(node);
            length -= offset - oldOffset;
        }
        return false;
    }

    private boolean isNodeRemoved(IASTNode node) {
        do {
            if (this.getReplacementNode(node) != null) continue;
            return true;
        } while ((node = node.getParent()) != null);
        return false;
    }

    private ReplaceEdit getAppendAnchor(IASTNode node) {
        if (!(node instanceof IASTCompositeTypeSpecifier || node instanceof IASTCompoundStatement || node instanceof ICPPASTNamespaceDefinition)) {
            return null;
        }
        String code = node.getRawSignature();
        IASTFileLocation location = node.getFileLocation();
        int pos = location.getNodeOffset() + location.getNodeLength();
        int len = code.endsWith("}") ? 1 : 0;
        int insertPos = code.length() - len;
        int startOfLine = this.skipPrecedingBlankLines(code, insertPos);
        if (startOfLine == insertPos) {
            return new ReplaceEdit(pos - len, len, code.substring(insertPos));
        }
        return new ReplaceEdit(location.getNodeOffset() + startOfLine, insertPos - startOfLine, "");
    }

    private int skipPrecedingWhitespace(String text, int startPos) {
        int pos = startPos;
        while (--pos >= 0) {
            char c = text.charAt(pos);
            if (c == '\n') {
                return pos + 1;
            }
            if (Character.isWhitespace(c)) continue;
            return startPos;
        }
        return 0;
    }

    private int skipPrecedingBlankLines(String text, int startPos) {
        int pos = startPos;
        while (--pos >= 0) {
            char c = text.charAt(pos);
            if (c == '\n') {
                startPos = pos + 1;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            return startPos;
        }
        return 0;
    }

    private int skipTrailingBlankLines(String text, int startPos) {
        int pos = startPos;
        while (pos < text.length()) {
            char c = text.charAt(pos);
            if (c == '\n') {
                startPos = pos + 1;
            } else if (!Character.isWhitespace(c)) {
                return startPos;
            }
            ++pos;
        }
        return text.length();
    }

    private int skipToPrecedingDelimiter(String text, char delimiter, int startPos) {
        int pos = startPos;
        while (--pos >= 0) {
            char c = text.charAt(pos);
            if (c == delimiter) {
                return pos;
            }
            if (Character.isWhitespace(c)) continue;
            return startPos;
        }
        return startPos;
    }

    private int skipToTrailingDelimiter(String text, char delimiter, int startPos) {
        int pos = startPos;
        while (pos < text.length()) {
            char c = text.charAt(pos);
            if (c == delimiter) {
                return pos + 1;
            }
            if (!Character.isWhitespace(c)) {
                return startPos;
            }
            ++pos;
        }
        return startPos;
    }

    private void addToRootEdit(IASTNode modifiedNode) {
        if (this.rootEdit == null) {
            this.rootEdit = new MultiTextEdit();
        }
        TextEditGroup editGroup = new TextEditGroup(ChangeGeneratorMessages.ChangeGenerator_group);
        for (List<ASTModification> modifications : this.getModifications(modifiedNode).values()) {
            for (ASTModification modification : modifications) {
                if (modification.getAssociatedEditGroup() == null) continue;
                editGroup = modification.getAssociatedEditGroup();
                this.rootEdit.addChildren(editGroup.getTextEdits());
                return;
            }
        }
    }

    private int getOffsetIncludingComments(IASTNode node) {
        int nodeOffset = this.offset(node);
        List<IASTComment> comments = this.commentMap.getAllCommentsForNode(node);
        if (!comments.isEmpty()) {
            int startOffset = nodeOffset;
            for (IASTComment comment : comments) {
                int commentOffset = this.offset(comment);
                if (commentOffset >= startOffset) continue;
                startOffset = commentOffset;
            }
            nodeOffset = startOffset;
        }
        return nodeOffset;
    }

    private int getEndOffsetIncludingComments(IASTNode node) {
        int endOffset = 0;
        while (true) {
            IASTNode[] children;
            List<IASTComment> comments;
            IASTFileLocation fileLocation;
            if ((fileLocation = node.getFileLocation()) != null) {
                endOffset = Math.max(endOffset, this.endOffset(fileLocation));
            }
            if (!(comments = this.commentMap.getAllCommentsForNode(node)).isEmpty()) {
                for (IASTComment comment : comments) {
                    int commentEndOffset = this.endOffset(comment);
                    if (commentEndOffset < endOffset) continue;
                    endOffset = commentEndOffset;
                }
            }
            if ((children = node.getChildren()).length == 0) break;
            node = children[children.length - 1];
        }
        return endOffset;
    }

    private int getEndOffsetIncludingTrailingComments(IASTNode node) {
        int endOffset = 0;
        while (true) {
            IASTNode[] children;
            List<IASTComment> comments;
            IASTFileLocation fileLocation;
            if ((fileLocation = node.getFileLocation()) != null) {
                endOffset = Math.max(endOffset, this.endOffset(fileLocation));
            }
            if (!(comments = this.commentMap.getTrailingCommentsForNode(node)).isEmpty()) {
                for (IASTComment comment : comments) {
                    int commentEndOffset = this.endOffset(comment);
                    if (commentEndOffset < endOffset) continue;
                    endOffset = commentEndOffset;
                }
            }
            if ((children = node.getChildren()).length == 0) break;
            node = children[children.length - 1];
        }
        return endOffset;
    }

    private Map<ASTModification.ModificationKind, List<ASTModification>> getModifications(IASTNode node) {
        Map<ASTModification.ModificationKind, List<ASTModification>> modifications = this.classifiedModifications.get(node);
        if (modifications == null) {
            return Collections.emptyMap();
        }
        return modifications;
    }

    private List<ASTModification> getModifications(IASTNode node, ASTModification.ModificationKind kind) {
        Map<ASTModification.ModificationKind, List<ASTModification>> allModifications = this.getModifications(node);
        List<ASTModification> modifications = allModifications.get((Object)kind);
        if (modifications == null) {
            return Collections.emptyList();
        }
        return modifications;
    }

    private boolean requiresRewrite(IASTNode node) {
        if (!this.getModifications(node, ASTModification.ModificationKind.REPLACE).isEmpty()) {
            return true;
        }
        for (ASTModification modification : this.getModifications(node, ASTModification.ModificationKind.APPEND_CHILD)) {
            if (this.isAppendable(modification)) continue;
            return true;
        }
        return false;
    }

    private boolean isAppendable(ASTModification modification) {
        if (modification.getKind() != ASTModification.ModificationKind.APPEND_CHILD) {
            return false;
        }
        IASTNode node = modification.getNewNode();
        if (node instanceof ContainerNode) {
            for (IASTNode containedNode : ((ContainerNode)node).getNodes()) {
                if (containedNode instanceof IASTDeclaration || containedNode instanceof IASTStatement) continue;
                return false;
            }
            return true;
        }
        return node instanceof IASTDeclaration || node instanceof IASTStatement;
    }

    public Change getChange() {
        return this.change;
    }
}

