/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeSearchPathElement;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerUtility;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMIndexerTask;
import org.eclipse.cdt.internal.core.pdom.indexer.ProjectIndexerIncludeResolutionHeuristics;
import org.eclipse.cdt.internal.core.pdom.indexer.ProjectIndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.indexer.TranslationUnitCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class PDOMUpdateTask
implements IPDOMIndexerTask {
    private static final ITranslationUnit[] NO_TUS = new ITranslationUnit[0];
    private final IPDOMIndexer fIndexer;
    private final int fUpdateOptions;
    private final IndexerProgress fProgress;
    private volatile IPDOMIndexerTask fDelegate;
    private ArrayList<ICElement> fFilesAndFolders;

    public PDOMUpdateTask(IPDOMIndexer indexer, int updateOptions) {
        this.fIndexer = indexer;
        this.fUpdateOptions = updateOptions;
        this.fProgress = this.createProgress();
    }

    private IndexerProgress createProgress() {
        IndexerProgress progress = new IndexerProgress();
        progress.fTimeEstimate = 1000;
        return progress;
    }

    @Override
    public IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InterruptedException {
        monitor.subTask(NLS.bind((String)Messages.PDOMIndexerTask_collectingFilesTask, (Object)this.fIndexer.getProject().getElementName()));
        ICProject project = this.fIndexer.getProject();
        if (project.getProject().isOpen()) {
            try {
                if (!"org.eclipse.cdt.core.nullindexer".equals(this.fIndexer.getID())) {
                    this.createDelegate(project, monitor);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        if (this.fDelegate != null) {
            this.fDelegate.run(monitor);
        }
    }

    private void createDelegate(ICProject project, IProgressMonitor monitor) throws CoreException, InterruptedException {
        ITranslationUnit[] tus;
        IPDOMIndexerTask delegate;
        HashSet<ITranslationUnit> set = new HashSet<ITranslationUnit>();
        if ((this.fUpdateOptions & 3) != 0) {
            TranslationUnitCollector collector = new TranslationUnitCollector(set, set, monitor);
            boolean haveProject = false;
            if (this.fFilesAndFolders == null) {
                project.accept(collector);
            } else {
                for (ICElement elem : this.fFilesAndFolders) {
                    if (elem.getElementType() == 11) {
                        haveProject = true;
                    }
                    elem.accept(collector);
                }
            }
            if (haveProject && (this.fUpdateOptions & 8) != 0) {
                String projectPrefix = String.valueOf(project.getProject().getFullPath().toString()) + '/';
                IIndex index2 = CCorePlugin.getIndexManager().getIndex(project);
                index2.acquireReadLock();
                try {
                    IIndexFile[] files2;
                    IIndexFile[] iIndexFileArray = files2 = index2.getAllFiles();
                    int n = files2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITranslationUnit tu;
                        IIndexFile indexFile = iIndexFileArray[n2];
                        IIndexFileLocation floc = indexFile.getLocation();
                        String fullPath = floc.getFullPath();
                        if (!(fullPath != null && fullPath.startsWith(projectPrefix) || (tu = this.getTranslationUnit(floc, project)) == null)) {
                            set.add(tu);
                        }
                        ++n2;
                    }
                }
                finally {
                    index2.releaseReadLock();
                }
            }
        }
        if ((this.fUpdateOptions & 0x80) != 0) {
            IIndex index = CCorePlugin.getIndexManager().getIndex(project);
            index.acquireReadLock();
            try {
                IIndexFile[] files;
                IIndexFile[] iIndexFileArray = files = index.getDefectiveFiles();
                int files2 = files.length;
                int index2 = 0;
                while (index2 < files2) {
                    IIndexFile file = iIndexFileArray[index2];
                    ITranslationUnit tu = this.getTranslationUnit(file.getLocation(), project);
                    if (tu != null) {
                        set.add(tu);
                    }
                    ++index2;
                }
                files = index.getFilesWithUnresolvedIncludes();
                if (files.length > 0) {
                    ProjectIndexerInputAdapter inputAdapter = new ProjectIndexerInputAdapter(project, true);
                    ProjectIndexerIncludeResolutionHeuristics includeResolutionHeuristics = new ProjectIndexerIncludeResolutionHeuristics(project.getProject(), inputAdapter);
                    IIndexFile[] iIndexFileArray2 = files;
                    int n = files.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IScannerInfo scannerInfo;
                        IIndexFile file = iIndexFileArray2[n3];
                        ITranslationUnit tu = this.getTranslationUnit(file.getLocation(), project);
                        if (tu != null && this.canResolveUnresolvedInclude(file, scannerInfo = tu.getScannerInfo(true), includeResolutionHeuristics)) {
                            set.add(tu);
                        }
                        ++n3;
                    }
                }
            }
            finally {
                index.releaseReadLock();
            }
        }
        if ((delegate = this.fIndexer.createTask(NO_TUS, tus = set.toArray(new ITranslationUnit[set.size()]), NO_TUS)) instanceof PDOMIndexerTask) {
            PDOMIndexerTask task = (PDOMIndexerTask)delegate;
            task.setUpdateFlags(this.fUpdateOptions);
        }
        this.setDelegate(delegate);
    }

    private ITranslationUnit getTranslationUnit(IIndexFileLocation location, ICProject project) {
        IResource file;
        String fullPath;
        IPath path = IndexLocationFactory.getAbsolutePath(location);
        if (path == null) {
            return null;
        }
        ITranslationUnit tu = CoreModel.getDefault().createTranslationUnitFrom(project, path);
        if (tu != null && (fullPath = location.getFullPath()) != null && tu instanceof ExternalTranslationUnit && (file = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath)) instanceof IFile) {
            ((ExternalTranslationUnit)tu).setResource((IFile)file);
        }
        return tu;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canResolveUnresolvedInclude(IIndexFile file, IScannerInfo scannerInfo, ProjectIndexerIncludeResolutionHeuristics includeResolutionHeuristics) {
        try {
            String filePath = IndexLocationFactory.getAbsolutePath(file.getLocation()).toOSString();
            long fileReadTime = file.getSourceReadTime();
            IncludeSearchPathElement[] includeSearchPath = CPreprocessor.configureIncludeSearchPath(new File(filePath).getParentFile(), scannerInfo);
            IIndexInclude[] iIndexIncludeArray = file.getIncludes();
            int n = iIndexIncludeArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IIndexInclude include = iIndexIncludeArray[n2];
                if (!include.isResolved() && include.isActive() && this.canResolveInclude(include, filePath, fileReadTime, includeSearchPath, includeResolutionHeuristics)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return false;
    }

    private boolean canResolveInclude(IIndexInclude include, String currentFile, long timestamp, IncludeSearchPathElement[] includeSearchPath, ProjectIndexerIncludeResolutionHeuristics includeResolutionHeuristics) throws CoreException {
        File currentDir;
        String includeName = include.getFullName();
        String filePath = CPreprocessor.getAbsoluteInclusionPath(includeName, currentFile);
        if (filePath != null && this.fileIsNotOlderThanTimestamp(filePath, timestamp)) {
            return true;
        }
        if (currentFile != null && !include.isSystemInclude() && (currentDir = new File(currentFile).getParentFile()) != null && !(filePath = ScannerUtility.createReconciledPath(currentDir.getAbsolutePath(), includeName)).equals(currentFile) && this.fileIsNotOlderThanTimestamp(filePath, timestamp)) {
            return true;
        }
        IncludeSearchPathElement[] includeSearchPathElementArray = includeSearchPath;
        int n = includeSearchPath.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeSearchPathElement path = includeSearchPathElementArray[n2];
            if (!(include.isSystemInclude() && path.isForQuoteIncludesOnly() || (filePath = path.getLocation(includeName)) == null || !this.fileIsNotOlderThanTimestamp(filePath, timestamp))) {
                return true;
            }
            ++n2;
        }
        return includeResolutionHeuristics != null && (filePath = includeResolutionHeuristics.findInclusion(includeName, currentFile)) != null && this.fileIsNotOlderThanTimestamp(filePath, timestamp);
    }

    private boolean fileIsNotOlderThanTimestamp(String filename, long timestamp) {
        return new File(filename).lastModified() >= timestamp - 1000L;
    }

    private synchronized void setDelegate(IPDOMIndexerTask delegate) {
        this.fDelegate = delegate;
    }

    @Override
    public synchronized IndexerProgress getProgressInformation() {
        return this.fDelegate != null ? this.fDelegate.getProgressInformation() : this.fProgress;
    }

    @Override
    public synchronized boolean acceptUrgentTask(IPDOMIndexerTask task) {
        return this.fDelegate != null && this.fDelegate.acceptUrgentTask(task);
    }

    public void setTranslationUnitSelection(List<? extends ICElement> filesAndFolders) {
        this.fFilesAndFolders = new ArrayList<ICElement>(filesAndFolders);
    }
}

