/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.language.settings.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.LocalProjectScope;
import org.eclipse.cdt.internal.core.language.settings.providers.LanguageSettingsExtensionManager;
import org.eclipse.cdt.internal.core.language.settings.providers.LanguageSettingsProvidersSerializer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ScannerDiscoveryLegacySupport {
    public static final String USER_LANGUAGE_SETTINGS_PROVIDER_ID = "org.eclipse.cdt.ui.UserLanguageSettingsProvider";
    public static final String MBS_LANGUAGE_SETTINGS_PROVIDER_ID = "org.eclipse.cdt.managedbuilder.core.MBSLanguageSettingsProvider";
    private static String DISABLE_LSP_PREFERENCE = "language.settings.providers.disabled";
    private static boolean DISABLE_LSP_DEFAULT_PROJECT = true;
    private static boolean DISABLE_LSP_DEFAULT_WORKSPACE = false;
    private static final String PREFERENCES_QUALIFIER_CCORE = "org.eclipse.cdt.core";
    private static Map<String, String> legacyProfiles = null;

    private static Preferences getPreferences(IProject project) {
        if (project == null) {
            return InstanceScope.INSTANCE.getNode(PREFERENCES_QUALIFIER_CCORE);
        }
        return new LocalProjectScope(project).getNode(PREFERENCES_QUALIFIER_CCORE);
    }

    public static boolean isLanguageSettingsProvidersFunctionalityEnabled(IProject project) {
        Preferences pref = ScannerDiscoveryLegacySupport.getPreferences(project);
        boolean defaultValue = project != null ? DISABLE_LSP_DEFAULT_PROJECT : DISABLE_LSP_DEFAULT_WORKSPACE;
        return !pref.getBoolean(DISABLE_LSP_PREFERENCE, defaultValue);
    }

    public static void setLanguageSettingsProvidersFunctionalityEnabled(IProject project, boolean value) {
        Preferences pref = ScannerDiscoveryLegacySupport.getPreferences(project);
        pref.putBoolean(DISABLE_LSP_PREFERENCE, !value);
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            CCorePlugin.log(e);
        }
    }

    public static boolean isMbsLanguageSettingsProviderOn(ICConfigurationDescription cfgDescription) {
        if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
            List<ILanguageSettingsProvider> lsProviders = ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).getLanguageSettingProviders();
            for (ILanguageSettingsProvider lsp : lsProviders) {
                if (!MBS_LANGUAGE_SETTINGS_PROVIDER_ID.equals(lsp.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLegacyScannerDiscoveryOn(ICConfigurationDescription cfgDescription) {
        ICProjectDescription prjDescription;
        IProject project = null;
        if (cfgDescription != null && (prjDescription = cfgDescription.getProjectDescription()) != null) {
            project = prjDescription.getProject();
        }
        return !ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled(project) || ScannerDiscoveryLegacySupport.isMbsLanguageSettingsProviderOn(cfgDescription);
    }

    public static boolean isLegacyScannerDiscoveryOn(IProject project) {
        ICConfigurationDescription cfgDescription = null;
        ICProjectDescription prjDescription = CoreModel.getDefault().getProjectDescription(project);
        if (prjDescription != null) {
            cfgDescription = prjDescription.getActiveConfiguration();
        }
        return !ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled(project) || ScannerDiscoveryLegacySupport.isMbsLanguageSettingsProviderOn(cfgDescription);
    }

    public static List<ILanguageSettingsProvider> getDefaultProvidersLegacy() {
        ArrayList<ILanguageSettingsProvider> providers = new ArrayList<ILanguageSettingsProvider>(2);
        ILanguageSettingsProvider provider = LanguageSettingsExtensionManager.getExtensionProviderCopy(USER_LANGUAGE_SETTINGS_PROVIDER_ID, false);
        if (provider != null) {
            providers.add(provider);
        }
        providers.add(LanguageSettingsProvidersSerializer.getWorkspaceProvider(MBS_LANGUAGE_SETTINGS_PROVIDER_ID));
        return providers;
    }

    public static String getDeprecatedLegacyProfiles(String id) {
        if (legacyProfiles == null) {
            legacyProfiles = new HashMap<String, String>();
            legacyProfiles.put("cdt.managedbuild.tool.gnu.c.compiler.input", "org.eclipse.cdt.managedbuilder.core.GCCManagedMakePerProjectProfileC|org.eclipse.cdt.make.core.GCCStandardMakePerFileProfile");
            legacyProfiles.put("cdt.managedbuild.tool.gnu.cpp.compiler.input", "org.eclipse.cdt.managedbuilder.core.GCCManagedMakePerProjectProfileCPP|org.eclipse.cdt.make.core.GCCStandardMakePerFileProfile");
            legacyProfiles.put("cdt.managedbuild.tool.gnu.c.compiler.input.cygwin", "org.eclipse.cdt.managedbuilder.core.GCCWinManagedMakePerProjectProfileC");
            legacyProfiles.put("cdt.managedbuild.tool.gnu.cpp.compiler.input.cygwin", "org.eclipse.cdt.managedbuilder.core.GCCWinManagedMakePerProjectProfileCPP");
            legacyProfiles.put("cdt.managedbuild.tool.xlc.c.compiler.input", "org.eclipse.cdt.managedbuilder.xlc.core.XLCManagedMakePerProjectProfile");
            legacyProfiles.put("cdt.managedbuild.tool.xlc.cpp.c.compiler.input", "org.eclipse.cdt.managedbuilder.xlc.core.XLCManagedMakePerProjectProfile");
            legacyProfiles.put("cdt.managedbuild.tool.xlc.cpp.compiler.input", "org.eclipse.cdt.managedbuilder.xlc.core.XLCManagedMakePerProjectProfileCPP");
        }
        return legacyProfiles.get(id);
    }
}

