/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class SizeofCalculator {
    private static final SizeAndAlignment SIZE_1 = new SizeAndAlignment(1L, 1);
    public final SizeAndAlignment size_2;
    public final SizeAndAlignment size_4;
    public final SizeAndAlignment size_8;
    public final SizeAndAlignment sizeof_pointer;
    public final SizeAndAlignment sizeof_int;
    public final SizeAndAlignment sizeof_long;
    public final SizeAndAlignment sizeof_long_long;
    public final SizeAndAlignment sizeof_short;
    public final SizeAndAlignment sizeof_bool;
    public final SizeAndAlignment sizeof_wchar_t;
    public final SizeAndAlignment sizeof_float;
    public final SizeAndAlignment sizeof_complex_float;
    public final SizeAndAlignment sizeof_double;
    public final SizeAndAlignment sizeof_complex_double;
    public final SizeAndAlignment sizeof_long_double;
    public final SizeAndAlignment sizeof_complex_long_double;

    public SizeofCalculator(IASTTranslationUnit ast) {
        int maxAlignment = 32;
        HashMap<String, String> sizeofMacros = new HashMap<String, String>();
        IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = ast.getBuiltinMacroDefinitions();
        int n = iASTPreprocessorMacroDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorMacroDefinition macro = iASTPreprocessorMacroDefinitionArray[n2];
            String name = macro.getName().toString();
            if ("__BIGGEST_ALIGNMENT__".equals(name)) {
                try {
                    maxAlignment = Integer.parseInt(macro.getExpansion());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (name.startsWith("__SIZEOF_")) {
                sizeofMacros.put(name, macro.getExpansion());
            }
            ++n2;
        }
        this.size_2 = new SizeAndAlignment(2L, Math.min(2, maxAlignment));
        this.size_4 = new SizeAndAlignment(4L, Math.min(4, maxAlignment));
        this.size_8 = new SizeAndAlignment(8L, Math.min(8, maxAlignment));
        this.sizeof_pointer = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_POINTER__", maxAlignment);
        this.sizeof_int = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_INT__", maxAlignment);
        this.sizeof_long = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_LONG__", maxAlignment);
        this.sizeof_long_long = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_LONG_LONG__", maxAlignment);
        this.sizeof_short = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_SHORT__", maxAlignment);
        this.sizeof_bool = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_BOOL__", maxAlignment);
        this.sizeof_wchar_t = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_WCHAR_T__", maxAlignment);
        this.sizeof_float = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_FLOAT__", maxAlignment);
        this.sizeof_complex_float = this.getSizeOfPair(this.sizeof_float);
        this.sizeof_double = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_DOUBLE__", maxAlignment);
        this.sizeof_complex_double = this.getSizeOfPair(this.sizeof_double);
        this.sizeof_long_double = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_LONG_DOUBLE__", maxAlignment);
        this.sizeof_complex_long_double = this.getSizeOfPair(this.sizeof_long_double);
    }

    public SizeAndAlignment sizeAndAlignment(IType type) {
        if ((type = SemanticUtil.getNestedType(type, 9)) instanceof IBasicType) {
            return this.sizeAndAlignment((IBasicType)type);
        }
        if (type instanceof IPointerType || type instanceof ICPPReferenceType) {
            if (type instanceof ICPPPointerToMemberType) {
                return null;
            }
            return this.sizeof_pointer;
        }
        if (type instanceof IEnumeration) {
            return this.sizeAndAlignment((IEnumeration)type);
        }
        if (type instanceof IArrayType) {
            return this.sizeAndAlignment((IArrayType)type);
        }
        if (type instanceof ICompositeType) {
            return this.sizeAndAlignment((ICompositeType)type);
        }
        return null;
    }

    public SizeAndAlignment sizeAndAlignmentOfPointer() {
        return this.sizeof_pointer;
    }

    private SizeAndAlignment sizeAndAlignment(IBasicType type) {
        IBasicType.Kind kind = type.getKind();
        switch (kind) {
            case eBoolean: {
                return this.sizeof_bool;
            }
            case eChar: {
                return SIZE_1;
            }
            case eInt: {
                return type.isShort() ? this.sizeof_short : (type.isLong() ? this.sizeof_long : (type.isLongLong() ? this.sizeof_long_long : this.sizeof_int));
            }
            case eFloat: {
                return type.isComplex() ? this.sizeof_complex_float : this.sizeof_float;
            }
            case eDouble: {
                return type.isComplex() ? (type.isLong() ? this.sizeof_long_double : this.sizeof_double) : (type.isLong() ? this.sizeof_complex_long_double : this.sizeof_complex_double);
            }
            case eWChar: {
                return this.sizeof_wchar_t;
            }
            case eChar16: {
                return this.size_2;
            }
            case eChar32: {
                return this.size_4;
            }
            case eNullPtr: {
                return this.sizeAndAlignmentOfPointer();
            }
        }
        return null;
    }

    private SizeAndAlignment sizeAndAlignment(IEnumeration type) {
        IType fixedType;
        if (type instanceof ICPPEnumeration && (fixedType = ((ICPPEnumeration)type).getFixedType()) != null) {
            return this.sizeAndAlignment(fixedType);
        }
        long range = Math.max(Math.abs(type.getMinValue()) - 1L, Math.abs(type.getMaxValue()));
        if (range >= 2L) {
            return this.size_8;
        }
        if (type.getMinValue() < 0L) {
            range *= 2L;
        }
        if (range >= 2L) {
            return this.size_8;
        }
        if (range >= 131072L) {
            return this.size_4;
        }
        if (range >= 512L) {
            return this.size_2;
        }
        return SIZE_1;
    }

    private SizeAndAlignment sizeAndAlignment(IArrayType type) {
        IValue value = type.getSize();
        if (value == null) {
            return null;
        }
        Long numElements = value.numericalValue();
        if (numElements == null) {
            return null;
        }
        IType elementType = type.getType();
        SizeAndAlignment info = this.sizeAndAlignment(elementType);
        if (numElements == 1L) {
            return info;
        }
        if (info == null) {
            return null;
        }
        return new SizeAndAlignment(info.size * numElements, info.alignment);
    }

    private SizeAndAlignment sizeAndAlignment(ICompositeType type) {
        IField[] fields;
        SizeAndAlignment info;
        int n;
        int n2;
        Object[] objectArray;
        long size = 0L;
        int maxAlignment = 1;
        if (type instanceof ICPPClassType) {
            ICPPClassType classType = (ICPPClassType)type;
            objectArray = classType.getBases();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object base = objectArray[n];
                if (base.isVirtual()) {
                    return null;
                }
                IBinding baseClass = base.getBaseClass();
                if (!(baseClass instanceof IType)) {
                    return null;
                }
                info = this.sizeAndAlignment((IType)((Object)baseClass));
                if (info == null) {
                    return null;
                }
                size += (long)info.alignment - (size - 1L) % (long)info.alignment - 1L + info.size;
                if (maxAlignment < info.alignment) {
                    maxAlignment = info.alignment;
                }
                ICPPMethod[] iCPPMethodArray = classType.getDeclaredMethods();
                int n3 = iCPPMethodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICPPMethod method = iCPPMethodArray[n4];
                    if (method.isVirtual()) {
                        return null;
                    }
                    ++n4;
                }
                ++n;
            }
            fields = classType.getDeclaredFields();
        } else {
            fields = type.getFields();
        }
        boolean union = type.getKey() == 2;
        objectArray = fields;
        n2 = fields.length;
        n = 0;
        while (n < n2) {
            Object field = objectArray[n];
            if (!field.isStatic()) {
                IType fieldType = field.getType();
                info = this.sizeAndAlignment(fieldType);
                if (info == null) {
                    return null;
                }
                if (union) {
                    if (size < info.size) {
                        size = info.size;
                    }
                } else {
                    size += (long)info.alignment - (size - 1L) % (long)info.alignment - 1L + info.size;
                }
                if (maxAlignment < info.alignment) {
                    maxAlignment = info.alignment;
                }
            }
            ++n;
        }
        if (size > 0L) {
            size += (long)maxAlignment - (size - 1L) % (long)maxAlignment - 1L;
        }
        return new SizeAndAlignment(size, maxAlignment);
    }

    private static SizeAndAlignment getSize(Map<String, String> macros, String name, int maxAlignment) {
        String value = macros.get(name);
        if (value == null) {
            return null;
        }
        try {
            int size = Integer.parseInt(value);
            return new SizeAndAlignment(size, Math.min(size, maxAlignment));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private SizeAndAlignment getSizeOfPair(SizeAndAlignment sizeAndAlignment) {
        return sizeAndAlignment == null ? null : new SizeAndAlignment(sizeAndAlignment.size * 2L, sizeAndAlignment.alignment);
    }

    public static class SizeAndAlignment {
        public final long size;
        public final int alignment;

        public SizeAndAlignment(long size, int alignment) {
            this.size = size;
            this.alignment = alignment;
        }
    }
}

