/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.core.runtime.Assert;

public class CPPTemplateArgument
implements ICPPTemplateArgument {
    private final IType fType;
    private final IValue fValue;

    public CPPTemplateArgument(IValue value, IType type) {
        Assert.isNotNull((Object)value);
        this.fType = type;
        this.fValue = value;
    }

    public CPPTemplateArgument(IType type) {
        Assert.isNotNull((Object)type);
        this.fType = type;
        this.fValue = null;
    }

    @Override
    public boolean isTypeValue() {
        return this.fValue == null;
    }

    @Override
    public boolean isNonTypeValue() {
        return this.fValue != null;
    }

    @Override
    public IType getTypeValue() {
        return this.isTypeValue() ? this.fType : null;
    }

    @Override
    public IValue getNonTypeValue() {
        return this.fValue;
    }

    @Override
    public IType getTypeOfNonTypeValue() {
        return this.isNonTypeValue() ? this.fType : null;
    }

    @Override
    public boolean isPackExpansion() {
        return this.fType instanceof ICPPParameterPackType;
    }

    @Override
    public ICPPTemplateArgument getExpansionPattern() {
        IType t;
        if (this.fType instanceof ICPPParameterPackType && (t = ((ICPPParameterPackType)this.fType).getType()) != null) {
            if (this.fValue != null) {
                return new CPPTemplateArgument(this.fValue, t);
            }
            return new CPPTemplateArgument(t);
        }
        return null;
    }

    @Override
    public boolean isSameValue(ICPPTemplateArgument arg) {
        if (this.fValue != null) {
            return this.fValue.equals(arg.getNonTypeValue());
        }
        return this.fType.isSameType(arg.getTypeValue());
    }

    public String toString() {
        if (this.fValue != null) {
            return this.fValue.toString();
        }
        return this.fType.toString();
    }
}

