/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.VariableReadWriteFlags;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public final class CPPVariableReadWriteFlags
extends VariableReadWriteFlags {
    private static CPPVariableReadWriteFlags INSTANCE = new CPPVariableReadWriteFlags();

    public static int getReadWriteFlags(IASTName variable) {
        return INSTANCE.rwAnyNode(variable, 0);
    }

    @Override
    protected int rwAnyNode(IASTNode node, int indirection) {
        IASTNode parent = node.getParent();
        if (parent instanceof ICPPASTConstructorInitializer) {
            return this.rwInCtorInitializer(node, indirection, (ICPPASTConstructorInitializer)parent);
        }
        return super.rwAnyNode(node, indirection);
    }

    @Override
    protected int rwInDeclarator(IASTDeclarator parent, int indirection) {
        IType type = CPPVisitor.createType(parent);
        if (type instanceof ICPPUnknownType || type instanceof ICPPClassType && !ClassTypeHelper.hasTrivialDefaultConstructor((ICPPClassType)type)) {
            return 64;
        }
        return super.rwInDeclarator(parent, indirection);
    }

    private int rwInCtorInitializer(IASTNode node, int indirection, ICPPASTConstructorInitializer parent) {
        IASTNode grand = parent.getParent();
        if (grand instanceof IASTDeclarator) {
            IBinding binding;
            if (grand instanceof IASTImplicitNameOwner) {
                IASTImplicitName[] names;
                IASTImplicitName[] iASTImplicitNameArray = names = ((IASTImplicitNameOwner)grand).getImplicitNames();
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTImplicitName in = iASTImplicitNameArray[n2];
                    IBinding b = in.resolveBinding();
                    if (b instanceof ICPPConstructor) {
                        ICPPConstructor ctor = (ICPPConstructor)b;
                        int idx = 0;
                        IASTInitializerClause[] iASTInitializerClauseArray = parent.getArguments();
                        int n3 = iASTInitializerClauseArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IASTInitializerClause child = iASTInitializerClauseArray[n4];
                            if (child == node) {
                                return this.rwArgumentForFunctionCall(ctor.getType(), idx, indirection);
                            }
                            ++idx;
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            if (parent.getArguments().length == 1 && (binding = ((IASTDeclarator)grand).getName().getBinding()) instanceof IVariable) {
                IType type = ((IVariable)binding).getType();
                return this.rwAssignmentToType(type, indirection);
            }
        }
        return 96;
    }

    @Override
    protected int rwInUnaryExpression(IASTNode node, IASTUnaryExpression expr, int indirection) {
        switch (expr.getOperator()) {
            case 13: {
                return 0;
            }
        }
        return super.rwInUnaryExpression(node, expr, indirection);
    }

    @Override
    protected int rwInFunctionName(IASTExpression node) {
        IType type;
        if (!(node instanceof IASTIdExpression) && (type = node.getExpressionType()) instanceof ICPPFunctionType && !((ICPPFunctionType)type).isConst()) {
            return 96;
        }
        return 32;
    }

    @Override
    protected int rwAssignmentToType(IType type, int indirection) {
        if (indirection == 0) {
            if (!(type instanceof ICPPReferenceType) || ((ICPPReferenceType)type).isRValueReference()) {
                return 32;
            }
            type = ((ICPPReferenceType)type).getType();
        }
        while (indirection > 0 && type instanceof ITypeContainer) {
            if (type instanceof IPointerType) {
                --indirection;
            }
            type = ((ITypeContainer)type).getType();
        }
        if (indirection == 0) {
            if (type instanceof IQualifierType) {
                return ((IQualifierType)type).isConst() ? 32 : 96;
            }
            if (type instanceof IPointerType) {
                return ((IPointerType)type).isConst() ? 32 : 96;
            }
        }
        return 96;
    }
}

