/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class ExpressionTypes {
    public static IType glvalueType(IType type) {
        return SemanticUtil.getNestedType(type, 6);
    }

    public static IType prvalueType(IType type) {
        return Conversions.lvalue_to_rvalue(type);
    }

    public static IASTExpression.ValueCategory valueCategoryFromFunctionCall(ICPPFunction function) {
        ICPPFunctionType ft = function.getType();
        return ExpressionTypes.valueCategoryFromReturnType(ft.getReturnType());
    }

    public static IASTExpression.ValueCategory valueCategoryFromReturnType(IType r) {
        if ((r = SemanticUtil.getNestedType(r, 1)) instanceof ICPPReferenceType) {
            ICPPReferenceType refType = (ICPPReferenceType)r;
            if (!refType.isRValueReference()) {
                return IASTExpression.ValueCategory.LVALUE;
            }
            if (SemanticUtil.getNestedType(refType.getType(), 13) instanceof IFunctionType) {
                return IASTExpression.ValueCategory.LVALUE;
            }
            return IASTExpression.ValueCategory.XVALUE;
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    public static IType typeFromFunctionCall(ICPPFunction function) {
        ICPPFunctionType ft = function.getType();
        return ExpressionTypes.typeFromReturnType(ft.getReturnType());
    }

    public static IType typeFromReturnType(IType type) {
        IType t = SemanticUtil.getNestedType(type, 1);
        if (t instanceof ICPPReferenceType) {
            return ExpressionTypes.glvalueType(type);
        }
        return ExpressionTypes.prvalueType(type);
    }

    public static IType typeOrFunctionSet(IASTExpression exp) {
        FunctionSetType fs = ExpressionTypes.getFunctionSetType(exp);
        if (fs != null) {
            return fs;
        }
        return exp.getExpressionType();
    }

    public static IASTExpression.ValueCategory valueCat(IASTExpression exp) {
        FunctionSetType fs = ExpressionTypes.getFunctionSetType(exp);
        if (fs != null) {
            return fs.getValueCategory();
        }
        return exp.getValueCategory();
    }

    private static FunctionSetType getFunctionSetType(IASTExpression exp) {
        IASTIdExpression idexpr;
        IASTName name;
        IBinding b;
        boolean addressOf = false;
        while (exp instanceof IASTUnaryExpression) {
            IASTUnaryExpression unary = (IASTUnaryExpression)exp;
            int op = unary.getOperator();
            if (op == 11) {
                exp = unary.getOperand();
                continue;
            }
            if (addressOf || op != 5) break;
            addressOf = true;
            exp = unary.getOperand();
        }
        if (exp instanceof IASTIdExpression && (b = (name = (idexpr = (IASTIdExpression)exp).getName()).resolvePreBinding()) instanceof CPPFunctionSet) {
            return new FunctionSetType(((CPPFunctionSet)b).getBindings(), name, addressOf);
        }
        return null;
    }

    public static IType restoreTypedefs(IType type, IType originalType) {
        IType t = SemanticUtil.substituteTypedef(type, originalType);
        if (t != null) {
            return t;
        }
        return type;
    }

    public static IType restoreTypedefs(IType type, IType originalType1, IType originalType2) {
        IType t = SemanticUtil.substituteTypedef(type, originalType1);
        if (t != null) {
            return t;
        }
        if (originalType2 != null && (t = SemanticUtil.substituteTypedef(type, originalType2)) != null) {
            return t;
        }
        return type;
    }
}

