/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.composite;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPCompositeBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUsingDeclaration;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.composite.CompositingNotImplementedError;
import org.eclipse.cdt.internal.core.index.composite.ICompositesFactory;

public abstract class CompositeScope
implements IIndexScope {
    protected final ICompositesFactory cf;
    protected final IIndexFragmentBinding rbinding;

    public CompositeScope(ICompositesFactory cf, IIndexFragmentBinding rbinding) {
        if (cf == null || rbinding == null) {
            throw new NullPointerException();
        }
        this.cf = cf;
        this.rbinding = rbinding;
    }

    @Override
    public IIndexScope getParent() {
        IIndexScope rscope = this.rbinding.getScope();
        if (rscope != null) {
            return this.cf.getCompositeScope(rscope);
        }
        return null;
    }

    @Override
    public IIndexName getScopeName() {
        if (this.rbinding instanceof IIndexScope) {
            return ((IIndexScope)((Object)this.rbinding)).getScopeName();
        }
        if (this.rbinding instanceof ICPPClassType) {
            return (IIndexName)((ICPPClassType)((Object)this.rbinding)).getCompositeScope().getScopeName();
        }
        return null;
    }

    protected final void fail() {
        throw new CompositingNotImplementedError();
    }

    public IBinding getRawScopeBinding() {
        return this.rbinding;
    }

    protected final IBinding processUncertainBinding(IBinding binding) {
        if (binding instanceof IIndexFragmentBinding) {
            return this.cf.getCompositeBinding((IIndexFragmentBinding)binding);
        }
        if (binding instanceof ProblemBinding) {
            return binding;
        }
        if (binding instanceof CPPCompositeBinding) {
            return new CPPCompositeBinding(this.processUncertainBindings(((CPPCompositeBinding)binding).getBindings()));
        }
        if (binding instanceof CPPUsingDeclaration) {
            return binding;
        }
        if (binding == null) {
            return null;
        }
        if (binding instanceof ICPPSpecialization) {
            return binding;
        }
        CCorePlugin.log("CompositeFactory unsure how to process: " + binding.getClass().getName());
        return binding;
    }

    protected final IBinding[] processUncertainBindings(IBinding[] frgBindings) {
        if (frgBindings != null) {
            IBinding[] result = new IBinding[frgBindings.length];
            int i = 0;
            while (i < result.length) {
                result[i] = this.processUncertainBinding(frgBindings[i]);
                ++i;
            }
            return result;
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public final IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    @Override
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) {
        return this.getBindings(name, resolve, prefix, IIndexFileSet.EMPTY);
    }

    public final boolean equals(Object other) {
        if (other instanceof CompositeScope) {
            return this.rbinding.equals(((CompositeScope)other).rbinding);
        }
        return false;
    }

    public final int hashCode() {
        return this.rbinding.hashCode();
    }
}

