/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;

public enum VisibilityEnum {
    v_private("private", 3, 3),
    v_protected("protected", 2, 2),
    v_public("public", 1, 1);

    private final String stringRepresentation;
    private final int visibilityLabelValue;
    private final int baseSpecifierValue;

    private VisibilityEnum(String stringRepresentation, int visibilityLabelValue, int baseSpecifierValue) {
        this.stringRepresentation = stringRepresentation;
        this.visibilityLabelValue = visibilityLabelValue;
        this.baseSpecifierValue = baseSpecifierValue;
    }

    public static VisibilityEnum from(ICPPASTVisibilityLabel visibility) {
        switch (visibility.getVisibility()) {
            case 3: {
                return v_private;
            }
            case 2: {
                return v_protected;
            }
            case 1: {
                return v_public;
            }
        }
        return null;
    }

    public int getBaseSpecifierValue() {
        return this.baseSpecifierValue;
    }

    public int getVisibilityLabelValue() {
        return this.visibilityLabelValue;
    }

    public static VisibilityEnum getEnumForStringRepresentation(String visibility) {
        if (v_private.toString().equals(visibility)) {
            return v_private;
        }
        if (v_protected.toString().equals(visibility)) {
            return v_protected;
        }
        if (v_public.toString().equals(visibility)) {
            return v_public;
        }
        return null;
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

