/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.breakpoints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemorySpaceManagement;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CEventBreakpoint;
import org.eclipse.cdt.debug.internal.ui.breakpoints.BreakpointsMessages;
import org.eclipse.cdt.debug.internal.ui.breakpoints.CBreakpointContext;
import org.eclipse.cdt.debug.internal.ui.breakpoints.CBreakpointPreferenceStore;
import org.eclipse.cdt.debug.internal.ui.preferences.ComboFieldEditor;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.CBreakpointUIContributionFactory;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointContext;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointsUIContribution;
import org.eclipse.cdt.debug.ui.preferences.ReadOnlyFieldEditor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CBreakpointPropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private Composite fEventBPComposite;
    private Composite fEventArgsComposite;
    private List<FieldEditor> fEventArgsFEs = null;
    private BooleanFieldEditor fEnabled;
    private BreakpointStringFieldEditor fCondition;
    private Text fIgnoreCountTextControl;
    private BreakpointIntegerFieldEditor fIgnoreCount;
    private IAdaptable fElement;
    private CBreakpointPreferenceStore fCBreakpointPreferenceStore;

    private String[][] makeArray2D(String[] array) {
        String[][] array2d = new String[array.length][];
        int i = 0;
        while (i < array.length) {
            array2d[i] = new String[2];
            String string = array[i];
            array2d[i][1] = string;
            array2d[i][0] = string;
            ++i;
        }
        return array2d;
    }

    private String[][] joinToArray2D(String[] labels, String[] values) {
        String[][] array2d = new String[labels.length][];
        int i = 0;
        while (i < labels.length) {
            array2d[i] = new String[2];
            array2d[i][0] = labels[i];
            array2d[i][1] = values[i];
            ++i;
        }
        return array2d;
    }

    private ICDIMemorySpaceManagement getMemorySpaceManagement() {
        ICDITarget target;
        ICDebugTarget debugTarget;
        Object debugViewElement = this.getDebugContext();
        ICDIMemorySpaceManagement memMgr = null;
        if (debugViewElement != null && (debugTarget = (ICDebugTarget)DebugPlugin.getAdapter((Object)debugViewElement, ICDebugTarget.class)) != null && (target = (ICDITarget)debugTarget.getAdapter(ICDITarget.class)) instanceof ICDIMemorySpaceManagement) {
            memMgr = (ICDIMemorySpaceManagement)target;
        }
        return memMgr;
    }

    public CBreakpointPropertyPage() {
        super(1);
        this.noDefaultAndApplyButton();
    }

    protected void createFieldEditors() {
        ICBreakpoint breakpoint = this.getBreakpoint();
        this.createMainLabel(breakpoint);
        this.createContributedFieldEditors(breakpoint, "breakpointLabels");
        this.createTypeSpecificLabelFieldEditors(breakpoint);
        this.createEnabledField(this.getFieldEditorParent());
        this.createConditionEditor(this.getFieldEditorParent());
        this.createIgnoreCountEditor(this.getFieldEditorParent());
        this.createContributedFieldEditors(breakpoint, "breakpointEditors");
    }

    private void createMainLabel(ICBreakpoint breakpoint) {
        String label = this.getBreakpointMainLabel(breakpoint);
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), BreakpointsMessages.getString("CBreakpointPropertyPage.breakpointType_label"), label));
    }

    private void createTypeSpecificLabelFieldEditors(ICBreakpoint breakpoint) {
        if (breakpoint instanceof ICFunctionBreakpoint) {
            this.createFunctionEditor(this.getFieldEditorParent());
        } else if (breakpoint instanceof ICAddressBreakpoint) {
            String title = BreakpointsMessages.getString("CBreakpointPropertyPage.address_label");
            String address = this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.address");
            if (address == null || address.trim().length() == 0) {
                address = BreakpointsMessages.getString("CBreakpointPropertyPage.address_valueNotAvailable_label");
            }
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), title, address));
        } else if (breakpoint instanceof ICWatchpoint) {
            String filename;
            IProject project;
            IResource resource = this.getResource();
            if (resource != null && (project = resource.getProject()) != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), BreakpointsMessages.getString("CBreakpointPropertyPage.project_label"), project.getName()));
            }
            if ((filename = this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.sourceHandle")) != null && !"".equals(filename)) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), BreakpointsMessages.getString("CBreakpointPropertyPage.sourceHandle_label"), filename));
            }
            this.createWatchExpressionEditor(this.getFieldEditorParent());
            this.createWatchMemorySpaceEditor(this.getFieldEditorParent());
            this.createWatchRangeEditor(this.getFieldEditorParent());
            this.createWatchTypeEditors(this.getFieldEditorParent());
        } else if (breakpoint instanceof ILineBreakpoint) {
            int lNumber;
            String fileName = this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.sourceHandle");
            if (fileName != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), BreakpointsMessages.getString("CBreakpointPropertyPage.sourceHandle_label"), fileName));
            }
            if ((lNumber = this.getPreferenceStore().getInt("lineNumber")) > 0) {
                this.getPreferenceStore().setValue("lineNumber", lNumber);
                this.createLineNumberEditor(this.getFieldEditorParent());
            }
        } else if (breakpoint instanceof CEventBreakpoint) {
            this.createEventBreakpointEditor(breakpoint, "breakpointLabels");
        }
    }

    private String getBreakpointMainLabel(ICBreakpoint breakpoint) {
        if (breakpoint instanceof ICWatchpoint && breakpoint.getMarker() != null) {
            boolean isReadType = this.getPreferenceStore().getBoolean("org.eclipse.cdt.debug.core.read");
            boolean isWriteType = this.getPreferenceStore().getBoolean("org.eclipse.cdt.debug.core.write");
            if (isReadType && !isWriteType) {
                return BreakpointsMessages.getString("CBreakpointPropertyPage.breakpointType_watchpoint_read_label");
            }
            if (!isReadType && isWriteType) {
                return BreakpointsMessages.getString("CBreakpointPropertyPage.breakpointType_watchpoint_label");
            }
            return BreakpointsMessages.getString("CBreakpointPropertyPage.watchpointType_breakpointType_watchpoint_access_label");
        }
        IWorkbenchAdapter labelProvider = (IWorkbenchAdapter)this.getElement().getAdapter(IWorkbenchAdapter.class);
        if (labelProvider != null) {
            return labelProvider.getLabel((Object)this.getElement());
        }
        return CDIDebugModel.calculateMarkerType((IBreakpoint)breakpoint);
    }

    protected void createFunctionEditor(Composite parent) {
        ICBreakpoint breakpoint = this.getBreakpoint();
        String title = BreakpointsMessages.getString("CBreakpointPropertyPage.function_label");
        if (breakpoint == null || breakpoint.getMarker() == null) {
            BreakpointStringFieldEditor expressionEditor = new BreakpointStringFieldEditor("org.eclipse.cdt.debug.core.function", title, parent);
            expressionEditor.setErrorMessage(BreakpointsMessages.getString("CBreakpointPropertyPage.function_value_errorMessage"));
            expressionEditor.setEmptyStringAllowed(false);
            this.addField((FieldEditor)expressionEditor);
        } else {
            String function = this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.function");
            if (function == null) {
                function = BreakpointsMessages.getString("CBreakpointPropertyPage.function_valueNotAvailable_label");
            }
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), BreakpointsMessages.getString("CBreakpointPropertyPage.function_label"), function));
        }
    }

    protected void createLineNumberEditor(Composite parent) {
        String title = BreakpointsMessages.getString("CBreakpointPropertyPage.lineNumber_label");
        BreakpointIntegerFieldEditor labelFieldEditor = new BreakpointIntegerFieldEditor("lineNumber", title, parent);
        labelFieldEditor.setValidRange(1, Integer.MAX_VALUE);
        this.addField((FieldEditor)labelFieldEditor);
    }

    protected void createWatchExpressionEditor(Composite parent) {
        ICBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint == null || breakpoint.getMarker() == null) {
            BreakpointStringFieldEditor expressionEditor = new BreakpointStringFieldEditor("org.eclipse.cdt.debug.core.expression", BreakpointsMessages.getString("CBreakpointPropertyPage.watchpoint_expression_label"), parent);
            expressionEditor.setErrorMessage(BreakpointsMessages.getString("CBreakpointPropertyPage.watchpoint_expression_errorMessage"));
            expressionEditor.setEmptyStringAllowed(false);
            this.addField((FieldEditor)expressionEditor);
        } else {
            this.addField(this.createLabelEditor(parent, BreakpointsMessages.getString("CBreakpointPropertyPage.watchpoint_expression_label"), this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.expression")));
        }
    }

    protected void createWatchMemorySpaceEditor(Composite parent) {
        ICBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint == null || breakpoint.getMarker() == null) {
            String[] memorySpaces;
            ICDIMemorySpaceManagement memSpaceMgmt = this.getMemorySpaceManagement();
            if (memSpaceMgmt != null && (memorySpaces = memSpaceMgmt.getMemorySpaces()) != null && memorySpaces.length != 0) {
                this.addField(new WatchpointMemorySpaceFieldEditor("org.eclipse.cdt.debug.core.memoryspace", BreakpointsMessages.getString("CBreakpointPropertyPage.watchpoint_memorySpace_label"), memorySpaces, parent));
            }
        } else {
            String memorySpace = this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.memoryspace");
            if (memorySpace != null && memorySpace.length() != 0) {
                this.addField(this.createLabelEditor(parent, BreakpointsMessages.getString("CBreakpointPropertyPage.watchpoint_memorySpace_label"), this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.memoryspace")));
            }
        }
    }

    protected void createWatchRangeEditor(Composite parent) {
        ICBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint == null || breakpoint.getMarker() == null) {
            this.addField((FieldEditor)new WatchpointRangeFieldEditor("org.eclipse.cdt.debug.core.range", BreakpointsMessages.getString("CBreakpointPropertyPage.watchpoint_range_label"), parent));
        } else {
            this.addField(this.createLabelEditor(parent, BreakpointsMessages.getString("CBreakpointPropertyPage.watchpoint_range_label"), this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.range")));
        }
    }

    protected void createWatchTypeEditors(Composite parent) {
        ICBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint != null && breakpoint.getMarker() == null) {
            this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.cdt.debug.core.read", BreakpointsMessages.getString("CBreakpointPropertyPage.watchpointType_read_label"), parent));
            this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.cdt.debug.core.write", BreakpointsMessages.getString("CBreakpointPropertyPage.watchpointType_write_label"), parent));
        }
    }

    protected void createEnabledField(Composite parent) {
        this.fEnabled = new BooleanFieldEditor("org.eclipse.debug.core.enabled", BreakpointsMessages.getString("CBreakpointPropertyPage.enabled_label"), parent);
        this.addField((FieldEditor)this.fEnabled);
    }

    protected void createConditionEditor(Composite parent) {
        this.fCondition = new BreakpointStringFieldEditor("org.eclipse.cdt.debug.core.condition", BreakpointsMessages.getString("CBreakpointPropertyPage.condition_label"), parent);
        this.fCondition.setEmptyStringAllowed(true);
        this.fCondition.setErrorMessage(BreakpointsMessages.getString("CBreakpointPropertyPage.condition_invalidValue_message"));
        this.addField((FieldEditor)this.fCondition);
    }

    protected void createIgnoreCountEditor(Composite parent) {
        this.fIgnoreCount = new BreakpointIntegerFieldEditor("org.eclipse.cdt.debug.core.ignoreCount", BreakpointsMessages.getString("CBreakpointPropertyPage.ignoreCount_label"), parent);
        this.fIgnoreCount.setValidRange(0, Integer.MAX_VALUE);
        this.fIgnoreCountTextControl = this.fIgnoreCount.getTextControl(parent);
        this.fIgnoreCountTextControl.setEnabled(this.getPreferenceStore().getInt("org.eclipse.cdt.debug.core.ignoreCount") >= 0);
        this.addField((FieldEditor)this.fIgnoreCount);
    }

    protected FieldEditor createLabelEditor(Composite parent, String title, String value) {
        return new LabelFieldEditor(parent, title, value);
    }

    protected ICBreakpoint getBreakpoint() {
        IAdaptable element = this.getElement();
        if (element instanceof ICBreakpoint) {
            return (ICBreakpoint)element;
        }
        if (element instanceof ICBreakpointContext) {
            return ((ICBreakpointContext)element).getBreakpoint();
        }
        return (ICBreakpoint)element.getAdapter(ICBreakpoint.class);
    }

    protected Object getDebugContext() {
        IDebugContextProvider provider = (IDebugContextProvider)this.getElement().getAdapter(IDebugContextProvider.class);
        if (provider != null) {
            ISelection selection = provider.getActiveContext();
            if (selection instanceof IStructuredSelection) {
                return ((IStructuredSelection)selection).getFirstElement();
            }
            return null;
        }
        return DebugUITools.getDebugContext();
    }

    protected IResource getResource() {
        IAdaptable element = this.getElement();
        if (element instanceof ICBreakpoint) {
            IMarker marker = ((ICBreakpoint)element).getMarker();
            if (marker != null) {
                return marker.getResource();
            }
        } else if (element instanceof ICBreakpointContext) {
            return ((ICBreakpointContext)element).getResource();
        }
        return null;
    }

    public IPreferenceStore getPreferenceStore() {
        IAdaptable element = this.getElement();
        if (element instanceof ICBreakpointContext) {
            return ((ICBreakpointContext)element).getPreferenceStore();
        }
        if (this.fCBreakpointPreferenceStore == null) {
            CBreakpointContext bpContext = element instanceof CBreakpointContext ? (CBreakpointContext)element : null;
            this.fCBreakpointPreferenceStore = new CBreakpointPreferenceStore(bpContext, null);
        }
        return this.fCBreakpointPreferenceStore;
    }

    public boolean performCancel() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store instanceof CBreakpointPreferenceStore) {
            ((CBreakpointPreferenceStore)store).setCanceled(true);
        }
        return super.performCancel();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store instanceof CBreakpointPreferenceStore) {
            ((CBreakpointPreferenceStore)store).setCanceled(false);
        }
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.fElement;
    }

    public void setElement(IAdaptable element) {
        this.fElement = element;
    }

    protected String[] getDebugModelIds() {
        String[] debugModelIds = null;
        Object debugContext = this.getDebugContext();
        IDebugModelProvider debugModelProvider = (IDebugModelProvider)DebugPlugin.getAdapter((Object)debugContext, IDebugModelProvider.class);
        if (debugModelProvider != null) {
            debugModelIds = debugModelProvider.getModelIdentifiers();
        } else if (debugContext instanceof IDebugElement) {
            debugModelIds = new String[]{((IDebugElement)debugContext).getModelIdentifier()};
        }
        return debugModelIds;
    }

    private void createEventBreakpointEditor(ICBreakpoint breakpoint, String conMainElement) {
        boolean bAddEventType = true;
        Composite parent = this.getFieldEditorParent();
        String[] debugModelIds = this.getDebugModelIds();
        try {
            CBreakpointUIContributionFactory factory = CBreakpointUIContributionFactory.getInstance();
            IPreferenceStore prefStore = this.getPreferenceStore();
            ICBreakpointsUIContribution[] cons = prefStore instanceof CBreakpointPreferenceStore ? factory.getBreakpointUIContributions(debugModelIds, (IBreakpoint)breakpoint, ((CBreakpointPreferenceStore)prefStore).getAttributes()) : factory.getBreakpointUIContributions((IBreakpoint)breakpoint);
            this.setupEventTypeFieldEditor(cons, breakpoint, conMainElement, parent);
            ICBreakpointsUIContribution[] iCBreakpointsUIContributionArray = cons;
            int n = cons.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    FieldEditor fieldEditor;
                    block10: {
                        ICBreakpointsUIContribution con;
                        block12: {
                            block11: {
                                con = iCBreakpointsUIContributionArray[n2];
                                if (!conMainElement.equals(con.getMainElement())) break block9;
                                fieldEditor = null;
                                if (breakpoint.getMarker() == null && con.getId().equals("org.eclipse.cdt.debug.core.eventbreakpoint_event_id")) break block9;
                                if (!con.getMarkerType().equalsIgnoreCase("org.eclipse.cdt.debug.core.cEventBreakpointMarker")) break block10;
                                if (breakpoint.getMarker() != null) break block11;
                                this.setupArgsComposite(parent);
                                fieldEditor = con.getFieldEditor(con.getId(), String.valueOf(con.getLabel()) + ":", this.fEventArgsComposite);
                                if (fieldEditor != null) {
                                    this.addEditorToComposite(fieldEditor);
                                    this.fEventArgsComposite.setVisible(true);
                                } else {
                                    this.fEventArgsComposite.setVisible(false);
                                }
                                break block10;
                            }
                            if (!con.getId().equals("org.eclipse.cdt.debug.core.eventbreakpoint_event_id")) break block12;
                            if (!bAddEventType) break block9;
                            bAddEventType = false;
                        }
                        fieldEditor = con.getFieldEditor(con.getId(), String.valueOf(con.getLabel()) + ":", parent);
                    }
                    if (fieldEditor != null) {
                        this.addField(fieldEditor);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
    }

    private void createContributedFieldEditors(ICBreakpoint breakpoint, String conMainElement) {
        Composite parent = this.getFieldEditorParent();
        String[] debugModelIds = this.getDebugModelIds();
        try {
            CBreakpointUIContributionFactory factory = CBreakpointUIContributionFactory.getInstance();
            IPreferenceStore prefStore = this.getPreferenceStore();
            ICBreakpointsUIContribution[] cons = prefStore instanceof CBreakpointPreferenceStore ? factory.getBreakpointUIContributions(debugModelIds, (IBreakpoint)breakpoint, ((CBreakpointPreferenceStore)prefStore).getAttributes()) : factory.getBreakpointUIContributions((IBreakpoint)breakpoint);
            ICBreakpointsUIContribution[] iCBreakpointsUIContributionArray = cons;
            int n = cons.length;
            int n2 = 0;
            while (n2 < n) {
                FieldEditor fieldEditor;
                ICBreakpointsUIContribution con = iCBreakpointsUIContributionArray[n2];
                if (conMainElement.equals(con.getMainElement()) && !con.getMarkerType().equals("org.eclipse.cdt.debug.core.cEventBreakpointMarker") && (fieldEditor = con.getFieldEditor(con.getId(), String.valueOf(con.getLabel()) + ":", parent)) != null) {
                    this.addField(fieldEditor);
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
    }

    private void setupEventTypeFieldEditor(ICBreakpointsUIContribution[] cons, ICBreakpoint breakpoint, String conMainElement, Composite parent) {
        String id = null;
        ArrayList<String> eventTypeValueList = new ArrayList<String>();
        ArrayList<String> eventTypeLabelList = new ArrayList<String>();
        ICBreakpointsUIContribution[] iCBreakpointsUIContributionArray = cons;
        int n = cons.length;
        int n2 = 0;
        while (n2 < n) {
            ICBreakpointsUIContribution con = iCBreakpointsUIContributionArray[n2];
            if (conMainElement.equals(con.getMainElement()) && breakpoint instanceof CEventBreakpoint && breakpoint.getMarker() == null && con.getId().equals("org.eclipse.cdt.debug.core.eventbreakpoint_event_id")) {
                id = con.getId();
                String[] stringArray = con.getPossibleValues();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String value = stringArray[n4];
                    eventTypeValueList.add(value);
                    eventTypeLabelList.add(con.getLabelForValue(value));
                    ++n4;
                }
            }
            ++n2;
        }
        if (eventTypeValueList.size() != 0) {
            EventTypeFieldEditor fieldEditor = new EventTypeFieldEditor(id, BreakpointsMessages.getString("CBreakpointPropertyPage.eventType_label"), eventTypeLabelList.toArray(new String[eventTypeLabelList.size()]), eventTypeValueList.toArray(new String[eventTypeValueList.size()]), parent, breakpoint);
            this.addField(fieldEditor);
            this.setupArgsComposite(parent);
            fieldEditor.initializeComboBox(this.getPreferenceStore(), this);
        }
    }

    void addEditorToComposite(FieldEditor fieldEditor) {
        if (this.fEventArgsFEs == null) {
            this.fEventArgsFEs = new ArrayList<FieldEditor>();
        }
        this.fEventArgsFEs.add(fieldEditor);
    }

    void cleanEditorsFromComposite() {
        if (this.fEventArgsFEs != null) {
            for (FieldEditor editor : this.fEventArgsFEs) {
                editor.setPreferenceStore(null);
                editor.setPage(null);
            }
        }
    }

    void setupArgsComposite(Composite parent) {
        if (this.fEventArgsComposite != null) {
            this.cleanEditorsFromComposite();
            this.fEventArgsComposite.dispose();
            this.fEventArgsComposite = null;
        }
        if (this.fEventBPComposite == null || this.fEventBPComposite.isDisposed()) {
            this.fEventBPComposite = new Composite(parent, 0);
            this.fEventBPComposite.setLayout(parent.getLayout());
            this.fEventBPComposite.setLayoutData((Object)new GridData(4, 0, true, false));
            GridDataFactory.defaultsFor((Control)this.fEventBPComposite).grab(true, false).span(2, 1).applyTo((Control)this.fEventBPComposite);
        }
        this.fEventArgsComposite = new Composite(this.fEventBPComposite, 0);
        this.fEventArgsComposite.setLayout(this.fEventBPComposite.getLayout());
        GridDataFactory.defaultsFor((Control)this.fEventArgsComposite).grab(true, false).span(2, 1).applyTo((Control)this.fEventArgsComposite);
        GridData gridData = (GridData)this.fEventArgsComposite.getLayoutData();
        gridData.horizontalIndent = 10;
        this.fEventArgsComposite.setLayoutData((Object)gridData);
        this.fEventArgsComposite.setVisible(false);
    }

    private void displayEventArgs(ICBreakpoint breakpoint, Composite parent) {
        boolean result = false;
        String[] debugModelIds = this.getDebugModelIds();
        try {
            CBreakpointUIContributionFactory factory = CBreakpointUIContributionFactory.getInstance();
            IPreferenceStore prefStore = this.getPreferenceStore();
            ICBreakpointsUIContribution[] cons = prefStore instanceof CBreakpointPreferenceStore ? factory.getBreakpointUIContributions(debugModelIds, (IBreakpoint)breakpoint, ((CBreakpointPreferenceStore)prefStore).getAttributes()) : factory.getBreakpointUIContributions((IBreakpoint)breakpoint);
            ICBreakpointsUIContribution[] iCBreakpointsUIContributionArray = cons;
            int n = cons.length;
            int n2 = 0;
            while (n2 < n) {
                ICBreakpointsUIContribution con = iCBreakpointsUIContributionArray[n2];
                if (con.getMarkerType().equalsIgnoreCase("org.eclipse.cdt.debug.core.cEventBreakpointMarker") && !con.getId().equals("org.eclipse.cdt.debug.core.eventbreakpoint_event_id")) {
                    this.setupArgsComposite(parent);
                    FieldEditor fieldEditor = con.getFieldEditor(con.getId(), String.valueOf(con.getLabel()) + ":", this.fEventArgsComposite);
                    if (fieldEditor != null) {
                        fieldEditor.setPreferenceStore(this.getPreferenceStore());
                        fieldEditor.setPage((DialogPage)this);
                        this.addEditorToComposite(fieldEditor);
                        this.addField(fieldEditor);
                        result = true;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
        if (this.fEventArgsComposite != null && !this.fEventArgsComposite.isDisposed()) {
            this.fEventArgsComposite.setVisible(result);
            this.fEventArgsComposite.layout();
            this.fEventBPComposite.layout();
        }
    }

    class BreakpointIntegerFieldEditor
    extends IntegerFieldEditor {
        public BreakpointIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setErrorMessage(BreakpointsMessages.getString("CBreakpointPropertyPage.0"));
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void clearErrorMessage() {
            if (this.getPage() != null) {
                String message = this.getPage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class BreakpointStringFieldEditor
    extends StringFieldEditor {
        public BreakpointStringFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void doLoad() {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.setStringValue(value);
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (this.getPage() != null) {
                String message = this.getPage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class EventTypeFieldEditor
    extends ComboFieldEditor {
        final Combo fCombo;
        final Composite fParent;
        final ICBreakpoint fBreakpoint;

        public EventTypeFieldEditor(String name, String labelText, String[] eventTypesLabels, String[] eventTypesValues, Composite parent, ICBreakpoint breakpoint) {
            super(name, labelText, CBreakpointPropertyPage.this.joinToArray2D(eventTypesLabels, eventTypesValues), parent);
            this.fBreakpoint = breakpoint;
            this.fParent = parent;
            this.fCombo = this.getComboBoxControl();
            this.fCombo.select(0);
            this.fCombo.addSelectionListener((SelectionListener)new EventTypeSelectionListener());
        }

        public void initializeComboBox(IPreferenceStore prefStore, CBreakpointPropertyPage page) {
            if (this.getPage() == null) {
                this.setPage((DialogPage)page);
            }
            if (this.getPreferenceStore() == null) {
                this.setPreferenceStore(prefStore);
            } else {
                prefStore = this.getPreferenceStore();
            }
            String value = this.getValueForName(this.fCombo.getText());
            if (prefStore instanceof CBreakpointPreferenceStore) {
                prefStore.setValue("org.eclipse.cdt.debug.core.eventbreakpoint_event_id", value);
            }
            CBreakpointPropertyPage.this.displayEventArgs(this.fBreakpoint, this.fParent);
        }

        class EventTypeSelectionListener
        implements SelectionListener {
            EventTypeSelectionListener() {
            }

            public void widgetSelected(SelectionEvent e) {
                EventTypeFieldEditor.this.doStore();
                CBreakpointPropertyPage.this.displayEventArgs(EventTypeFieldEditor.this.fBreakpoint, EventTypeFieldEditor.this.fParent);
                EventTypeFieldEditor.this.fParent.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        }
    }

    class LabelFieldEditor
    extends ReadOnlyFieldEditor {
        private String fValue;

        public LabelFieldEditor(Composite parent, String title, String value) {
            super(title, title, parent);
            this.fValue = value;
        }

        @Override
        protected void doLoad() {
            if (this.textField != null) {
                this.textField.setText(this.fValue);
            }
        }

        @Override
        protected void doLoadDefault() {
        }
    }

    class WatchpointMemorySpaceFieldEditor
    extends ComboFieldEditor {
        private static final String DISABLED_VALUE = "";
        private Button fCheckbox;
        private boolean fWasSelected;

        public WatchpointMemorySpaceFieldEditor(String name, String labelText, String[] memorySpaces, Composite parent) {
            super(name, labelText, CBreakpointPropertyPage.this.makeArray2D(memorySpaces), parent);
        }

        @Override
        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.getCheckboxControl(parent);
            super.doFillIntoGrid(parent, numColumns);
        }

        private Button getCheckboxControl(Composite parent) {
            if (this.fCheckbox == null) {
                Composite inner = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                inner.setLayout((Layout)layout);
                this.fCheckbox = new Button(inner, 32);
                this.fCheckbox.setFont(parent.getFont());
                this.fCheckbox.setText(this.getLabelText());
                Label label = this.getLabelControl(inner);
                label.setText(DISABLED_VALUE);
                label.setVisible(false);
                this.fCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean isSelected = WatchpointMemorySpaceFieldEditor.this.fCheckbox.getSelection();
                        WatchpointMemorySpaceFieldEditor.this.valueChanged(WatchpointMemorySpaceFieldEditor.this.fWasSelected, isSelected);
                        WatchpointMemorySpaceFieldEditor.this.fWasSelected = isSelected;
                    }
                });
            } else {
                this.checkParent((Control)this.fCheckbox.getParent(), parent);
            }
            return this.fCheckbox;
        }

        public Label getLabelControl(Composite parent) {
            Label label = this.getLabelControl();
            if (label == null) {
                return super.getLabelControl(parent);
            }
            this.checkParent((Control)label.getParent(), parent);
            return label;
        }

        @Override
        protected void doLoad() {
            super.doLoad();
            if (this.fCheckbox != null && this.getLabelControl() != null) {
                String value = this.getPreferenceStore().getString(this.getPreferenceName());
                boolean enabled = !DISABLED_VALUE.equals(value);
                this.fCheckbox.setSelection(enabled);
                this.fWasSelected = enabled;
                this.getComboBoxControl().setEnabled(enabled);
                this.getLabelControl().setEnabled(enabled);
            }
        }

        @Override
        protected void doStore() {
            if (this.fCheckbox != null && !this.fCheckbox.getSelection()) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), DISABLED_VALUE);
            } else {
                super.doStore();
            }
        }

        protected void valueChanged(boolean oldValue, boolean newValue) {
            if (oldValue != newValue) {
                this.fireStateChanged("field_editor_value", oldValue, newValue);
                this.getComboBoxControl().setEnabled(newValue);
                this.getLabelControl().setEnabled(newValue);
            }
        }
    }

    class WatchpointRangeFieldEditor
    extends IntegerFieldEditor {
        private static final String DISABLED_VALUE = "0";
        private Button fCheckbox;
        private boolean fWasSelected;

        public WatchpointRangeFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.getCheckboxControl(parent);
            super.doFillIntoGrid(parent, numColumns);
        }

        private Button getCheckboxControl(Composite parent) {
            if (this.fCheckbox == null) {
                Composite inner = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                inner.setLayout((Layout)layout);
                this.fCheckbox = new Button(inner, 32);
                this.fCheckbox.setFont(parent.getFont());
                this.fCheckbox.setText(this.getLabelText());
                Label label = this.getLabelControl(inner);
                label.setText("");
                label.setVisible(false);
                this.fCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean isSelected = WatchpointRangeFieldEditor.this.fCheckbox.getSelection();
                        WatchpointRangeFieldEditor.this.valueChanged(WatchpointRangeFieldEditor.this.fWasSelected, isSelected);
                        WatchpointRangeFieldEditor.this.fWasSelected = isSelected;
                    }
                });
            } else {
                this.checkParent((Control)this.fCheckbox.getParent(), parent);
            }
            return this.fCheckbox;
        }

        protected boolean checkState() {
            if (this.fCheckbox != null && !this.fCheckbox.getSelection()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        public Label getLabelControl(Composite parent) {
            Label label = this.getLabelControl();
            if (label == null) {
                return super.getLabelControl(parent);
            }
            this.checkParent((Control)label.getParent(), parent);
            return label;
        }

        protected void doLoad() {
            if (this.getTextControl() != null && this.fCheckbox != null && this.getLabelControl() != null) {
                this.oldValue = this.getPreferenceStore().getString(this.getPreferenceName());
                boolean enabled = !DISABLED_VALUE.equals(this.oldValue);
                this.getTextControl().setText(enabled ? this.oldValue : "");
                this.fCheckbox.setSelection(enabled);
                this.fWasSelected = enabled;
                this.getTextControl().setEnabled(enabled);
                this.getLabelControl().setEnabled(enabled);
            }
        }

        protected void doStore() {
            if (this.fCheckbox != null && !this.fCheckbox.getSelection()) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), DISABLED_VALUE);
            } else {
                Text text = this.getTextControl();
                if (text != null) {
                    this.getPreferenceStore().setValue(this.getPreferenceName(), text.getText().trim());
                }
            }
        }

        public int getIntValue() throws NumberFormatException {
            if (this.fCheckbox != null && !this.fCheckbox.getSelection()) {
                return 0;
            }
            return super.getIntValue();
        }

        protected void valueChanged(boolean oldValue, boolean newValue) {
            if (oldValue != newValue) {
                this.valueChanged();
                this.fireStateChanged("field_editor_value", oldValue, newValue);
                this.getTextControl().setEnabled(newValue);
                this.getLabelControl().setEnabled(newValue);
            }
        }
    }
}

