/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.MulticoreVisualizerUIPlugin;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCPU;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerModel;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerThread;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCPU;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerMarquee;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerThread;
import org.eclipse.cdt.visualizer.ui.canvas.GraphicCanvas;
import org.eclipse.cdt.visualizer.ui.plugin.CDTVisualizerUIPlugin;
import org.eclipse.cdt.visualizer.ui.util.GUIUtils;
import org.eclipse.cdt.visualizer.ui.util.MouseMonitor;
import org.eclipse.cdt.visualizer.ui.util.SelectionManager;
import org.eclipse.cdt.visualizer.ui.util.SelectionUtils;
import org.eclipse.cdt.visualizer.ui.util.Timer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MulticoreVisualizerCanvas
extends GraphicCanvas
implements ISelectionProvider {
    protected static final int CANVAS_UPDATE_INTERVAL = 100;
    protected static final int THREAD_SPACING = 8;
    protected Timer m_updateTimer = null;
    protected boolean m_recache = true;
    protected boolean m_recacheState = true;
    protected boolean m_recacheSizes = true;
    protected boolean m_update = true;
    protected Font m_textFont = null;
    protected SelectionManager m_selectionManager;
    protected MulticoreVisualizerMarquee m_marquee = null;
    protected Point m_lastSelectionClick = new Point(0, 0);
    protected MouseMonitor m_mouseMonitor = null;
    protected VisualizerModel m_model = null;
    protected int m_cpu_count = 15;
    protected int m_cores_per_cpu = 3;
    protected ArrayList<MulticoreVisualizerCPU> m_cpus = null;
    protected Hashtable<VisualizerCPU, MulticoreVisualizerCPU> m_cpuMap = null;
    protected ArrayList<MulticoreVisualizerCore> m_cores = null;
    protected Hashtable<VisualizerCore, MulticoreVisualizerCore> m_coreMap = null;
    protected ArrayList<MulticoreVisualizerThread> m_threads = null;
    protected Hashtable<VisualizerThread, MulticoreVisualizerThread> m_threadMap = null;
    protected HashSet<Integer> m_selectedPIDs = null;

    public MulticoreVisualizerCanvas(Composite parent) {
        super(parent);
        this.initMulticoreVisualizerCanvas(parent);
    }

    public void dispose() {
        this.cleanupMulticoreVisualizerCanvas();
        super.dispose();
    }

    protected void initMulticoreVisualizerCanvas(Composite parent) {
        this.m_textFont = CDTVisualizerUIPlugin.getResources().getFont("Luxi Sans", 8);
        this.setFont(this.m_textFont);
        this.m_cpus = new ArrayList();
        this.m_cpuMap = new Hashtable();
        this.m_cores = new ArrayList();
        this.m_coreMap = new Hashtable();
        this.m_threads = new ArrayList();
        this.m_threadMap = new Hashtable();
        this.m_selectedPIDs = new HashSet();
        this.m_mouseMonitor = new MouseMonitor((Control)this){

            public void select(int x, int y, int keys) {
                MulticoreVisualizerCanvas.this.select(x, y, keys);
            }

            public void mouseDoubleClick(int button, int x, int y, int keys) {
                MulticoreVisualizerCanvas.this.select(x, y, keys);
            }

            public void mouseDown(int button, int x, int y, int keys) {
                if (button == 3 && !MulticoreVisualizerCanvas.this.hasSelection()) {
                    MulticoreVisualizerCanvas.this.select(x, y, keys);
                }
            }

            public void drag(int button, int x, int y, int keys, int dragState) {
                if (button == 1) {
                    MulticoreVisualizerCanvas.this.drag(x, y, keys, dragState);
                }
            }
        };
        this.m_marquee = new MulticoreVisualizerMarquee();
        this.m_selectionManager = new SelectionManager((ISelectionProvider)this, "MulticoreVisualizerCanvas selection manager");
        this.m_updateTimer = new Timer(100){

            public void run() {
                MulticoreVisualizerCanvas.this.update();
            }
        };
        this.m_updateTimer.setRepeating(false);
        this.m_updateTimer.start();
    }

    protected void cleanupMulticoreVisualizerCanvas() {
        if (this.m_updateTimer != null) {
            this.m_updateTimer.dispose();
            this.m_updateTimer = null;
        }
        if (this.m_marquee != null) {
            this.m_marquee.dispose();
            this.m_marquee = null;
        }
        if (this.m_mouseMonitor != null) {
            this.m_mouseMonitor.dispose();
            this.m_mouseMonitor = null;
        }
        if (this.m_selectionManager != null) {
            this.m_selectionManager.dispose();
            this.m_selectionManager = null;
        }
        if (this.m_cpus != null) {
            this.m_cpus.clear();
            this.m_cpus = null;
        }
        if (this.m_cpuMap != null) {
            this.m_cpuMap.clear();
            this.m_cpuMap = null;
        }
        if (this.m_cores != null) {
            this.m_cores.clear();
            this.m_cores = null;
        }
        if (this.m_coreMap != null) {
            this.m_coreMap.clear();
            this.m_coreMap = null;
        }
        if (this.m_threads != null) {
            this.m_threads.clear();
            this.m_threads = null;
        }
        if (this.m_threadMap != null) {
            this.m_threadMap.clear();
            this.m_threadMap = null;
        }
        if (this.m_selectedPIDs != null) {
            this.m_selectedPIDs.clear();
            this.m_selectedPIDs = null;
        }
    }

    public VisualizerModel getModel() {
        return this.m_model;
    }

    public void setModel(VisualizerModel model) {
        this.m_model = model;
        this.requestRecache();
        this.requestUpdate();
    }

    public void resized(Rectangle bounds) {
        this.requestRecache(false, true);
    }

    public void requestUpdate() {
        GUIUtils.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                MulticoreVisualizerCanvas.this.m_updateTimer.start();
            }
        });
    }

    public synchronized void requestRecache() {
        this.requestRecache(true, true);
    }

    public synchronized void requestRecache(boolean state, boolean sizes) {
        this.m_recache = true;
        this.m_recacheState |= state;
        this.m_recacheSizes |= sizes;
    }

    public int fitSquareItems(int nitems, int width, int height) {
        int max_edge = 0;
        if (width > height) {
            int items_per_row = nitems;
            while (items_per_row > 0) {
                int edge;
                int w = width / items_per_row;
                int rows = (int)Math.ceil(1.0 * (double)nitems / (double)items_per_row);
                int h = height / rows;
                int n = edge = w < h ? w : h;
                if (edge * rows <= height && edge * items_per_row <= width && edge > max_edge) {
                    max_edge = edge;
                }
                --items_per_row;
            }
        } else {
            int items_per_col = nitems;
            while (items_per_col > 0) {
                int h;
                int edge;
                int cols = (int)Math.ceil(1.0 * (double)nitems / (double)items_per_col);
                int w = width / cols;
                int n = edge = w < (h = height / items_per_col) ? w : h;
                if (edge * cols <= width && edge * items_per_col <= height && edge > max_edge) {
                    max_edge = edge;
                }
                --items_per_col;
            }
        }
        return max_edge;
    }

    public synchronized void recache() {
        if (!this.m_recache) {
            return;
        }
        if (this.m_recacheState) {
            this.clear();
            this.m_cpus.clear();
            this.m_cores.clear();
            this.m_threads.clear();
            if (this.m_model != null) {
                for (VisualizerCPU cpu : this.m_model.getCPUs()) {
                    MulticoreVisualizerCPU mcpu = new MulticoreVisualizerCPU(cpu.getID());
                    this.m_cpus.add(mcpu);
                    this.m_cpuMap.put(cpu, mcpu);
                    for (VisualizerCore core : cpu.getCores()) {
                        MulticoreVisualizerCore mcore = new MulticoreVisualizerCore(mcpu, core.getID());
                        this.m_cores.add(mcore);
                        this.m_coreMap.put(core, mcore);
                    }
                }
            }
            this.m_recacheState = false;
            this.m_recacheSizes = true;
        }
        if (this.m_recacheSizes) {
            int cpu_height;
            int cpu_width;
            int ncores;
            int core_edge;
            int core_size;
            int cpu_margin = 8;
            int cpu_separation = 6;
            int core_margin = 4;
            int core_separation = 2;
            Rectangle bounds = this.getClientArea();
            GUIUtils.inset((Rectangle)bounds, (int)cpu_margin);
            int ncpus = this.m_cpus.size();
            int width = bounds.width + cpu_separation;
            int height = bounds.height + cpu_separation;
            int cpu_edge = this.fitSquareItems(ncpus, width, height);
            int cpu_size = cpu_edge - cpu_separation;
            if (cpu_size < 0) {
                cpu_size = 0;
            }
            if ((core_size = (core_edge = this.fitSquareItems(ncores = this.m_cores.size(), cpu_width = cpu_size - core_margin * 2 + core_separation, cpu_height = cpu_size - core_margin * 2 + core_separation)) - core_separation) < 0) {
                core_size = 0;
            }
            int x = bounds.x;
            int y = bounds.y;
            for (MulticoreVisualizerCPU cpu : this.m_cpus) {
                int left;
                cpu.setBounds(x, y, cpu_size - 1, cpu_size - 1);
                int cx = left = x + core_margin;
                int cy = y + core_margin;
                for (MulticoreVisualizerCore core : cpu.getCores()) {
                    core.setBounds(cx, cy, core_size, core_size);
                    if ((cx += core_size + core_separation) + core_size <= x + cpu_size) continue;
                    cx = left;
                    cy += core_size + core_separation;
                }
                if ((x += cpu_size + cpu_separation) + cpu_size <= bounds.x + width) continue;
                x = bounds.x;
                y += cpu_size + cpu_separation;
            }
            this.m_recacheSizes = false;
        }
    }

    public void paintCanvas(GC gc) {
        this.recache();
        for (MulticoreVisualizerCore multicoreVisualizerCore : this.m_cores) {
            multicoreVisualizerCore.removeAllThreads();
        }
        this.m_threads.clear();
        this.m_threadMap.clear();
        if (this.m_model != null) {
            for (VisualizerThread visualizerThread : this.m_model.getThreads()) {
                VisualizerCore core = visualizerThread.getCore();
                MulticoreVisualizerCore mcore = this.m_coreMap.get(core);
                if (mcore == null) continue;
                MulticoreVisualizerThread mthread = new MulticoreVisualizerThread(mcore, visualizerThread);
                mcore.addThread(mthread);
                this.m_threads.add(mthread);
                this.m_threadMap.put(visualizerThread, mthread);
            }
            for (MulticoreVisualizerCore multicoreVisualizerCore : this.m_cores) {
                int dty;
                Rectangle bounds = multicoreVisualizerCore.getBounds();
                List<MulticoreVisualizerThread> threads = multicoreVisualizerCore.getThreads();
                int threadspotsize = 18;
                int threadheight = threadspotsize + 8;
                int count = threads.size();
                int tileheight = bounds.height - 4;
                int tx = bounds.x + 2;
                int ty = bounds.y + 2;
                int n = dty = count < 1 ? 0 : tileheight / count;
                if (dty > threadheight) {
                    dty = threadheight;
                }
                if (count > 0 && dty * count <= tileheight) {
                    ty = bounds.y + 2 + (tileheight - dty * count) / 2;
                    if (ty < bounds.y + 2) {
                        ty = bounds.y + 2;
                    }
                } else if (count > 0 && (dty = tileheight / count) > threadheight) {
                    dty = threadheight;
                }
                int t = 0;
                for (MulticoreVisualizerThread threadobj : threads) {
                    int y = ty + dty * t++;
                    threadobj.setBounds(tx, y, threadspotsize, threadspotsize);
                }
            }
        }
        this.restoreSelection();
        this.m_selectedPIDs.clear();
        for (MulticoreVisualizerThread multicoreVisualizerThread : this.m_threads) {
            if (!multicoreVisualizerThread.isSelected()) continue;
            this.m_selectedPIDs.add(multicoreVisualizerThread.getPID());
        }
        for (MulticoreVisualizerThread multicoreVisualizerThread : this.m_threads) {
            multicoreVisualizerThread.setProcessSelected(this.m_selectedPIDs.contains(multicoreVisualizerThread.getPID()));
        }
        this.clearCanvas(gc);
        MulticoreVisualizerUIPlugin.getResources();
        for (MulticoreVisualizerCPU multicoreVisualizerCPU : this.m_cpus) {
            multicoreVisualizerCPU.paintContent(gc);
        }
        for (MulticoreVisualizerCore multicoreVisualizerCore : this.m_cores) {
            multicoreVisualizerCore.paintContent(gc);
        }
        for (MulticoreVisualizerCPU multicoreVisualizerCPU : this.m_cpus) {
            multicoreVisualizerCPU.paintDecorations(gc);
        }
        for (MulticoreVisualizerThread multicoreVisualizerThread : this.m_threads) {
            multicoreVisualizerThread.paintContent(gc);
        }
        this.m_marquee.paintContent(gc);
    }

    public void drag(int x, int y, int keys, int dragState) {
        Rectangle region = this.m_mouseMonitor.getDragRegion();
        switch (dragState) {
            case 0: {
                this.m_marquee.setBounds(region);
                this.m_marquee.setVisible(true);
                this.update();
                break;
            }
            case 1: {
                this.m_marquee.setBounds(region);
                this.update();
                break;
            }
            default: {
                this.m_marquee.setBounds(region);
                this.m_marquee.setVisible(false);
                boolean addToSelection = MouseMonitor.isShiftDown((int)keys);
                boolean toggleSelection = MouseMonitor.isControlDown((int)keys);
                this.selectRegion(this.m_marquee.getBounds(), addToSelection, toggleSelection);
                this.m_lastSelectionClick.x = x;
                this.m_lastSelectionClick.y = y;
                this.update();
            }
        }
    }

    public void select(int x, int y, int keys) {
        boolean addToSelection = MouseMonitor.isShiftDown((int)keys);
        boolean toggleSelection = MouseMonitor.isControlDown((int)keys);
        this.selectPoint(x, y, addToSelection, toggleSelection);
    }

    public void selectRegion(Rectangle region, boolean addToSelection, boolean toggleSelection) {
        if (this.m_threads != null) {
            boolean changed = false;
            for (MulticoreVisualizerThread tobj : this.m_threads) {
                boolean within = tobj.isWithin(region);
                if (addToSelection && toggleSelection) {
                    if (!within) continue;
                    tobj.setSelected(false);
                    changed = true;
                    continue;
                }
                if (addToSelection) {
                    if (!within) continue;
                    tobj.setSelected(true);
                    changed = true;
                    continue;
                }
                if (toggleSelection) {
                    if (!within) continue;
                    tobj.setSelected(!tobj.isSelected());
                    changed = true;
                    continue;
                }
                tobj.setSelected(within);
                changed = true;
            }
            if (changed) {
                this.selectionChanged();
            }
        }
    }

    public void selectPoint(int x, int y, boolean addToSelection, boolean toggleSelection) {
        if (this.m_threads != null) {
            boolean bl;
            ArrayList<MulticoreVisualizerThread> threads = new ArrayList<MulticoreVisualizerThread>();
            for (MulticoreVisualizerThread multicoreVisualizerThread : this.m_threads) {
                if (!multicoreVisualizerThread.contains(x, y)) continue;
                threads.add(multicoreVisualizerThread);
                break;
            }
            if (threads.isEmpty()) {
                for (MulticoreVisualizerCore multicoreVisualizerCore : this.m_cores) {
                    if (!multicoreVisualizerCore.contains(x, y)) continue;
                    List<MulticoreVisualizerThread> corethreads = multicoreVisualizerCore.getThreads();
                    threads.addAll(corethreads);
                    break;
                }
            }
            if (addToSelection) {
                int n = 54;
                Rectangle r1 = new Rectangle(this.m_lastSelectionClick.x - n / 2, this.m_lastSelectionClick.y - n / 2, n, n);
                Rectangle r2 = new Rectangle(x - n / 2, y - n / 2, n, n);
                Rectangle region = r1.union(r2);
                for (MulticoreVisualizerThread tobj : this.m_threads) {
                    if (!tobj.isWithin(region)) continue;
                    threads.add(tobj);
                }
            }
            boolean bl2 = false;
            for (MulticoreVisualizerThread tobj : this.m_threads) {
                boolean within = threads.contains((Object)tobj);
                if (addToSelection && toggleSelection) {
                    if (!within) continue;
                    tobj.setSelected(false);
                    bl = true;
                    continue;
                }
                if (addToSelection) {
                    if (!within) continue;
                    tobj.setSelected(true);
                    bl = true;
                    continue;
                }
                if (toggleSelection) {
                    if (!within) continue;
                    tobj.setSelected(!tobj.isSelected());
                    bl = true;
                    continue;
                }
                tobj.setSelected(within);
                bl = true;
            }
            if (bl) {
                this.selectionChanged();
            }
        }
        this.m_lastSelectionClick.x = x;
        this.m_lastSelectionClick.y = y;
    }

    public void selectAll() {
        if (this.m_threads != null) {
            for (MulticoreVisualizerThread tobj : this.m_threads) {
                tobj.setSelected(true);
            }
            this.selectionChanged();
        }
    }

    public void clearSelection() {
        if (this.m_threads != null) {
            for (MulticoreVisualizerThread tobj : this.m_threads) {
                tobj.setSelected(false);
            }
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
        this.selectionChanged(true);
    }

    protected void selectionChanged(boolean raiseEvent) {
        this.updateSelection(raiseEvent);
        this.requestUpdate();
    }

    protected void updateSelection(boolean raiseEvent) {
        HashSet<VisualizerThread> selectedThreads = new HashSet<VisualizerThread>();
        if (this.m_threads != null) {
            for (MulticoreVisualizerThread tobj : this.m_threads) {
                if (!tobj.isSelected()) continue;
                selectedThreads.add(tobj.getThread());
            }
        }
        ISelection selection = SelectionUtils.toSelection(selectedThreads);
        this.setSelection(selection, raiseEvent);
    }

    protected void restoreSelection() {
        ISelection selection = this.getSelection();
        List selectedThreads = SelectionUtils.getSelectedObjects((ISelection)selection);
        if (this.m_threads != null) {
            for (MulticoreVisualizerThread tobj : this.m_threads) {
                tobj.setSelected(selectedThreads.contains(tobj.getThread()));
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionManager.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionManager.removeSelectionChangedListener(listener);
    }

    public void raiseSelectionChangedEvent() {
        this.m_selectionManager.raiseSelectionChangedEvent();
    }

    public boolean hasSelection() {
        return this.m_selectionManager.hasSelection();
    }

    public ISelection getSelection() {
        return this.m_selectionManager.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.m_selectionManager.setSelection(selection);
    }

    public void setSelection(ISelection selection, boolean raiseEvent) {
        this.m_selectionManager.setSelection(selection, raiseEvent);
    }

    public void setSelectionEventsEnabled(boolean enabled) {
        this.m_selectionManager.setSelectionEventsEnabled(enabled);
    }
}

