/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils;

import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DebugViewUtils;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DebugViewTreeWalker {
    TreeModelViewer m_viewer = DebugViewUtils.getDebugViewer();

    public void dispose() {
        this.m_viewer = null;
    }

    public void walk() {
        this.walk(this.getRootPath());
    }

    public void walk(TreePath path) {
        if (path == null) {
            return;
        }
        boolean processChildren = this.processElement(path);
        if (processChildren) {
            this.walkChildren(path);
        }
    }

    public void walkChildren(TreePath path) {
        if (path == null) {
            return;
        }
        int children = this.m_viewer.getChildCount(path);
        if (children > 0) {
            int i = 0;
            while (i < children) {
                Object child = this.m_viewer.getChildElement(path, i);
                if (child != null) {
                    TreePath childPath = path.createChildPath(child);
                    this.walk(childPath);
                }
                ++i;
            }
        }
    }

    public boolean processElement(TreePath path) {
        return true;
    }

    public TreePath getRootPath() {
        TreePath path = null;
        if (this.m_viewer != null) {
            Object root;
            Tree tree = (Tree)this.m_viewer.getControl();
            TreeItem[] items = tree.getItems();
            Object object = root = items == null || items.length == 0 ? null : items[0].getData();
            if (root != null) {
                path = new TreePath(new Object[]{root});
            }
        }
        return path;
    }

    public static TreePath getChildPath(TreePath path, Object childElement) {
        return path.createChildPath(childElement);
    }

    public static Object getElement(TreePath path) {
        return path == null ? null : path.getLastSegment();
    }
}

