/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalFunctionCall
extends CPPEvaluation {
    private final ICPPEvaluation[] fArguments;
    private ICPPFunction fOverload = CPPFunction.UNINITIALIZED_FUNCTION;
    private IType fType;

    public EvalFunctionCall(ICPPEvaluation[] args) {
        this.fArguments = args;
    }

    public ICPPEvaluation[] getArguments() {
        return this.fArguments;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.isTypeDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isValueDependent() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ICPPFunction getOverload(IASTNode point) {
        if (this.fOverload == CPPFunction.UNINITIALIZED_FUNCTION) {
            this.fOverload = this.computeOverload(point);
        }
        return this.fOverload;
    }

    private ICPPFunction computeOverload(IASTNode point) {
        if (this.isTypeDependent()) {
            return null;
        }
        IType t = SemanticUtil.getNestedType(this.fArguments[0].getTypeOrFunctionSet(point), 13);
        if (t instanceof ICPPClassType) {
            return CPPSemantics.findOverloadedOperator(point, this.fArguments, t, OverloadableOperator.PAREN, CPPSemantics.LookupMode.NO_GLOBALS);
        }
        return null;
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        if (this.fType == null) {
            this.fType = this.computeType(point);
        }
        return this.fType;
    }

    private IType computeType(IASTNode point) {
        if (this.isTypeDependent()) {
            return new TypeOfDependentExpression(this);
        }
        ICPPFunction overload = this.getOverload(point);
        if (overload != null) {
            return ExpressionTypes.typeFromFunctionCall(overload);
        }
        ICPPEvaluation arg0 = this.fArguments[0];
        IType t = SemanticUtil.getNestedType(arg0.getTypeOrFunctionSet(point), 13);
        if (t instanceof ICPPClassType) {
            return new ProblemType(10004);
        }
        if (t instanceof IPointerType) {
            t = SemanticUtil.getNestedType(((IPointerType)t).getType(), 13);
        }
        if (t instanceof IFunctionType) {
            t = ExpressionTypes.typeFromReturnType(((IFunctionType)t).getReturnType());
            if (arg0 instanceof EvalMemberAccess) {
                t = ExpressionTypes.restoreTypedefs(t, ((EvalMemberAccess)arg0).getOwnerType());
            }
            return t;
        }
        return new ProblemType(10004);
    }

    @Override
    public IValue getValue(IASTNode point) {
        return Value.create(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        ICPPFunction overload = this.getOverload(point);
        if (overload != null) {
            return ExpressionTypes.valueCategoryFromFunctionCall(overload);
        }
        IType t = this.fArguments[0].getTypeOrFunctionSet(point);
        if (t instanceof IPointerType) {
            t = SemanticUtil.getNestedType(((IPointerType)t).getType(), 13);
        }
        if (t instanceof IFunctionType) {
            return ExpressionTypes.valueCategoryFromReturnType(((IFunctionType)t).getReturnType());
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putByte((byte)8);
        buffer.putShort((short)this.fArguments.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            buffer.marshalEvaluation(arg, includeValue);
            ++n2;
        }
    }

    public static ISerializableEvaluation unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        int len = buffer.getShort();
        ICPPEvaluation[] args = new ICPPEvaluation[len];
        int i = 0;
        while (i < args.length) {
            args[i] = (ICPPEvaluation)buffer.unmarshalEvaluation();
            ++i;
        }
        return new EvalFunctionCall(args);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        ICPPEvaluation[] args = this.fArguments;
        int i = 0;
        while (i < this.fArguments.length) {
            ICPPEvaluation arg = this.fArguments[i].instantiate(tpMap, packOffset, within, maxdepth, point);
            if (arg != this.fArguments[i]) {
                if (args == this.fArguments) {
                    args = new ICPPEvaluation[this.fArguments.length];
                    System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                }
                args[i] = arg;
            }
            ++i;
        }
        if (args == this.fArguments) {
            return this;
        }
        if (args[0] instanceof EvalFunctionSet && this.getOverload(point) == null) {
            args[0] = ((EvalFunctionSet)args[0]).resolveFunction(Arrays.copyOfRange(args, 1, args.length), point);
        }
        return new EvalFunctionCall(args);
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = Integer.MAX_VALUE;
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

