/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class Objdump {
    String[] args;

    public Objdump(String command, String param, String file) throws IOException {
        String[] params;
        if (param == null || param.length() == 0) {
            params = new String[]{};
        } else {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(param);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            params = new String[list.size()];
            list.toArray(params);
        }
        this.init(command, params, file);
    }

    public Objdump(String command, String[] params, String file) throws IOException {
        this.init(command, params, file);
    }

    public Objdump(String file) throws IOException {
        this("objdump", new String[0], file);
    }

    protected void init(String command, String[] params, String file) throws IOException {
        if (params == null || params.length == 0) {
            this.args = new String[]{command, "-C", "-x", "-S", file};
        } else {
            this.args = new String[params.length + 1];
            this.args[0] = command;
            System.arraycopy(params, 0, this.args, 1, params.length);
        }
    }

    public byte[] getOutput() throws IOException {
        int len;
        Process objdump = ProcessFactory.getFactory().exec(this.args);
        StringBuffer buffer = new StringBuffer();
        BufferedReader stdout = new BufferedReader(new InputStreamReader(objdump.getInputStream()));
        char[] buf = new char[512];
        while ((len = stdout.read(buf, 0, buf.length)) != -1) {
            buffer.append(buf, 0, len);
        }
        stdout.close();
        objdump.destroy();
        return buffer.toString().getBytes();
    }

    public void dispose() {
    }
}

