/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.gdb.launching.GDBProcess;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.actions.RefreshAction;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.actions.SelectAllAction;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCPU;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerExecutionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerModel;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerThread;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.Messages;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCanvas;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerEventListener;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerSelectionFinder;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFDebugModel;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFDebugModelListener;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFSessionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DebugViewUtils;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.visualizer.ui.canvas.GraphicCanvas;
import org.eclipse.cdt.visualizer.ui.canvas.GraphicCanvasVisualizer;
import org.eclipse.cdt.visualizer.ui.plugin.CDTVisualizerUIPlugin;
import org.eclipse.cdt.visualizer.ui.util.Colors;
import org.eclipse.cdt.visualizer.ui.util.GUIUtils;
import org.eclipse.cdt.visualizer.ui.util.SelectionUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.internal.ui.commands.actions.DropToFrameCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.ResumeCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepIntoCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepOverCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepReturnCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.SuspendCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateCommandAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public class MulticoreVisualizer
extends GraphicCanvasVisualizer
implements DSFDebugModelListener {
    public static final String ECLIPSE_ID = "org.eclipse.cdt.dsf.gdb.multicorevisualizer.visualizer";
    protected VisualizerModel fDataModel;
    protected MulticoreVisualizerCanvas m_canvas;
    protected DSFSessionState m_sessionState;
    protected MulticoreVisualizerEventListener fEventListener;
    protected TreeModelViewer m_debugViewer = null;
    protected IModelChangedListener m_modelChangedListener = null;
    boolean m_actionsInitialized = false;
    Separator m_separatorAction = null;
    ResumeCommandAction m_resumeAction = null;
    SuspendCommandAction m_suspendAction = null;
    TerminateCommandAction m_terminateAction = null;
    StepReturnCommandAction m_stepReturnAction = null;
    StepOverCommandAction m_stepOverAction = null;
    StepIntoCommandAction m_stepIntoAction = null;
    DropToFrameCommandAction m_dropToFrameAction = null;
    SelectAllAction m_selectAllAction = null;
    RefreshAction m_refreshAction = null;

    public void dispose() {
        super.dispose();
        this.removeDebugViewerListener();
        this.disposeActions();
    }

    public void initializeVisualizer() {
        this.fEventListener = new MulticoreVisualizerEventListener(this);
    }

    public void disposeVisualizer() {
        this.dispose();
    }

    public String getName() {
        return "multicore";
    }

    public String getDisplayName() {
        return Messages.MulticoreVisualizer_name;
    }

    public String getDescription() {
        return Messages.MulticoreVisualizer_tooltip;
    }

    public GraphicCanvas createCanvas(Composite parent) {
        this.m_canvas = new MulticoreVisualizerCanvas(parent);
        this.m_canvas.addSelectionChangedListener((ISelectionChangedListener)this);
        return this.m_canvas;
    }

    public void disposeCanvas() {
        if (this.m_canvas != null) {
            this.m_canvas.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.m_canvas.dispose();
            this.m_canvas = null;
        }
    }

    protected void initializeCanvas(GraphicCanvas canvas) {
        CDTVisualizerUIPlugin.getResources();
        this.m_canvas.setBackground(Colors.BLACK);
        this.m_canvas.setForeground(Colors.GREEN);
    }

    public MulticoreVisualizerCanvas getMulticoreVisualizerCanvas() {
        return (MulticoreVisualizerCanvas)this.getCanvas();
    }

    public VisualizerModel getModel() {
        return this.fDataModel;
    }

    protected void createActions() {
        if (this.m_actionsInitialized) {
            return;
        }
        LaunchView debugView = DebugViewUtils.getDebugView();
        this.m_separatorAction = new Separator();
        this.m_resumeAction = new ResumeCommandAction();
        if (debugView != null) {
            this.m_resumeAction.init((IWorkbenchPart)debugView);
        }
        this.m_suspendAction = new SuspendCommandAction();
        if (debugView != null) {
            this.m_suspendAction.init((IWorkbenchPart)debugView);
        }
        this.m_terminateAction = new TerminateCommandAction();
        if (debugView != null) {
            this.m_terminateAction.init((IWorkbenchPart)debugView);
        }
        this.m_stepReturnAction = new StepReturnCommandAction();
        if (debugView != null) {
            this.m_stepReturnAction.init((IWorkbenchPart)debugView);
        }
        this.m_stepOverAction = new StepOverCommandAction();
        if (debugView != null) {
            this.m_stepOverAction.init((IWorkbenchPart)debugView);
        }
        this.m_stepIntoAction = new StepIntoCommandAction();
        if (debugView != null) {
            this.m_stepIntoAction.init((IWorkbenchPart)debugView);
        }
        this.m_dropToFrameAction = new DropToFrameCommandAction();
        if (debugView != null) {
            this.m_dropToFrameAction.init((IWorkbenchPart)debugView);
        }
        this.m_selectAllAction = new SelectAllAction();
        this.m_selectAllAction.init(this);
        this.m_refreshAction = new RefreshAction();
        this.m_refreshAction.init(this);
        this.m_actionsInitialized = debugView != null;
    }

    protected void updateActions() {
        if (!this.m_actionsInitialized) {
            return;
        }
        boolean enabled = this.hasSelection();
        this.m_selectAllAction.setEnabled(enabled);
        this.m_refreshAction.setEnabled(enabled);
    }

    protected void updateContextMenuActions(Point location) {
    }

    protected void disposeActions() {
        if (this.m_resumeAction != null) {
            this.m_resumeAction.dispose();
            this.m_resumeAction = null;
        }
        if (this.m_suspendAction != null) {
            this.m_suspendAction.dispose();
            this.m_suspendAction = null;
        }
        if (this.m_terminateAction != null) {
            this.m_terminateAction.dispose();
            this.m_terminateAction = null;
        }
        if (this.m_stepReturnAction != null) {
            this.m_stepReturnAction.dispose();
            this.m_stepReturnAction = null;
        }
        if (this.m_stepOverAction != null) {
            this.m_stepOverAction.dispose();
            this.m_stepOverAction = null;
        }
        if (this.m_stepIntoAction != null) {
            this.m_stepIntoAction.dispose();
            this.m_stepIntoAction = null;
        }
        if (this.m_dropToFrameAction != null) {
            this.m_dropToFrameAction.dispose();
            this.m_dropToFrameAction = null;
        }
        if (this.m_selectAllAction != null) {
            this.m_selectAllAction.dispose();
            this.m_selectAllAction = null;
        }
        if (this.m_refreshAction != null) {
            this.m_refreshAction.dispose();
            this.m_refreshAction = null;
        }
        this.m_actionsInitialized = false;
    }

    public void populateToolBar(IToolBarManager toolBarManager) {
        this.createActions();
        toolBarManager.add((IAction)this.m_resumeAction);
        toolBarManager.add((IAction)this.m_suspendAction);
        toolBarManager.add((IAction)this.m_terminateAction);
        toolBarManager.add((IContributionItem)this.m_separatorAction);
        toolBarManager.add((IAction)this.m_stepReturnAction);
        toolBarManager.add((IAction)this.m_stepOverAction);
        toolBarManager.add((IAction)this.m_stepIntoAction);
        toolBarManager.add((IAction)this.m_dropToFrameAction);
        this.updateActions();
    }

    public void populateMenu(IMenuManager menuManager) {
        this.createActions();
        this.updateActions();
    }

    public void populateContextMenu(IMenuManager menuManager) {
        this.createActions();
        menuManager.add((IAction)this.m_resumeAction);
        menuManager.add((IAction)this.m_suspendAction);
        menuManager.add((IAction)this.m_terminateAction);
        menuManager.add((IContributionItem)this.m_separatorAction);
        menuManager.add((IAction)this.m_stepReturnAction);
        menuManager.add((IAction)this.m_stepOverAction);
        menuManager.add((IAction)this.m_stepIntoAction);
        menuManager.add((IAction)this.m_dropToFrameAction);
        menuManager.add((IContributionItem)this.m_separatorAction);
        menuManager.add((IAction)this.m_selectAllAction);
        menuManager.add((IAction)this.m_refreshAction);
        this.updateActions();
        Point location = this.m_viewer.getContextMenuLocation();
        this.updateContextMenuActions(location);
    }

    public void visualizerSelected() {
        this.updateActions();
    }

    public void visualizerDeselected() {
    }

    public int handlesSelection(ISelection selection) {
        int result = 0;
        Object sel = SelectionUtils.getSelectedObject((ISelection)selection);
        result = sel instanceof GdbLaunch || sel instanceof GDBProcess || sel instanceof IDMVMContext ? 1 : 0;
        this.updateDebugViewListener();
        return result;
    }

    protected void updateDebugViewListener() {
        this.attachDebugViewerListener();
    }

    protected void attachDebugViewerListener() {
        if (this.m_debugViewer == null) {
            this.m_debugViewer = DebugViewUtils.getDebugViewer();
            if (this.m_debugViewer != null) {
                this.m_modelChangedListener = new IModelChangedListener(){

                    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
                        GUIUtils.exec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MulticoreVisualizer.this.refresh();
                            }
                        });
                    }
                };
                this.m_debugViewer.addModelChangedListener(this.m_modelChangedListener);
            }
        }
    }

    protected void removeDebugViewerListener() {
        if (this.m_modelChangedListener != null && this.m_debugViewer != null) {
            this.m_debugViewer.removeModelChangedListener(this.m_modelChangedListener);
            this.m_debugViewer = null;
            this.m_modelChangedListener = null;
        }
    }

    public void workbenchSelectionChanged(ISelection selection) {
        this.refresh();
        this.updateDebugViewListener();
    }

    public void refresh() {
        boolean changed = this.updateDebugContext();
        if (!changed) {
            this.updateCanvasSelection();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection debugViewSelection = this.visualizerToDebugViewSelection(this.getSelection());
        DebugViewUtils.setDebugViewSelection(debugViewSelection);
        this.updateActions();
    }

    protected ISelection visualizerToDebugViewSelection(ISelection visualizerSelection) {
        MulticoreVisualizerSelectionFinder selectionFinder = new MulticoreVisualizerSelectionFinder();
        ISelection workbenchSelection = selectionFinder.findSelection(visualizerSelection);
        return workbenchSelection;
    }

    protected ISelection workbenchToVisualizerSelection(ISelection workbenchSelection) {
        ISelection visualizerSelection = null;
        List items = SelectionUtils.getSelectedObjects((ISelection)workbenchSelection);
        VisualizerModel model = this.m_canvas.getModel();
        if (model != null) {
            HashSet<VisualizerThread> selected = new HashSet<VisualizerThread>();
            for (Object item : items) {
                int tid;
                if (!(item instanceof IDMVMContext)) continue;
                IDMContext context = ((IDMVMContext)item).getDMContext();
                IMIProcessDMContext processContext = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIProcessDMContext.class);
                int pid = Integer.parseInt(processContext.getProcId());
                IMIExecutionDMContext execContext = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
                int n = tid = execContext == null ? 0 : execContext.getThreadId();
                if (tid == 0) {
                    List<VisualizerThread> threads = model.getThreadsForProcess(pid);
                    if (threads == null) continue;
                    selected.addAll(threads);
                    continue;
                }
                VisualizerThread thread = model.getThread(tid);
                if (thread == null) continue;
                selected.add(thread);
            }
            visualizerSelection = SelectionUtils.toSelection(selected);
        }
        return visualizerSelection;
    }

    public boolean updateDebugContext() {
        ILaunch launch;
        String sessionId = null;
        IAdaptable debugContext = DebugUITools.getDebugContext();
        if (debugContext instanceof IDMVMContext) {
            sessionId = ((IDMVMContext)debugContext).getDMContext().getSessionId();
        } else if (debugContext instanceof GdbLaunch) {
            GdbLaunch gdbLaunch = (GdbLaunch)debugContext;
            if (!gdbLaunch.isTerminated()) {
                sessionId = gdbLaunch.getSession().getId();
            }
        } else if (debugContext instanceof GDBProcess && !(launch = ((GDBProcess)debugContext).getLaunch()).isTerminated() && launch instanceof GdbLaunch) {
            sessionId = ((GdbLaunch)launch).getSession().getId();
        }
        return this.setDebugSession(sessionId);
    }

    public boolean setDebugSession(String sessionId) {
        boolean changed = true;
        if (this.m_sessionState != null && !this.m_sessionState.getSessionID().equals(sessionId)) {
            this.m_sessionState.removeServiceEventListener(this.fEventListener);
            this.m_sessionState.dispose();
            this.m_sessionState = null;
            changed = true;
        }
        if (this.m_sessionState == null && sessionId != null) {
            this.m_sessionState = new DSFSessionState(sessionId);
            this.m_sessionState.addServiceEventListener(this.fEventListener);
            changed = true;
        }
        if (changed) {
            this.update();
        }
        return changed;
    }

    public void update() {
        if (this.m_sessionState == null) {
            this.setCanvasModel(null);
            return;
        }
        this.m_sessionState.execute(new DsfRunnable(){

            public void run() {
                MulticoreVisualizer.this.getVisualizerModel();
            }
        });
    }

    protected void setCanvasModel(VisualizerModel model) {
        final VisualizerModel model_f = model;
        GUIUtils.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                MulticoreVisualizer.this.m_canvas.setModel(model_f);
                MulticoreVisualizer.this.updateCanvasSelectionInternal();
            }
        });
    }

    protected void updateCanvasSelection() {
        GUIUtils.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                MulticoreVisualizer.this.updateCanvasSelectionInternal();
            }
        });
    }

    protected void updateCanvasSelectionInternal() {
        this.updateCanvasSelectionInternal(SelectionUtils.getWorkbenchSelection());
    }

    protected void updateCanvasSelectionInternal(ISelection selection) {
        ISelection canvasSelection = this.workbenchToVisualizerSelection(selection);
        if (canvasSelection != null) {
            this.m_canvas.setSelection(canvasSelection, false);
        }
    }

    public void selectAll() {
        this.m_canvas.selectAll();
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getVisualizerModel() {
        this.fDataModel = new VisualizerModel();
        DSFDebugModel.getCPUs(this.m_sessionState, this, this.fDataModel);
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getVisualizerModelDone(VisualizerModel model) {
        model.sort();
        this.setCanvasModel(model);
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getCPUsDone(IGDBHardwareAndOS.ICPUDMContext[] cpuContexts, Object arg) {
        VisualizerModel model = (VisualizerModel)arg;
        if (cpuContexts == null || cpuContexts.length == 0) {
            model.addCPU(new VisualizerCPU(0));
            model.getTodo().add(1);
            DSFDebugModel.getCores(this.m_sessionState, this, model);
        } else {
            int count = cpuContexts.length;
            model.getTodo().add(count);
            IGDBHardwareAndOS.ICPUDMContext[] iCPUDMContextArray = cpuContexts;
            int n = cpuContexts.length;
            int n2 = 0;
            while (n2 < n) {
                IGDBHardwareAndOS.ICPUDMContext cpuContext = iCPUDMContextArray[n2];
                int cpuID = Integer.parseInt(cpuContext.getId());
                model.addCPU(new VisualizerCPU(cpuID));
                DSFDebugModel.getCores(this.m_sessionState, cpuContext, this, model);
                ++n2;
            }
        }
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getCoresDone(IGDBHardwareAndOS.ICPUDMContext cpuContext, IGDBHardwareAndOS.ICoreDMContext[] coreContexts, Object arg) {
        VisualizerModel model = (VisualizerModel)arg;
        if (coreContexts != null && coreContexts.length != 0) {
            int cpuID = Integer.parseInt(cpuContext.getId());
            VisualizerCPU cpu = model.getCPU(cpuID);
            int count = coreContexts.length;
            model.getTodo().add(count);
            IGDBHardwareAndOS.ICoreDMContext[] iCoreDMContextArray = coreContexts;
            int n = coreContexts.length;
            int n2 = 0;
            while (n2 < n) {
                IGDBHardwareAndOS.ICoreDMContext coreContext = iCoreDMContextArray[n2];
                int coreID = Integer.parseInt(coreContext.getId());
                cpu.addCore(new VisualizerCore(cpu, coreID));
                DSFDebugModel.getThreads(this.m_sessionState, cpuContext, coreContext, this, model);
                ++n2;
            }
        }
        this.done(1, model);
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getThreadsDone(IGDBHardwareAndOS.ICPUDMContext cpuContext, IGDBHardwareAndOS.ICoreDMContext coreContext, IDMContext[] threadContexts, Object arg) {
        VisualizerModel model = (VisualizerModel)arg;
        if (threadContexts != null && threadContexts.length != 0) {
            int count = threadContexts.length;
            model.getTodo().add(count);
            IDMContext[] iDMContextArray = threadContexts;
            int n = threadContexts.length;
            int n2 = 0;
            while (n2 < n) {
                IDMContext threadContext = iDMContextArray[n2];
                IMIExecutionDMContext execContext = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)threadContext, IMIExecutionDMContext.class);
                DSFDebugModel.getThreadData(this.m_sessionState, cpuContext, coreContext, execContext, this, model);
                ++n2;
            }
        }
        this.done(1, model);
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getThreadDataDone(IGDBHardwareAndOS.ICPUDMContext cpuContext, IGDBHardwareAndOS.ICoreDMContext coreContext, IMIExecutionDMContext execContext, IProcesses.IThreadDMData threadData, Object arg) {
        DSFDebugModel.getThreadExecutionState(this.m_sessionState, cpuContext, coreContext, execContext, threadData, this, arg);
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getThreadExecutionStateDone(IGDBHardwareAndOS.ICPUDMContext cpuContext, IGDBHardwareAndOS.ICoreDMContext coreContext, IMIExecutionDMContext execContext, IProcesses.IThreadDMData threadData, VisualizerExecutionState state, Object arg) {
        VisualizerModel model = (VisualizerModel)arg;
        int cpuID = Integer.parseInt(cpuContext.getId());
        VisualizerCPU cpu = model.getCPU(cpuID);
        int coreID = Integer.parseInt(coreContext.getId());
        VisualizerCore core = cpu.getCore(coreID);
        if (state == null) {
            state = VisualizerExecutionState.RUNNING;
        }
        IMIProcessDMContext processContext = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)execContext, IMIProcessDMContext.class);
        int pid = Integer.parseInt(processContext.getProcId());
        int tid = execContext.getThreadId();
        String osTIDValue = threadData.getId();
        int osTid = osTIDValue == null ? tid : Integer.parseInt(osTIDValue);
        model.addThread(new VisualizerThread(core, pid, osTid, tid, state));
        this.done(1, model);
    }

    protected void done(int n, VisualizerModel model) {
        model.getTodo().done(n);
        if (model.getTodo().isDone()) {
            this.getVisualizerModelDone(model);
        }
    }
}

