/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.MulticoreVisualizerUIPlugin;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerExecutionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerThread;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizer;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFDebugModel;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.command.events.IMIDMEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISignalEvent;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;

public class MulticoreVisualizerEventListener {
    protected MulticoreVisualizer fVisualizer;

    public MulticoreVisualizerEventListener(MulticoreVisualizer visualizer) {
        this.fVisualizer = visualizer;
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.ISuspendedDMEvent event) {
        IDMContext context = event.getDMContext();
        if (!(context instanceof IRunControl.IContainerDMContext) && context instanceof IMIExecutionDMContext) {
            int tid = ((IMIExecutionDMContext)context).getThreadId();
            VisualizerThread thread = this.fVisualizer.getModel().getThread(tid);
            if (thread != null) {
                String signalName;
                Object miEvent;
                assert (thread.getState() == VisualizerExecutionState.RUNNING);
                VisualizerExecutionState newState = VisualizerExecutionState.SUSPENDED;
                if (event.getReason() == IRunControl.StateChangeReason.SIGNAL && event instanceof IMIDMEvent && (miEvent = ((IMIDMEvent)event).getMIEvent()) instanceof MISignalEvent && DSFDebugModel.isCrashSignal(signalName = ((MISignalEvent)miEvent).getName())) {
                    newState = VisualizerExecutionState.CRASHED;
                }
                thread.setState(newState);
                this.fVisualizer.getMulticoreVisualizerCanvas().requestUpdate();
            }
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IResumedDMEvent event) {
        IDMContext context = event.getDMContext();
        if (!(context instanceof IRunControl.IContainerDMContext) && context instanceof IMIExecutionDMContext) {
            int tid = ((IMIExecutionDMContext)context).getThreadId();
            VisualizerThread thread = this.fVisualizer.getModel().getThread(tid);
            if (thread != null) {
                assert (thread.getState() == VisualizerExecutionState.SUSPENDED || thread.getState() == VisualizerExecutionState.CRASHED);
                thread.setState(VisualizerExecutionState.RUNNING);
                this.fVisualizer.getMulticoreVisualizerCanvas().requestUpdate();
            }
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IStartedDMEvent event) {
        IDMContext context = event.getDMContext();
        if (!(context instanceof IRunControl.IContainerDMContext) && context instanceof IMIExecutionDMContext) {
            final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)context;
            final IMIProcessDMContext processContext = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)execDmc, IMIProcessDMContext.class);
            IProcesses.IThreadDMContext threadContext = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)execDmc, IProcesses.IThreadDMContext.class);
            DsfServicesTracker tracker = new DsfServicesTracker(MulticoreVisualizerUIPlugin.getBundleContext(), execDmc.getSessionId());
            IProcesses procService = (IProcesses)tracker.getService(IProcesses.class);
            tracker.dispose();
            procService.getExecutionData(threadContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IProcesses.IThreadDMData>(){

                protected void handleSuccess() {
                    String[] cores;
                    IProcesses.IThreadDMData data = (IProcesses.IThreadDMData)this.getData();
                    if (data instanceof IGDBProcesses.IGdbThreadDMData && (cores = ((IGDBProcesses.IGdbThreadDMData)data).getCores()) != null) {
                        if (!$assertionsDisabled && cores.length != 1) {
                            throw new AssertionError();
                        }
                        int coreId = Integer.parseInt(cores[0]);
                        VisualizerCore vCore = MulticoreVisualizerEventListener.this.fVisualizer.getModel().getCore(coreId);
                        int pid = Integer.parseInt(processContext.getProcId());
                        int tid = execDmc.getThreadId();
                        int osTid = 0;
                        try {
                            osTid = Integer.parseInt(data.getId());
                        }
                        catch (NumberFormatException numberFormatException) {}
                        MulticoreVisualizerEventListener.this.fVisualizer.getModel().addThread(new VisualizerThread(vCore, pid, osTid, tid, VisualizerExecutionState.RUNNING));
                        MulticoreVisualizerEventListener.this.fVisualizer.getMulticoreVisualizerCanvas().requestUpdate();
                    }
                }
            });
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IExitedDMEvent event) {
        IDMContext context = event.getDMContext();
        if (!(context instanceof IRunControl.IContainerDMContext) && context instanceof IMIExecutionDMContext) {
            int tid = ((IMIExecutionDMContext)context).getThreadId();
            this.fVisualizer.getModel().markThreadExited(tid);
            this.fVisualizer.getMulticoreVisualizerCanvas().requestUpdate();
        }
    }
}

