/*******************************************************************************
 * Copyright (c) 2009, 2010 Wind River Systems and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Wind River Systems - initial API and implementation
 *     Ericsson                    - Updated hover to use the new Details format
 *******************************************************************************/
package org.eclipse.cdt.dsf.gdb.internal.ui;

import org.eclipse.cdt.dsf.debug.ui.AbstractDsfDebugTextHover;
import org.eclipse.cdt.dsf.gdb.IGdbDebugPreferenceConstants;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.dsf.mi.service.MIExpressions;
import org.eclipse.core.runtime.Platform;

/**
 * Debug editor text hover for GDB.
 * 
 * @since 2.1
 */
public class GdbDebugTextHover extends AbstractDsfDebugTextHover {

    @Override
    protected String getModelId() {
        return GdbLaunchDelegate.GDB_DEBUG_MODEL_ID;
    }

    @Override
	protected String getHoverFormat() {
    	return  MIExpressions.DETAILS_FORMAT;
    }

    @Override
    protected boolean useExpressionExplorer() {
    	if (Platform.getPreferencesService().getBoolean(GdbUIPlugin.PLUGIN_ID,
				IGdbDebugPreferenceConstants.PREF_USE_INSPECTOR_HOVER,
				true, null)) {
    		return true;
    	}
    	return false;
    }
}
